/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.core.models;

import java.net.URL;
import java.util.Objects;
import java.util.function.Predicate;

public class AuthorizationValue {
    private String value;
    private String type;
    private String keyName;
    private Predicate<URL> urlMatcher;

    public AuthorizationValue() {
    }

    public AuthorizationValue(String keyName, String value, String type, Predicate<URL> urlMatcher) {
        this.setKeyName(keyName);
        this.setValue(value);
        this.setType(type);
        this.setUrlMatcher(urlMatcher);
    }

    public AuthorizationValue(String keyName, String value, String type) {
        this(keyName, value, type, url -> true);
    }

    public AuthorizationValue value(String value) {
        this.value = value;
        return this;
    }

    public AuthorizationValue type(String type) {
        this.type = type;
        return this;
    }

    public AuthorizationValue keyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public AuthorizationValue urlMatcher(Predicate<URL> urlMatcher) {
        this.setUrlMatcher(urlMatcher);
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Predicate<URL> getUrlMatcher() {
        return this.urlMatcher;
    }

    public void setUrlMatcher(Predicate<URL> urlMatcher) {
        this.urlMatcher = Objects.requireNonNull(urlMatcher);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.keyName == null ? 0 : this.keyName.hashCode());
        result2 = 31 * result2 + (this.type == null ? 0 : this.type.hashCode());
        result2 = 31 * result2 + (this.value == null ? 0 : this.value.hashCode());
        result2 = 31 * result2 + this.urlMatcher.hashCode();
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationValue other = (AuthorizationValue)obj;
        if (this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.urlMatcher.equals(other.urlMatcher);
    }
}

