/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.processors.OperationProcessor;
import io.swagger.v3.parser.processors.ParameterProcessor;
import io.swagger.v3.parser.util.RefUtils;
import java.util.List;
import java.util.Map;

public class CallbackProcessor {
    private final ResolverCache cache;
    private final OperationProcessor operationProcessor;
    private final ParameterProcessor parameterProcessor;
    private final OpenAPI openAPI;
    private final ExternalRefProcessor externalRefProcessor;

    public CallbackProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.operationProcessor = new OperationProcessor(cache, openAPI);
        this.parameterProcessor = new ParameterProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.openAPI = openAPI;
    }

    public void processCallback(Callback callback) {
        if (callback.get$ref() != null) {
            this.processReferenceCallback(callback);
        }
        for (String name : callback.keySet()) {
            PathItem pathItem = (PathItem)callback.get(name);
            Map<PathItem.HttpMethod, Operation> operationMap = pathItem.readOperationsMap();
            for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = operationMap.get((Object)httpMethod);
                this.operationProcessor.processOperation(operation);
            }
            List<Parameter> parameters2 = pathItem.getParameters();
            if (parameters2 == null) continue;
            for (Parameter parameter : parameters2) {
                this.parameterProcessor.processParameter(parameter);
            }
        }
    }

    public void processReferenceCallback(Callback callback) {
        String newRef;
        String $ref = callback.get$ref();
        RefFormat refFormat = RefUtils.computeRefFormat($ref);
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalCallback($ref, refFormat)) != null) {
            callback.set$ref("#/components/callbacks/" + newRef);
        }
    }
}

