/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExampleProcessor;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.processors.SchemaProcessor;
import io.swagger.v3.parser.util.RefUtils;
import java.util.Map;

public class HeaderProcessor {
    private final ResolverCache cache;
    private final SchemaProcessor schemaProcessor;
    private final ExampleProcessor exampleProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final OpenAPI openAPI;

    public HeaderProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.openAPI = openAPI;
        this.schemaProcessor = new SchemaProcessor(cache, openAPI);
        this.exampleProcessor = new ExampleProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processHeader(Header header2) {
        if (header2.get$ref() != null) {
            String newRef;
            RefFormat refFormat = RefUtils.computeRefFormat(header2.get$ref());
            String $ref = header2.get$ref();
            if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalHeader($ref, refFormat)) != null) {
                header2.set$ref(newRef);
            }
        }
        if (header2.getSchema() != null) {
            this.schemaProcessor.processSchema(header2.getSchema());
        }
        if (header2.getExamples() != null && header2.getExamples() != null) {
            Map<String, Example> examples = header2.getExamples();
            for (String key : examples.keySet()) {
                this.exampleProcessor.processExample(header2.getExamples().get(key));
            }
        }
        Schema schema = null;
        if (header2.getContent() != null) {
            Content content = header2.getContent();
            for (String mediaName : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(mediaName);
                if (mediaType.getSchema() == null || (schema = mediaType.getSchema()) == null) continue;
                this.schemaProcessor.processSchema(schema);
            }
        }
    }
}

