/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.OpenAPIResolver;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.processors.OperationProcessor;
import io.swagger.v3.parser.processors.ParameterProcessor;
import io.swagger.v3.parser.util.RefUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PathsProcessor {
    private final OpenAPI openAPI;
    private final ResolverCache cache;
    private final OpenAPIResolver.Settings settings;
    private final ParameterProcessor parameterProcessor;
    private final OperationProcessor operationProcessor;
    private final ExternalRefProcessor externalRefProcessor;

    public PathsProcessor(ResolverCache cache, OpenAPI openAPI) {
        this(cache, openAPI, new OpenAPIResolver.Settings());
    }

    public PathsProcessor(ResolverCache cache, OpenAPI openAPI, OpenAPIResolver.Settings settings) {
        this.openAPI = openAPI;
        this.cache = cache;
        this.settings = settings;
        this.parameterProcessor = new ParameterProcessor(cache, openAPI);
        this.operationProcessor = new OperationProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processPaths() {
        Paths pathMap = this.openAPI.getPaths();
        if (pathMap == null) {
            return;
        }
        for (String pathStr : pathMap.keySet()) {
            PathItem pathItem = (PathItem)pathMap.get(pathStr);
            this.addParametersToEachOperation(pathItem);
            if (pathItem.get$ref() != null) {
                PathItem resolvedPath = this.processReferencePath(pathItem);
                String pathRef = pathItem.get$ref().split("#")[0];
                if (resolvedPath != null) {
                    this.updateLocalRefs(resolvedPath, pathRef);
                    this.openAPI.path(pathStr, resolvedPath);
                    pathItem = resolvedPath;
                }
            }
            List<Parameter> processedPathParameters = this.parameterProcessor.processParameters(pathItem.getParameters());
            pathItem.setParameters(processedPathParameters);
            Map<PathItem.HttpMethod, Operation> operationMap = pathItem.readOperationsMap();
            for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = operationMap.get((Object)httpMethod);
                this.operationProcessor.processOperation(operation);
            }
        }
    }

    private void addParametersToEachOperation(PathItem pathItem) {
        if (this.settings.addParametersToEachOperation()) {
            List<Operation> operations;
            List<Parameter> parameters2 = pathItem.getParameters();
            if (parameters2 != null && (operations = pathItem.readOperations()) != null) {
                for (Operation operation : operations) {
                    ArrayList<Parameter> parametersToAdd = new ArrayList<Parameter>();
                    List<Parameter> existingParameters = operation.getParameters();
                    if (existingParameters == null) {
                        existingParameters = new ArrayList<Parameter>();
                        operation.setParameters(existingParameters);
                    }
                    for (Parameter parameterToAdd : parameters2) {
                        boolean matched = false;
                        for (Parameter existingParameter : existingParameters) {
                            if (parameterToAdd.getIn() == null || !parameterToAdd.getIn().equals(existingParameter.getIn()) || !parameterToAdd.getName().equals(existingParameter.getName())) continue;
                            matched = true;
                        }
                        if (matched) continue;
                        parametersToAdd.add(parameterToAdd);
                    }
                    if (parametersToAdd.size() <= 0) continue;
                    operation.getParameters().addAll(0, parametersToAdd);
                }
            }
            pathItem.setParameters(null);
        }
    }

    protected void updateLocalRefs(PathItem path2, String pathRef) {
        if (path2.getParameters() != null) {
            List<Parameter> params = path2.getParameters();
            for (Parameter param2 : params) {
                this.updateLocalRefs(param2, pathRef);
            }
        }
        List<Operation> ops = path2.readOperations();
        for (Operation op : ops) {
            if (op.getParameters() != null) {
                for (Parameter param3 : op.getParameters()) {
                    this.updateLocalRefs(param3, pathRef);
                }
            }
            if (op.getResponses() != null) {
                for (ApiResponse response2 : op.getResponses().values()) {
                    this.updateLocalRefs(response2, pathRef);
                }
            }
            if (op.getRequestBody() != null) {
                this.updateLocalRefs(op.getRequestBody(), pathRef);
            }
            if (op.getCallbacks() == null) continue;
            Map<String, Callback> callbacks = op.getCallbacks();
            for (String name : callbacks.keySet()) {
                Callback callback = callbacks.get(name);
                if (callback == null) continue;
                for (String callbackName : callback.keySet()) {
                    PathItem pathItem = (PathItem)callback.get(callbackName);
                    this.updateLocalRefs(pathItem, pathRef);
                }
            }
        }
    }

    protected void updateLocalRefs(ApiResponse response2, String pathRef) {
        if (response2.get$ref() != null && this.isLocalRef(response2.get$ref())) {
            response2.set$ref(this.computeLocalRef(response2.get$ref(), pathRef));
        }
        if (response2.getContent() != null) {
            Content content = response2.getContent();
            for (String key : content.keySet()) {
                Map<String, Example> examples;
                MediaType mediaType = (MediaType)content.get(key);
                if (mediaType.getSchema() != null) {
                    this.updateLocalRefs(mediaType.getSchema(), pathRef);
                }
                if ((examples = ((MediaType)content.get(key)).getExamples()) == null) continue;
                for (Example example : examples.values()) {
                    this.updateLocalRefs(example, pathRef);
                }
            }
        }
    }

    protected void updateLocalRefs(Example example, String pathRef) {
        if (example.get$ref() != null && this.isLocalRef(example.get$ref())) {
            example.set$ref(this.computeLocalRef(example.get$ref(), pathRef));
        }
    }

    protected void updateLocalRefs(Parameter param2, String pathRef) {
        if (param2.get$ref() != null && this.isLocalRef(param2.get$ref())) {
            param2.set$ref(this.computeLocalRef(param2.get$ref(), pathRef));
        }
        if (param2.getSchema() != null) {
            this.updateLocalRefs(param2.getSchema(), pathRef);
        }
        if (param2.getContent() != null) {
            Content content = param2.getContent();
            for (String key : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(key);
                if (mediaType.getSchema() == null) continue;
                this.updateLocalRefs(mediaType.getSchema(), pathRef);
            }
        }
    }

    protected void updateLocalRefs(RequestBody body2, String pathRef) {
        if (body2.get$ref() != null && this.isLocalRef(body2.get$ref())) {
            body2.set$ref(this.computeLocalRef(body2.get$ref(), pathRef));
        }
        if (body2.getContent() != null) {
            Content content = body2.getContent();
            for (String key : content.keySet()) {
                Map<String, Example> examples;
                MediaType mediaType = (MediaType)content.get(key);
                if (mediaType.getSchema() != null) {
                    this.updateLocalRefs(mediaType.getSchema(), pathRef);
                }
                if ((examples = ((MediaType)content.get(key)).getExamples()) == null) continue;
                for (Example example : examples.values()) {
                    this.updateLocalRefs(example, pathRef);
                }
            }
        } else if (body2.get$ref() != null) {
            // empty if block
        }
    }

    protected void updateLocalRefs(Schema model, String pathRef) {
        ArraySchema arraySchema;
        if (model.get$ref() != null) {
            if (this.isLocalRef(model.get$ref())) {
                model.set$ref(this.computeLocalRef(model.get$ref(), pathRef));
            }
        } else if (model.getProperties() != null) {
            if (model.getProperties() != null) {
                Map<String, Schema> properties = model.getProperties();
                for (String key : properties.keySet()) {
                    Schema property = properties.get(key);
                    if (property == null) continue;
                    this.updateLocalRefs(property, pathRef);
                }
            }
        } else if (model instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)model;
            if (composedSchema.getAllOf() != null) {
                for (Schema innerModel : composedSchema.getAllOf()) {
                    this.updateLocalRefs(innerModel, pathRef);
                }
            }
            if (composedSchema.getAnyOf() != null) {
                for (Schema innerModel : composedSchema.getAnyOf()) {
                    this.updateLocalRefs(innerModel, pathRef);
                }
            }
            if (composedSchema.getOneOf() != null) {
                for (Schema innerModel : composedSchema.getOneOf()) {
                    this.updateLocalRefs(innerModel, pathRef);
                }
            }
        } else if (model instanceof ArraySchema && (arraySchema = (ArraySchema)model).getItems() != null) {
            this.updateLocalRefs(arraySchema.getItems(), pathRef);
        }
    }

    protected boolean isLocalRef(String ref) {
        return ref.startsWith("#");
    }

    protected String computeLocalRef(String ref, String prefix) {
        return prefix + ref;
    }

    public PathItem processReferencePath(PathItem pathItem) {
        RefFormat refFormat = RefUtils.computeRefFormat(pathItem.get$ref());
        String $ref = pathItem.get$ref();
        pathItem = RefUtils.isAnExternalRefFormat(refFormat) ? this.externalRefProcessor.processRefToExternalPathItem($ref, refFormat) : this.cache.loadRef(pathItem.get$ref(), refFormat, PathItem.class);
        return pathItem;
    }
}

