/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExampleProcessor;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.processors.HeaderProcessor;
import io.swagger.v3.parser.processors.LinkProcessor;
import io.swagger.v3.parser.processors.SchemaProcessor;
import io.swagger.v3.parser.util.RefUtils;
import java.util.Map;

public class ResponseProcessor {
    private final SchemaProcessor schemaProcessor;
    private final HeaderProcessor headerProcessor;
    private final LinkProcessor linkProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final ExampleProcessor exampleProcessor;
    private final ResolverCache cache;
    private final OpenAPI openAPI;

    public ResponseProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.schemaProcessor = new SchemaProcessor(cache, openAPI);
        this.headerProcessor = new HeaderProcessor(cache, openAPI);
        this.linkProcessor = new LinkProcessor(cache, openAPI);
        this.exampleProcessor = new ExampleProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.cache = cache;
        this.openAPI = openAPI;
    }

    public void processResponse(ApiResponse response2) {
        if (response2.get$ref() != null) {
            this.processReferenceResponse(response2);
        }
        Schema schema = null;
        if (response2.getContent() != null) {
            Content content = response2.getContent();
            for (String mediaName : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(mediaName);
                if (mediaType.getSchema() != null && (schema = mediaType.getSchema()) != null) {
                    this.schemaProcessor.processSchema(schema);
                }
                if (mediaType.getExamples() == null) continue;
                for (Example ex : mediaType.getExamples().values()) {
                    this.exampleProcessor.processExample(ex);
                }
            }
        }
        if (response2.getHeaders() != null) {
            Map<String, Header> headers2 = response2.getHeaders();
            for (String headerName : headers2.keySet()) {
                Header header2 = headers2.get(headerName);
                this.headerProcessor.processHeader(header2);
            }
        }
        if (response2.getLinks() != null) {
            Map<String, Link> links = response2.getLinks();
            for (String linkName : links.keySet()) {
                Link link = links.get(linkName);
                this.linkProcessor.processLink(link);
            }
        }
    }

    public void processReferenceResponse(ApiResponse response2) {
        RefFormat refFormat = RefUtils.computeRefFormat(response2.get$ref());
        String $ref = response2.get$ref();
        if (RefUtils.isAnExternalRefFormat(refFormat)) {
            this.externalRefProcessor.processRefToExternalResponse($ref, refFormat);
        }
    }
}

