/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.parser.models.RefType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineModelResolver {
    private OpenAPI openAPI;
    private boolean skipMatches;
    static Logger LOGGER = LoggerFactory.getLogger(InlineModelResolver.class);
    Map<String, Schema> addedModels = new HashMap<String, Schema>();
    Map<String, String> generatedSignature = new HashMap<String, String>();
    private boolean flattenComposedSchemas;
    private boolean camelCaseFlattenNaming;

    public InlineModelResolver() {
        this(false, false);
    }

    public InlineModelResolver(boolean flattenComposedSchemas, boolean camelCaseFlattenNaming) {
        this.flattenComposedSchemas = flattenComposedSchemas;
        this.camelCaseFlattenNaming = camelCaseFlattenNaming;
    }

    public void flatten(OpenAPI openAPI) {
        this.openAPI = openAPI;
        if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() == null) {
            openAPI.getComponents().setSchemas(new HashMap<String, Schema>());
        }
        Paths paths = openAPI.getPaths();
        if (openAPI.getComponents() == null) {
            openAPI.setComponents(new Components());
        }
        Map<String, Schema> models = openAPI.getComponents().getSchemas();
        if (paths != null) {
            for (String pathname : paths.keySet()) {
                PathItem path2 = (PathItem)paths.get(pathname);
                for (Operation operation : path2.readOperations()) {
                    ApiResponses responses;
                    List<Parameter> parameters2;
                    RequestBody body2 = operation.getRequestBody();
                    if (body2 != null && body2.getContent() != null) {
                        Content content = body2.getContent();
                        for (String string : content.keySet()) {
                            ArraySchema am;
                            Schema<?> inner;
                            String modelName;
                            MediaType mediaType;
                            if (content.get(string) == null || (mediaType = (MediaType)content.get(string)).getSchema() == null) continue;
                            Schema model = mediaType.getSchema();
                            if (model.getProperties() != null && model.getProperties().size() > 0) {
                                this.flattenProperties(model.getProperties(), pathname);
                                modelName = this.resolveModelName(model.getTitle(), "body");
                                mediaType.setSchema(new Schema().$ref(modelName));
                                this.addGenerated(modelName, model);
                                openAPI.getComponents().addSchemas(modelName, model);
                                continue;
                            }
                            if (model instanceof ComposedSchema) {
                                modelName = this.resolveModelName(model.getTitle(), "body");
                                mediaType.setSchema(new Schema().$ref(modelName));
                                this.addGenerated(modelName, model);
                                openAPI.getComponents().addSchemas(modelName, model);
                                continue;
                            }
                            if (!(model instanceof ArraySchema) || !this.isObjectSchema(inner = (am = (ArraySchema)model).getItems()) || inner.getProperties() == null || inner.getProperties().size() <= 0) continue;
                            this.flattenProperties(inner.getProperties(), pathname);
                            String modelName2 = this.resolveModelName(inner.getTitle(), "body");
                            String existing = this.matchGenerated(inner);
                            if (existing != null) {
                                am.setItems(new Schema().$ref(existing));
                                continue;
                            }
                            am.setItems(new Schema().$ref(modelName2));
                            this.addGenerated(modelName2, inner);
                            openAPI.getComponents().addSchemas(modelName2, inner);
                        }
                    }
                    if ((parameters2 = operation.getParameters()) != null) {
                        for (Parameter parameter : parameters2) {
                            ArraySchema am;
                            Schema<?> inner;
                            String modelName;
                            if (parameter.getSchema() == null) continue;
                            Schema model = parameter.getSchema();
                            if (model.getProperties() != null) {
                                if (model.getType() != null && !"object".equals(model.getType()) || model.getProperties() == null || model.getProperties().size() <= 0) continue;
                                this.flattenProperties(model.getProperties(), pathname);
                                modelName = this.resolveModelName(model.getTitle(), parameter.getName());
                                parameter.setSchema(new Schema().$ref(modelName));
                                this.addGenerated(modelName, model);
                                openAPI.getComponents().addSchemas(modelName, model);
                                continue;
                            }
                            if (model instanceof ComposedSchema) {
                                modelName = this.resolveModelName(model.getTitle(), parameter.getName());
                                parameter.setSchema(new Schema().$ref(modelName));
                                this.addGenerated(modelName, model);
                                openAPI.getComponents().addSchemas(modelName, model);
                                continue;
                            }
                            if (!(model instanceof ArraySchema) || !this.isObjectSchema(inner = (am = (ArraySchema)model).getItems()) || inner.getProperties() == null || inner.getProperties().size() <= 0) continue;
                            this.flattenProperties(inner.getProperties(), pathname);
                            String modelName3 = this.resolveModelName(inner.getTitle(), parameter.getName());
                            String existing = this.matchGenerated(inner);
                            if (existing != null) {
                                am.setItems(new Schema().$ref(existing));
                                continue;
                            }
                            am.setItems(new Schema().$ref(modelName3));
                            this.addGenerated(modelName3, am);
                            openAPI.getComponents().addSchemas(modelName3, am);
                        }
                    }
                    if ((responses = operation.getResponses()) == null) continue;
                    for (String key : responses.keySet()) {
                        ApiResponse response2 = (ApiResponse)responses.get(key);
                        if (response2.getContent() == null) continue;
                        Content content = response2.getContent();
                        for (String name : content.keySet()) {
                            Schema innerProperty;
                            String existing;
                            String modelName;
                            MediaType media;
                            if (content.get(name) == null || (media = (MediaType)content.get(name)).getSchema() == null) continue;
                            Schema mediaSchema = media.getSchema();
                            if (this.isObjectSchema(mediaSchema)) {
                                if (mediaSchema.getProperties() == null || mediaSchema.getProperties().size() <= 0) continue;
                                modelName = this.resolveModelName(mediaSchema.getTitle(), "inline_response_" + key);
                                existing = this.matchGenerated(mediaSchema);
                                if (existing != null) {
                                    media.setSchema(this.makeRefProperty(existing, mediaSchema));
                                    continue;
                                }
                                media.setSchema(this.makeRefProperty(modelName, mediaSchema));
                                this.addGenerated(modelName, mediaSchema);
                                openAPI.getComponents().addSchemas(modelName, mediaSchema);
                                continue;
                            }
                            if (mediaSchema instanceof ComposedSchema) {
                                modelName = this.resolveModelName(mediaSchema.getTitle(), "inline_response_" + key);
                                existing = this.matchGenerated(mediaSchema);
                                if (existing != null) {
                                    media.setSchema(this.makeRefProperty(existing, mediaSchema));
                                    continue;
                                }
                                media.setSchema(this.makeRefProperty(modelName, mediaSchema));
                                this.addGenerated(modelName, mediaSchema);
                                openAPI.getComponents().addSchemas(modelName, mediaSchema);
                                continue;
                            }
                            if (mediaSchema instanceof ArraySchema) {
                                ArraySchema ap = (ArraySchema)mediaSchema;
                                Schema<?> inner = ap.getItems();
                                if (!this.isObjectSchema(inner) || inner.getProperties() == null || inner.getProperties().size() <= 0) continue;
                                this.flattenProperties(inner.getProperties(), pathname);
                                String modelName4 = this.resolveModelName(inner.getTitle(), "inline_response_" + key);
                                String existing2 = this.matchGenerated(inner);
                                if (existing2 != null) {
                                    ap.setItems(this.makeRefProperty(existing2, inner));
                                    continue;
                                }
                                ap.setItems(this.makeRefProperty(modelName4, inner));
                                this.addGenerated(modelName4, inner);
                                openAPI.getComponents().addSchemas(modelName4, inner);
                                continue;
                            }
                            if (mediaSchema.getAdditionalProperties() == null || !(mediaSchema.getAdditionalProperties() instanceof Schema) || !this.isObjectSchema(innerProperty = (Schema)mediaSchema.getAdditionalProperties()) || innerProperty.getProperties() == null || innerProperty.getProperties().size() <= 0) continue;
                            this.flattenProperties(innerProperty.getProperties(), pathname);
                            String modelName5 = this.resolveModelName(innerProperty.getTitle(), "inline_response_" + key);
                            String existing3 = this.matchGenerated(innerProperty);
                            if (existing3 != null) {
                                mediaSchema.setAdditionalProperties(new Schema().$ref(existing3));
                                continue;
                            }
                            mediaSchema.setAdditionalProperties(new Schema().$ref(modelName5));
                            this.addGenerated(modelName5, innerProperty);
                            openAPI.getComponents().addSchemas(modelName5, innerProperty);
                        }
                    }
                }
            }
        }
        if (models != null) {
            ArrayList<String> modelNames = new ArrayList<String>(models.keySet());
            for (String modelName : modelNames) {
                Schema model = models.get(modelName);
                if (model.getProperties() != null) {
                    Map<String, Schema> properties = model.getProperties();
                    this.flattenProperties(properties, modelName);
                    this.fixStringModel(model);
                    continue;
                }
                if (model instanceof ArraySchema) {
                    ArraySchema m = (ArraySchema)model;
                    Schema<?> inner = m.getItems();
                    if (!this.isObjectSchema(inner) || inner.getProperties() == null || inner.getProperties().size() <= 0) continue;
                    String innerModelName = this.resolveModelName(inner.getTitle(), modelName + "_inner");
                    String existing = this.matchGenerated(inner);
                    if (existing == null) {
                        openAPI.getComponents().addSchemas(innerModelName, inner);
                        this.addGenerated(innerModelName, inner);
                        m.setItems(new Schema().$ref(innerModelName));
                        continue;
                    }
                    m.setItems(new Schema().$ref(existing));
                    continue;
                }
                if (!(model instanceof ComposedSchema)) continue;
                ComposedSchema composedSchema = (ComposedSchema)model;
                String inlineModelName = "";
                List<Schema> list = null;
                if (composedSchema.getAllOf() != null) {
                    list = composedSchema.getAllOf();
                    inlineModelName = "AllOf";
                } else if (composedSchema.getAnyOf() != null) {
                    list = composedSchema.getAnyOf();
                    inlineModelName = "AnyOf";
                } else if (composedSchema.getOneOf() != null) {
                    list = composedSchema.getOneOf();
                    inlineModelName = "OneOf";
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i).get$ref() != null) continue;
                    Schema schema = list.get(i);
                    if (schema.getProperties() != null) {
                        this.flattenProperties(schema.getProperties(), modelName);
                    }
                    if (!this.flattenComposedSchemas) continue;
                    int position = i + 1;
                    inlineModelName = this.resolveModelName(schema.getTitle(), modelName + inlineModelName + "_" + position);
                    list.set(i, new Schema().$ref(inlineModelName));
                    this.addGenerated(inlineModelName, schema);
                    openAPI.getComponents().addSchemas(inlineModelName, schema);
                }
            }
        }
    }

    private void fixStringModel(Schema m) {
        String example;
        if (m.getType() != null && m.getType().equals("string") && m.getExample() != null && (example = m.getExample().toString()).substring(0, 1).equals("\"") && example.substring(example.length() - 1).equals("\"")) {
            m.setExample(example.substring(1, example.length() - 1));
        }
    }

    private String resolveModelName(String title, String key) {
        if (title == null) {
            return this.uniqueName(key);
        }
        return this.uniqueName(title);
    }

    public String matchGenerated(Schema model) {
        if (this.skipMatches) {
            return null;
        }
        String json = Json.pretty(model);
        if (this.generatedSignature.containsKey(json)) {
            return this.generatedSignature.get(json);
        }
        return null;
    }

    public void addGenerated(String name, Schema model) {
        this.generatedSignature.put(Json.pretty(model), name);
    }

    public String uniqueName(String key) {
        int count = 0;
        boolean done = false;
        if (this.camelCaseFlattenNaming) {
            String concatenated = "";
            for (int i = 0; i < key.split("-").length; ++i) {
                String uniqueKey = key.split("-")[i];
                uniqueKey = uniqueKey.substring(0, 1).toUpperCase() + uniqueKey.substring(1);
                concatenated = concatenated.concat(uniqueKey);
            }
            key = concatenated.replaceAll("[^a-z_\\.A-Z0-9 ]", "");
        } else {
            key = key.replaceAll("[^a-z_\\.A-Z0-9 ]", "");
        }
        while (!done) {
            String name = key;
            if (count > 0) {
                name = key + "_" + count;
            }
            if (this.openAPI.getComponents().getSchemas() == null) {
                return name;
            }
            if (!this.openAPI.getComponents().getSchemas().containsKey(name)) {
                return name;
            }
            ++count;
        }
        return key;
    }

    public void flattenProperties(Map<String, Schema> properties, String path2) {
        if (properties == null) {
            return;
        }
        HashMap<String, Schema> propsToUpdate = new HashMap<String, Schema>();
        HashMap<String, Schema> modelsToAdd = new HashMap<String, Schema>();
        for (String key : properties.keySet()) {
            Schema inner;
            Schema property = properties.get(key);
            if (this.isObjectSchema(property) && property.getProperties() != null && property.getProperties().size() > 0) {
                String modelName = this.resolveModelName(property.getTitle(), path2 + "_" + key);
                Schema model = this.createModelFromProperty(property, modelName);
                String existing = this.matchGenerated(model);
                if (existing != null) {
                    propsToUpdate.put(key, new Schema().$ref(existing));
                    continue;
                }
                propsToUpdate.put(key, new Schema().$ref(RefType.SCHEMAS.getInternalPrefix() + modelName));
                modelsToAdd.put(modelName, model);
                this.addGenerated(modelName, model);
                this.openAPI.getComponents().addSchemas(modelName, model);
                continue;
            }
            if (property instanceof ArraySchema) {
                ArraySchema ap = (ArraySchema)property;
                Schema<?> inner2 = ap.getItems();
                if (!this.isObjectSchema(inner2)) continue;
                if (inner2.getProperties() != null && inner2.getProperties().size() > 0) {
                    this.flattenProperties(inner2.getProperties(), path2);
                    String modelName = this.resolveModelName(inner2.getTitle(), path2 + "_" + key);
                    Schema innerModel = this.createModelFromProperty(inner2, modelName);
                    String existing = this.matchGenerated(innerModel);
                    if (existing != null) {
                        ap.setItems(new Schema().$ref(existing));
                        continue;
                    }
                    ap.setItems(new Schema().$ref(modelName));
                    this.addGenerated(modelName, innerModel);
                    this.openAPI.getComponents().addSchemas(modelName, innerModel);
                    continue;
                }
                if (!(inner2 instanceof ComposedSchema) || !this.flattenComposedSchemas) continue;
                ComposedSchema composedSchema = (ComposedSchema)inner2;
                String modelName = this.resolveModelName(inner2.getTitle(), path2 + "_" + key);
                List<Schema> list = null;
                if (composedSchema.getAllOf() != null) {
                    list = composedSchema.getAllOf();
                } else if (composedSchema.getAnyOf() != null) {
                    list = composedSchema.getAnyOf();
                } else if (composedSchema.getOneOf() != null) {
                    list = composedSchema.getOneOf();
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i).getProperties() == null) continue;
                    this.flattenProperties(list.get(i).getProperties(), modelName);
                }
                Schema innerModel = this.createModelFromProperty(inner2, modelName);
                String existing = this.matchGenerated(innerModel);
                if (existing != null) {
                    ap.setItems(new Schema().$ref(existing));
                    continue;
                }
                ap.setItems(new Schema().$ref(modelName));
                this.addGenerated(modelName, innerModel);
                this.openAPI.getComponents().addSchemas(modelName, innerModel);
                continue;
            }
            if (property.getAdditionalProperties() == null || !(property.getAdditionalProperties() instanceof Schema) || !this.isObjectSchema(inner = (Schema)property.getAdditionalProperties()) || inner.getProperties() == null || inner.getProperties().size() <= 0) continue;
            this.flattenProperties(inner.getProperties(), path2);
            String modelName = this.resolveModelName(inner.getTitle(), path2 + "_" + key);
            Schema innerModel = this.createModelFromProperty(inner, modelName);
            String existing = this.matchGenerated(innerModel);
            if (existing != null) {
                property.setAdditionalProperties(new Schema().$ref(existing));
                continue;
            }
            property.setAdditionalProperties(new Schema().$ref(modelName));
            this.addGenerated(modelName, innerModel);
            this.openAPI.getComponents().addSchemas(modelName, innerModel);
        }
        if (propsToUpdate.size() > 0) {
            for (String key : propsToUpdate.keySet()) {
                properties.put(key, (Schema)propsToUpdate.get(key));
            }
        }
        for (String key : modelsToAdd.keySet()) {
            this.openAPI.getComponents().addSchemas(key, (Schema)modelsToAdd.get(key));
            this.addedModels.put(key, (Schema)modelsToAdd.get(key));
        }
    }

    public Schema modelFromProperty(ArraySchema object, String path2) {
        Schema<?> inner;
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        if ((inner = object.getItems()) instanceof ObjectSchema) {
            ArraySchema model = new ArraySchema();
            model.setDescription(description);
            model.setExample(example);
            model.setItems(object.getItems());
            return model;
        }
        return null;
    }

    public Schema createModelFromProperty(Schema schema, String path2) {
        String description = schema.getDescription();
        String example = null;
        List<String> requiredList = schema.getRequired();
        Object obj = schema.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        String name = schema.getName();
        XML xml = schema.getXml();
        Map<String, Schema> properties = schema.getProperties();
        if (schema instanceof ComposedSchema && this.flattenComposedSchemas) {
            ComposedSchema composedModel = (ComposedSchema)schema;
            composedModel.setDescription(description);
            composedModel.setExample(example);
            composedModel.setName(name);
            composedModel.setXml(xml);
            composedModel.setType(schema.getType());
            composedModel.setRequired(requiredList);
            return composedModel;
        }
        Schema model = new Schema();
        model.setDescription(description);
        model.setExample(example);
        model.setName(name);
        model.setXml(xml);
        model.setType(schema.getType());
        model.setRequired(requiredList);
        if (properties != null) {
            this.flattenProperties(properties, path2);
            model.setProperties(properties);
        }
        return model;
    }

    public Schema modelFromProperty(Schema object, String path2) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        ArraySchema model = new ArraySchema();
        model.setDescription(description);
        model.setExample(example);
        if (object.getAdditionalProperties() != null && object.getAdditionalProperties() instanceof Schema) {
            model.setItems((Schema)object.getAdditionalProperties());
        }
        return model;
    }

    public Schema makeRefProperty(String ref, Schema property) {
        Schema newProperty = new Schema().$ref(ref);
        this.copyVendorExtensions(property, newProperty);
        return newProperty;
    }

    public void copyVendorExtensions(Schema source, Schema target) {
        if (source.getExtensions() != null) {
            Map<String, Object> vendorExtensions = source.getExtensions();
            for (String extName : vendorExtensions.keySet()) {
                target.addExtension(extName, vendorExtensions.get(extName));
            }
        }
    }

    public boolean isSkipMatches() {
        return this.skipMatches;
    }

    public void setSkipMatches(boolean skipMatches) {
        this.skipMatches = skipMatches;
    }

    private boolean isObjectSchema(Schema schema) {
        return schema instanceof ObjectSchema || "object".equalsIgnoreCase(schema.getType()) || schema.getType() == null && schema.getProperties() != null && !schema.getProperties().isEmpty();
    }
}

