/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.io.File;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.ReflectionUtils;

class JBossClassLoaderHandler
implements ClassLoaderHandler {
    private JBossClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "org.jboss.modules.ModuleClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    private static void handleResourceLoader(Object resourceLoader, ClassLoader classLoader, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        File file;
        if (resourceLoader == null) {
            return;
        }
        Object root = ReflectionUtils.getFieldVal(resourceLoader, "root", false);
        File physicalFile = (File)ReflectionUtils.invokeMethod(root, "getPhysicalFile", false);
        String path2 = null;
        if (physicalFile != null) {
            File file2;
            String name = (String)ReflectionUtils.invokeMethod(root, "getName", false);
            path2 = name != null ? (FileUtils.canRead(file2 = new File(physicalFile.getParentFile(), name)) ? file2.getAbsolutePath() : physicalFile.getAbsolutePath()) : physicalFile.getAbsolutePath();
        } else {
            path2 = (String)ReflectionUtils.invokeMethod(root, "getPathName", false);
            if (path2 == null) {
                File file3 = root instanceof Path ? ((Path)root).toFile() : (file = root instanceof File ? (File)root : null);
                if (file != null) {
                    path2 = file.getAbsolutePath();
                }
            }
        }
        if (path2 == null && (file = (File)ReflectionUtils.getFieldVal(resourceLoader, "fileOfJar", false)) != null) {
            path2 = file.getAbsolutePath();
        }
        if (path2 != null) {
            classpathOrderOut.addClasspathEntry((Object)path2, classLoader, scanSpec, log);
        } else if (log != null) {
            log.log("Could not determine classpath for ResourceLoader: " + resourceLoader);
        }
    }

    private static void handleRealModule(Object module, Set<Object> visitedModules, ClassLoader classLoader, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        Object vfsResourceLoaders;
        if (!visitedModules.add(module)) {
            return;
        }
        ClassLoader moduleLoader = (ClassLoader)ReflectionUtils.invokeMethod(module, "getClassLoader", false);
        if (moduleLoader == null) {
            moduleLoader = classLoader;
        }
        if ((vfsResourceLoaders = ReflectionUtils.invokeMethod(moduleLoader, "getResourceLoaders", false)) != null) {
            int n = Array.getLength(vfsResourceLoaders);
            for (int i = 0; i < n; ++i) {
                Object resourceLoader = Array.get(vfsResourceLoaders, i);
                JBossClassLoaderHandler.handleResourceLoader(resourceLoader, moduleLoader, classpathOrderOut, scanSpec, log);
            }
        }
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Object module = ReflectionUtils.invokeMethod(classLoader, "getModule", false);
        Object callerModuleLoader = ReflectionUtils.invokeMethod(module, "getCallerModuleLoader", false);
        HashSet<Object> visitedModules = new HashSet<Object>();
        Map moduleMap = (Map)ReflectionUtils.getFieldVal(callerModuleLoader, "moduleMap", false);
        for (Map.Entry ent : moduleMap.entrySet()) {
            Object val = ent.getValue();
            Object realModule = ReflectionUtils.invokeMethod(val, "getModule", false);
            JBossClassLoaderHandler.handleRealModule(realModule, visitedModules, classLoader, classpathOrder, scanSpec, log);
        }
        Map pathsMap = (Map)ReflectionUtils.invokeMethod(module, "getPaths", false);
        for (Map.Entry ent : pathsMap.entrySet()) {
            for (Object localLoader : (List)ent.getValue()) {
                Object moduleClassLoader = ReflectionUtils.getFieldVal(localLoader, "this$0", false);
                Object realModule = ReflectionUtils.getFieldVal(moduleClassLoader, "module", false);
                JBossClassLoaderHandler.handleRealModule(realModule, visitedModules, classLoader, classpathOrder, scanSpec, log);
            }
        }
    }
}

