/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.CookieStore;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Immutable
public class ResponseProcessCookies
implements HttpResponseInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void process(HttpResponse response2, HttpContext context) throws HttpException, IOException {
        Args.notNull(response2, "HTTP request");
        Args.notNull(context, "HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        CookieSpec cookieSpec = clientContext.getCookieSpec();
        if (cookieSpec == null) {
            this.log.debug("Cookie spec not specified in HTTP context");
            return;
        }
        CookieStore cookieStore = clientContext.getCookieStore();
        if (cookieStore == null) {
            this.log.debug("Cookie store not specified in HTTP context");
            return;
        }
        CookieOrigin cookieOrigin = clientContext.getCookieOrigin();
        if (cookieOrigin == null) {
            this.log.debug("Cookie origin not specified in HTTP context");
            return;
        }
        HeaderIterator it = response2.headerIterator("Set-Cookie");
        this.processCookies(it, cookieSpec, cookieOrigin, cookieStore);
        if (cookieSpec.getVersion() > 0) {
            it = response2.headerIterator("Set-Cookie2");
            this.processCookies(it, cookieSpec, cookieOrigin, cookieStore);
        }
    }

    private void processCookies(HeaderIterator iterator, CookieSpec cookieSpec, CookieOrigin cookieOrigin, CookieStore cookieStore) {
        while (iterator.hasNext()) {
            Header header2 = iterator.nextHeader();
            try {
                List<Cookie> cookies2 = cookieSpec.parse(header2, cookieOrigin);
                for (Cookie cookie2 : cookies2) {
                    try {
                        cookieSpec.validate(cookie2, cookieOrigin);
                        cookieStore.addCookie(cookie2);
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Cookie accepted [" + ResponseProcessCookies.formatCooke(cookie2) + "]");
                    }
                    catch (MalformedCookieException ex) {
                        if (!this.log.isWarnEnabled()) continue;
                        this.log.warn("Cookie rejected [" + ResponseProcessCookies.formatCooke(cookie2) + "] " + ex.getMessage());
                    }
                }
            }
            catch (MalformedCookieException ex) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn("Invalid cookie header: \"" + header2 + "\". " + ex.getMessage());
            }
        }
    }

    private static String formatCooke(Cookie cookie2) {
        StringBuilder buf = new StringBuilder();
        buf.append(cookie2.getName());
        buf.append("=\"");
        String v = cookie2.getValue();
        if (v != null) {
            if (v.length() > 100) {
                v = v.substring(0, 100) + "...";
            }
            buf.append(v);
        }
        buf.append("\"");
        buf.append(", version:");
        buf.append(Integer.toString(cookie2.getVersion()));
        buf.append(", domain:");
        buf.append(cookie2.getDomain());
        buf.append(", path:");
        buf.append(cookie2.getPath());
        buf.append(", expiry:");
        buf.append(cookie2.getExpiryDate());
        return buf.toString();
    }
}

