/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import org.apache.http.annotation.Immutable;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

@Immutable
public class BasicPathHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie2, String value) throws MalformedCookieException {
        Args.notNull(cookie2, "Cookie");
        cookie2.setPath(!TextUtils.isBlank(value) ? value : "/");
    }

    @Override
    public void validate(Cookie cookie2, CookieOrigin origin) throws MalformedCookieException {
        if (!this.match(cookie2, origin)) {
            throw new CookieRestrictionViolationException("Illegal 'path' attribute \"" + cookie2.getPath() + "\". Path of origin: \"" + origin.getPath() + "\"");
        }
    }

    static boolean pathMatch(String uriPath, String cookiePath) {
        String normalizedCookiePath = cookiePath;
        if (normalizedCookiePath == null) {
            normalizedCookiePath = "/";
        }
        if (normalizedCookiePath.length() > 1 && normalizedCookiePath.endsWith("/")) {
            normalizedCookiePath = normalizedCookiePath.substring(0, normalizedCookiePath.length() - 1);
        }
        if (uriPath.startsWith(normalizedCookiePath)) {
            if (normalizedCookiePath.equals("/")) {
                return true;
            }
            if (uriPath.length() == normalizedCookiePath.length()) {
                return true;
            }
            if (uriPath.charAt(normalizedCookiePath.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean match(Cookie cookie2, CookieOrigin origin) {
        Args.notNull(cookie2, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return BasicPathHandler.pathMatch(origin.getPath(), cookie2.getPath());
    }

    @Override
    public String getAttributeName() {
        return "path";
    }
}

