/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Locale;
import org.apache.http.annotation.Immutable;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.util.Args;

@Immutable
public class RFC2965DomainAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie2, String domain) throws MalformedCookieException {
        Args.notNull(cookie2, "Cookie");
        if (domain == null) {
            throw new MalformedCookieException("Missing value for domain attribute");
        }
        if (domain.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for domain attribute");
        }
        String s = domain;
        s = s.toLowerCase(Locale.ROOT);
        if (!domain.startsWith(".")) {
            s = '.' + s;
        }
        cookie2.setDomain(s);
    }

    public boolean domainMatch(String host, String domain) {
        boolean match = host.equals(domain) || domain.startsWith(".") && host.endsWith(domain);
        return match;
    }

    @Override
    public void validate(Cookie cookie2, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie2, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost().toLowerCase(Locale.ROOT);
        if (cookie2.getDomain() == null) {
            throw new CookieRestrictionViolationException("Invalid cookie state: domain not specified");
        }
        String cookieDomain = cookie2.getDomain().toLowerCase(Locale.ROOT);
        if (cookie2 instanceof ClientCookie && ((ClientCookie)cookie2).containsAttribute("domain")) {
            if (!cookieDomain.startsWith(".")) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + cookie2.getDomain() + "\" violates RFC 2109: domain must start with a dot");
            }
            int dotIndex = cookieDomain.indexOf(46, 1);
            if (!(dotIndex >= 0 && dotIndex != cookieDomain.length() - 1 || cookieDomain.equals(".local"))) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + cookie2.getDomain() + "\" violates RFC 2965: the value contains no embedded dots " + "and the value is not .local");
            }
            if (!this.domainMatch(host, cookieDomain)) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + cookie2.getDomain() + "\" violates RFC 2965: effective host name does not " + "domain-match domain attribute.");
            }
            String effectiveHostWithoutDomain = host.substring(0, host.length() - cookieDomain.length());
            if (effectiveHostWithoutDomain.indexOf(46) != -1) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + cookie2.getDomain() + "\" violates RFC 2965: " + "effective host minus domain may not contain any dots");
            }
        } else if (!cookie2.getDomain().equals(host)) {
            throw new CookieRestrictionViolationException("Illegal domain attribute: \"" + cookie2.getDomain() + "\"." + "Domain of origin: \"" + host + "\"");
        }
    }

    @Override
    public boolean match(Cookie cookie2, CookieOrigin origin) {
        Args.notNull(cookie2, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost().toLowerCase(Locale.ROOT);
        String cookieDomain = cookie2.getDomain();
        if (!this.domainMatch(host, cookieDomain)) {
            return false;
        }
        String effectiveHostWithoutDomain = host.substring(0, host.length() - cookieDomain.length());
        return effectiveHostWithoutDomain.indexOf(46) == -1;
    }

    @Override
    public String getAttributeName() {
        return "domain";
    }
}

