/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.StringTokenizer;
import org.apache.http.annotation.Immutable;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.cookie.SetCookie2;
import org.apache.http.util.Args;

@Immutable
public class RFC2965PortAttributeHandler
implements CommonCookieAttributeHandler {
    private static int[] parsePortAttribute(String portValue) throws MalformedCookieException {
        StringTokenizer st = new StringTokenizer(portValue, ",");
        int[] ports = new int[st.countTokens()];
        try {
            int i = 0;
            while (st.hasMoreTokens()) {
                ports[i] = Integer.parseInt(st.nextToken().trim());
                if (ports[i] < 0) {
                    throw new MalformedCookieException("Invalid Port attribute.");
                }
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid Port attribute: " + e.getMessage());
        }
        return ports;
    }

    private static boolean portMatch(int port2, int[] ports) {
        boolean portInList = false;
        for (int port22 : ports) {
            if (port2 != port22) continue;
            portInList = true;
            break;
        }
        return portInList;
    }

    @Override
    public void parse(SetCookie cookie2, String portValue) throws MalformedCookieException {
        Args.notNull(cookie2, "Cookie");
        if (cookie2 instanceof SetCookie2) {
            SetCookie2 cookie22 = (SetCookie2)cookie2;
            if (portValue != null && !portValue.trim().isEmpty()) {
                int[] ports = RFC2965PortAttributeHandler.parsePortAttribute(portValue);
                cookie22.setPorts(ports);
            }
        }
    }

    @Override
    public void validate(Cookie cookie2, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie2, "Cookie");
        Args.notNull(origin, "Cookie origin");
        int port2 = origin.getPort();
        if (cookie2 instanceof ClientCookie && ((ClientCookie)cookie2).containsAttribute("port") && !RFC2965PortAttributeHandler.portMatch(port2, cookie2.getPorts())) {
            throw new CookieRestrictionViolationException("Port attribute violates RFC 2965: Request port not found in cookie's port list.");
        }
    }

    @Override
    public boolean match(Cookie cookie2, CookieOrigin origin) {
        Args.notNull(cookie2, "Cookie");
        Args.notNull(origin, "Cookie origin");
        int port2 = origin.getPort();
        if (cookie2 instanceof ClientCookie && ((ClientCookie)cookie2).containsAttribute("port")) {
            if (cookie2.getPorts() == null) {
                return false;
            }
            if (!RFC2965PortAttributeHandler.portMatch(port2, cookie2.getPorts())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getAttributeName() {
        return "port";
    }
}

