/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.annotation.Immutable;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Immutable
public class ResponseContent
implements HttpResponseInterceptor {
    private final boolean overwrite;

    public ResponseContent() {
        this(false);
    }

    public ResponseContent(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void process(HttpResponse response2, HttpContext context) throws HttpException, IOException {
        Args.notNull(response2, "HTTP response");
        if (this.overwrite) {
            response2.removeHeaders("Transfer-Encoding");
            response2.removeHeaders("Content-Length");
        } else {
            if (response2.containsHeader("Transfer-Encoding")) {
                throw new ProtocolException("Transfer-encoding header already present");
            }
            if (response2.containsHeader("Content-Length")) {
                throw new ProtocolException("Content-Length header already present");
            }
        }
        ProtocolVersion ver = response2.getStatusLine().getProtocolVersion();
        HttpEntity entity = response2.getEntity();
        if (entity != null) {
            long len = entity.getContentLength();
            if (entity.isChunked() && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                response2.addHeader("Transfer-Encoding", "chunked");
            } else if (len >= 0L) {
                response2.addHeader("Content-Length", Long.toString(entity.getContentLength()));
            }
            if (entity.getContentType() != null && !response2.containsHeader("Content-Type")) {
                response2.addHeader(entity.getContentType());
            }
            if (entity.getContentEncoding() != null && !response2.containsHeader("Content-Encoding")) {
                response2.addHeader(entity.getContentEncoding());
            }
        } else {
            int status = response2.getStatusLine().getStatusCode();
            if (status != 204 && status != 304 && status != 205) {
                response2.addHeader("Content-Length", "0");
            }
        }
    }
}

