/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.handler.codec.http.HttpHeaders;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Response;
import org.asynchttpclient.handler.ProgressAsyncHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncCompletionHandler<T>
implements ProgressAsyncHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncCompletionHandler.class);
    private final Response.ResponseBuilder builder = new Response.ResponseBuilder();

    @Override
    public AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
        this.builder.reset();
        this.builder.accumulate(status);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onHeadersReceived(HttpHeaders headers2) throws Exception {
        this.builder.accumulate(headers2);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        this.builder.accumulate(content);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onTrailingHeadersReceived(HttpHeaders headers2) throws Exception {
        this.builder.accumulate(headers2);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final T onCompleted() throws Exception {
        return this.onCompleted(this.builder.build());
    }

    @Override
    public void onThrowable(Throwable t) {
        LOGGER.debug(t.getMessage(), t);
    }

    public abstract T onCompleted(Response var1) throws Exception;

    @Override
    public AsyncHandler.State onHeadersWritten() {
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onContentWritten() {
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onContentWriteProgress(long amount, long current, long total) {
        return AsyncHandler.State.CONTINUE;
    }
}

