/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.handler.resumable;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.handler.TransferCompletionHandler;
import org.asynchttpclient.handler.resumable.PropertiesBasedResumableProcessor;
import org.asynchttpclient.handler.resumable.ResumableListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumableAsyncHandler
implements AsyncHandler<Response> {
    private static final Logger logger = LoggerFactory.getLogger(TransferCompletionHandler.class);
    private static final ResumableIndexThread resumeIndexThread = new ResumableIndexThread();
    private static Map<String, Long> resumableIndex;
    private final AtomicLong byteTransferred;
    private final ResumableProcessor resumableProcessor;
    private final AsyncHandler<Response> decoratedAsyncHandler;
    private final boolean accumulateBody;
    private String url;
    private Response.ResponseBuilder responseBuilder = new Response.ResponseBuilder();
    private ResumableListener resumableListener = new NULLResumableListener();

    private ResumableAsyncHandler(long byteTransferred, ResumableProcessor resumableProcessor, AsyncHandler<Response> decoratedAsyncHandler, boolean accumulateBody) {
        this.byteTransferred = new AtomicLong(byteTransferred);
        if (resumableProcessor == null) {
            resumableProcessor = new NULLResumableHandler();
        }
        this.resumableProcessor = resumableProcessor;
        resumableIndex = resumableProcessor.load();
        resumeIndexThread.addResumableProcessor(resumableProcessor);
        this.decoratedAsyncHandler = decoratedAsyncHandler;
        this.accumulateBody = accumulateBody;
    }

    public ResumableAsyncHandler(long byteTransferred) {
        this(byteTransferred, null, null, false);
    }

    public ResumableAsyncHandler(boolean accumulateBody) {
        this(0L, null, null, accumulateBody);
    }

    public ResumableAsyncHandler() {
        this(0L, null, null, false);
    }

    public ResumableAsyncHandler(AsyncHandler<Response> decoratedAsyncHandler) {
        this(0L, new PropertiesBasedResumableProcessor(), decoratedAsyncHandler, false);
    }

    public ResumableAsyncHandler(long byteTransferred, AsyncHandler<Response> decoratedAsyncHandler) {
        this(byteTransferred, new PropertiesBasedResumableProcessor(), decoratedAsyncHandler, false);
    }

    public ResumableAsyncHandler(ResumableProcessor resumableProcessor) {
        this(0L, resumableProcessor, null, false);
    }

    public ResumableAsyncHandler(ResumableProcessor resumableProcessor, boolean accumulateBody) {
        this(0L, resumableProcessor, null, accumulateBody);
    }

    @Override
    public AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
        this.responseBuilder.accumulate(status);
        if (status.getStatusCode() != 200 && status.getStatusCode() != 206) {
            return AsyncHandler.State.ABORT;
        }
        this.url = status.getUri().toUrl();
        if (this.decoratedAsyncHandler != null) {
            return this.decoratedAsyncHandler.onStatusReceived(status);
        }
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public void onThrowable(Throwable t) {
        if (this.decoratedAsyncHandler != null) {
            this.decoratedAsyncHandler.onThrowable(t);
        } else {
            logger.debug("", t);
        }
    }

    @Override
    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        if (this.accumulateBody) {
            this.responseBuilder.accumulate(bodyPart);
        }
        AsyncHandler.State state = AsyncHandler.State.CONTINUE;
        try {
            this.resumableListener.onBytesReceived(bodyPart.getBodyByteBuffer());
        }
        catch (IOException ex) {
            return AsyncHandler.State.ABORT;
        }
        if (this.decoratedAsyncHandler != null) {
            state = this.decoratedAsyncHandler.onBodyPartReceived(bodyPart);
        }
        this.byteTransferred.addAndGet(bodyPart.getBodyPartBytes().length);
        this.resumableProcessor.put(this.url, this.byteTransferred.get());
        return state;
    }

    @Override
    public Response onCompleted() throws Exception {
        this.resumableProcessor.remove(this.url);
        this.resumableListener.onAllBytesReceived();
        if (this.decoratedAsyncHandler != null) {
            this.decoratedAsyncHandler.onCompleted();
        }
        return this.responseBuilder.build();
    }

    @Override
    public AsyncHandler.State onHeadersReceived(HttpHeaders headers2) throws Exception {
        this.responseBuilder.accumulate(headers2);
        String contentLengthHeader = headers2.get(HttpHeaderNames.CONTENT_LENGTH);
        if (contentLengthHeader != null && Long.parseLong(contentLengthHeader) == -1L) {
            return AsyncHandler.State.ABORT;
        }
        if (this.decoratedAsyncHandler != null) {
            return this.decoratedAsyncHandler.onHeadersReceived(headers2);
        }
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onTrailingHeadersReceived(HttpHeaders headers2) {
        this.responseBuilder.accumulate(headers2);
        return AsyncHandler.State.CONTINUE;
    }

    public Request adjustRequestRange(Request request) {
        Long ri = resumableIndex.get(request.getUrl());
        if (ri != null) {
            this.byteTransferred.set(ri);
        }
        if (this.resumableListener != null && this.resumableListener.length() > 0L && this.byteTransferred.get() != this.resumableListener.length()) {
            this.byteTransferred.set(this.resumableListener.length());
        }
        RequestBuilder builder = request.toBuilder();
        if (request.getHeaders().get(HttpHeaderNames.RANGE) == null && this.byteTransferred.get() != 0L) {
            builder.setHeader((CharSequence)HttpHeaderNames.RANGE, "bytes=" + this.byteTransferred.get() + "-");
        }
        return builder.build();
    }

    public ResumableAsyncHandler setResumableListener(ResumableListener resumableListener) {
        this.resumableListener = resumableListener;
        return this;
    }

    private static class NULLResumableListener
    implements ResumableListener {
        private long length = 0L;

        private NULLResumableListener() {
        }

        @Override
        public void onBytesReceived(ByteBuffer byteBuffer) {
            this.length += (long)byteBuffer.remaining();
        }

        @Override
        public void onAllBytesReceived() {
        }

        @Override
        public long length() {
            return this.length;
        }
    }

    private static class NULLResumableHandler
    implements ResumableProcessor {
        private NULLResumableHandler() {
        }

        @Override
        public void put(String url, long transferredBytes) {
        }

        @Override
        public void remove(String uri) {
        }

        @Override
        public void save(Map<String, Long> map2) {
        }

        @Override
        public Map<String, Long> load() {
            return new HashMap<String, Long>();
        }
    }

    private static class ResumableIndexThread
    extends Thread {
        public final ConcurrentLinkedQueue<ResumableProcessor> resumableProcessors = new ConcurrentLinkedQueue();

        public ResumableIndexThread() {
            Runtime.getRuntime().addShutdownHook(this);
        }

        public void addResumableProcessor(ResumableProcessor p) {
            this.resumableProcessors.offer(p);
        }

        @Override
        public void run() {
            for (ResumableProcessor p : this.resumableProcessors) {
                p.save(resumableIndex);
            }
        }
    }

    public static interface ResumableProcessor {
        public void put(String var1, long var2);

        public void remove(String var1);

        public void save(Map<String, Long> var1);

        public Map<String, Long> load();
    }
}

