/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.util;

import java.util.List;
import org.asynchttpclient.Param;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.StringBuilderPool;
import org.asynchttpclient.util.Utf8UrlEncoder;

public enum UriEncoder {
    FIXING{

        @Override
        public String encodePath(String path2) {
            return Utf8UrlEncoder.encodePath(path2);
        }

        private void encodeAndAppendQueryParam(StringBuilder sb, CharSequence name, CharSequence value) {
            Utf8UrlEncoder.encodeAndAppendQueryElement(sb, name);
            if (value != null) {
                sb.append('=');
                Utf8UrlEncoder.encodeAndAppendQueryElement(sb, value);
            }
            sb.append('&');
        }

        private void encodeAndAppendQueryParams(StringBuilder sb, List<Param> queryParams2) {
            for (Param param2 : queryParams2) {
                this.encodeAndAppendQueryParam(sb, param2.getName(), param2.getValue());
            }
        }

        @Override
        protected String withQueryWithParams(String query, List<Param> queryParams2) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
            Utf8UrlEncoder.encodeAndAppendQuery(sb, query);
            sb.append('&');
            this.encodeAndAppendQueryParams(sb, queryParams2);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        @Override
        protected String withQueryWithoutParams(String query) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
            Utf8UrlEncoder.encodeAndAppendQuery(sb, query);
            return sb.toString();
        }

        @Override
        protected String withoutQueryWithParams(List<Param> queryParams2) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
            this.encodeAndAppendQueryParams(sb, queryParams2);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
    }
    ,
    RAW{

        @Override
        public String encodePath(String path2) {
            return path2;
        }

        private void appendRawQueryParam(StringBuilder sb, String name, String value) {
            sb.append(name);
            if (value != null) {
                sb.append('=').append(value);
            }
            sb.append('&');
        }

        private void appendRawQueryParams(StringBuilder sb, List<Param> queryParams2) {
            for (Param param2 : queryParams2) {
                this.appendRawQueryParam(sb, param2.getName(), param2.getValue());
            }
        }

        @Override
        protected String withQueryWithParams(String query, List<Param> queryParams2) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
            sb.append(query);
            this.appendRawQueryParams(sb, queryParams2);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        @Override
        protected String withQueryWithoutParams(String query) {
            return query;
        }

        @Override
        protected String withoutQueryWithParams(List<Param> queryParams2) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
            this.appendRawQueryParams(sb, queryParams2);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
    };


    public static UriEncoder uriEncoder(boolean disableUrlEncoding) {
        return disableUrlEncoding ? RAW : FIXING;
    }

    protected abstract String withQueryWithParams(String var1, List<Param> var2);

    protected abstract String withQueryWithoutParams(String var1);

    protected abstract String withoutQueryWithParams(List<Param> var1);

    private String withQuery(String query, List<Param> queryParams2) {
        return MiscUtils.isNonEmpty(queryParams2) ? this.withQueryWithParams(query, queryParams2) : this.withQueryWithoutParams(query);
    }

    private String withoutQuery(List<Param> queryParams2) {
        return MiscUtils.isNonEmpty(queryParams2) ? this.withoutQueryWithParams(queryParams2) : null;
    }

    public Uri encode(Uri uri, List<Param> queryParams2) {
        String newPath = this.encodePath(uri.getPath());
        String newQuery = this.encodeQuery(uri.getQuery(), queryParams2);
        return new Uri(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), newPath, newQuery, uri.getFragment());
    }

    protected abstract String encodePath(String var1);

    private String encodeQuery(String query, List<Param> queryParams2) {
        return MiscUtils.isNonEmpty(query) ? this.withQuery(query, queryParams2) : this.withoutQuery(queryParams2);
    }
}

