/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.Node;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.Scope;

public class Symbol {
    private int declType;
    private int index = -1;
    private String name;
    private Node node;
    private Scope containingTable;

    public Symbol() {
    }

    public Symbol(int declType, String name) {
        this.setName(name);
        this.setDeclType(declType);
    }

    public int getDeclType() {
        return this.declType;
    }

    public void setDeclType(int declType) {
        if (declType != 109 && declType != 87 && declType != 122 && declType != 153 && declType != 154) {
            throw new IllegalArgumentException("Invalid declType: " + declType);
        }
        this.declType = declType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Node getNode() {
        return this.node;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public Scope getContainingTable() {
        return this.containingTable;
    }

    public void setContainingTable(Scope containingTable) {
        this.containingTable = containingTable;
    }

    public String getDeclTypeName() {
        return Token.typeToName(this.declType);
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("Symbol (");
        result2.append(this.getDeclTypeName());
        result2.append(") name=");
        result2.append(this.name);
        if (this.node != null) {
            result2.append(" line=");
            result2.append(this.node.getLineno());
        }
        return result2.toString();
    }
}

