/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.openapi;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import net.ceedubs.ficus.Ficus$;
import org.apache.commons.io.IOUtils;
import pl.touk.nussknacker.engine.api.CirceUtil$;
import pl.touk.nussknacker.engine.api.component.Component;
import pl.touk.nussknacker.engine.api.component.ComponentDefinition;
import pl.touk.nussknacker.engine.api.component.ComponentDefinition$;
import pl.touk.nussknacker.engine.api.component.ComponentProvider;
import pl.touk.nussknacker.engine.api.component.NussknackerVersion;
import pl.touk.nussknacker.engine.api.definition.ServiceWithExplicitMethod;
import pl.touk.nussknacker.engine.api.process.ProcessObjectDependencies;
import pl.touk.nussknacker.engine.util.config.ConfigEnrichments$;
import pl.touk.nussknacker.openapi.OpenAPIServicesConfig;
import pl.touk.nussknacker.openapi.OpenAPIsConfig$;
import pl.touk.nussknacker.openapi.enrichers.BaseSwaggerEnricherCreator;
import pl.touk.nussknacker.openapi.enrichers.BaseSwaggerEnricherCreator$;
import pl.touk.nussknacker.openapi.enrichers.SwaggerEnricherDefinition;
import pl.touk.nussknacker.openapi.enrichers.SwaggerEnrichers;
import pl.touk.nussknacker.openapi.http.backend.DefaultHttpClientConfig$;
import pl.touk.nussknacker.openapi.http.backend.HttpClientConfig;
import pl.touk.nussknacker.openapi.http.backend.HttpClientConfig$;
import pl.touk.nussknacker.openapi.package;
import pl.touk.nussknacker.openapi.package$SwaggerService$;
import pl.touk.nussknacker.openapi.parser.SwaggerParser$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u0017\tAr\n]3o\u0003BK5i\\7q_:,g\u000e\u001e)s_ZLG-\u001a:\u000b\u0005\r!\u0011aB8qK:\f\u0007/\u001b\u0006\u0003\u000b\u0019\t1B\\;tg.t\u0017mY6fe*\u0011q\u0001C\u0001\u0005i>,8NC\u0001\n\u0003\t\u0001Hn\u0001\u0001\u0014\t\u0001a!\u0003\b\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MQR\"\u0001\u000b\u000b\u0005U1\u0012!C2p[B|g.\u001a8u\u0015\t9\u0002$A\u0002ba&T!!\u0007\u0003\u0002\r\u0015tw-\u001b8f\u0013\tYBCA\tD_6\u0004xN\\3oiB\u0013xN^5eKJ\u0004\"!\b\u0013\u000e\u0003yQ!a\b\u0011\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0005\u0012\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\r\n1aY8n\u0013\t)cDA\u0006MCjLHj\\4hS:<\u0007\"B\u0014\u0001\t\u0003A\u0013A\u0002\u001fj]&$h\bF\u0001*!\tQ\u0003!D\u0001\u0003\u0011\u0015a\u0003\u0001\"\u0011.\u00031\u0001(o\u001c<jI\u0016\u0014h*Y7f+\u0005q\u0003CA\u00183\u001d\ti\u0001'\u0003\u00022\u001d\u00051\u0001K]3eK\u001aL!a\r\u001b\u0003\rM#(/\u001b8h\u0015\t\td\u0002C\u00037\u0001\u0011\u0005s'A\rsKN|GN^3D_:4\u0017n\u001a$pe\u0016CXmY;uS>tGC\u0001\u001d?!\tID(D\u0001;\u0015\tY\u0004%\u0001\u0004d_:4\u0017nZ\u0005\u0003{i\u0012aaQ8oM&<\u0007\"B\u001e6\u0001\u0004A\u0004\"\u0002!\u0001\t\u0003\n\u0015AB2sK\u0006$X\rF\u0002C#J\u00032aQ&O\u001d\t!\u0015J\u0004\u0002F\u00116\taI\u0003\u0002H\u0015\u00051AH]8pizJ\u0011aD\u0005\u0003\u0015:\tq\u0001]1dW\u0006<W-\u0003\u0002M\u001b\n!A*[:u\u0015\tQe\u0002\u0005\u0002\u0014\u001f&\u0011\u0001\u000b\u0006\u0002\u0014\u0007>l\u0007o\u001c8f]R$UMZ5oSRLwN\u001c\u0005\u0006w}\u0002\r\u0001\u000f\u0005\u0006'~\u0002\r\u0001V\u0001\rI\u0016\u0004XM\u001c3f]\u000eLWm\u001d\t\u0003+bk\u0011A\u0016\u0006\u0003/Z\tq\u0001\u001d:pG\u0016\u001c8/\u0003\u0002Z-\nI\u0002K]8dKN\u001cxJ\u00196fGR$U\r]3oI\u0016t7-[3t\u0011\u0015Y\u0006\u0001\"\u0005]\u0003i\u0001(/\u001a9be\u0016\u0014\u0015m]3F]JL7\r[3s\u0007J,\u0017\r^8s)\ti6\r\u0005\u0002_C6\tqL\u0003\u0002a\u0005\u0005IQM\u001c:jG\",'o]\u0005\u0003E~\u0013!DQ1tKN;\u0018mZ4fe\u0016s'/[2iKJ\u001c%/Z1u_JDQa\u000f.A\u0002aBQ!\u001a\u0001\u0005B\u0019\fA\"[:D_6\u0004\u0018\r^5cY\u0016$\"a\u001a6\u0011\u00055A\u0017BA5\u000f\u0005\u001d\u0011un\u001c7fC:DQa\u001b3A\u00021\fqA^3sg&|g\u000e\u0005\u0002\u0014[&\u0011a\u000e\u0006\u0002\u0013\u001dV\u001c8o\u001b8bG.,'OV3sg&|g\u000e")
public class OpenAPIComponentProvider
implements ComponentProvider,
LazyLogging {
    private final transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        OpenAPIComponentProvider openAPIComponentProvider = this;
        synchronized (openAPIComponentProvider) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public String providerName() {
        return "openAPI";
    }

    public Config resolveConfigForExecution(Config config) {
        BoxedUnit boxedUnit;
        OpenAPIServicesConfig openAPIsConfig = (OpenAPIServicesConfig)ConfigEnrichments$.MODULE$.RichConfig(config).rootAs(OpenAPIsConfig$.MODULE$.openAPIServicesConfigVR());
        String definition = IOUtils.toString((URL)Ficus$.MODULE$.toFicusConfig(config).as("url", Ficus$.MODULE$.javaURLReader()), StandardCharsets.UTF_8);
        List<package.SwaggerService> services = SwaggerParser$.MODULE$.parse(definition, openAPIsConfig);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Discovered OpenAPI: {}", new Object[]{services.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(package.SwaggerService x$1) {
                    return x$1.name();
                }
            }, List$.MODULE$.canBuildFrom())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        List servicesConfig = (List)services.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ConfigObject apply(package.SwaggerService service2) {
                return ConfigFactory.parseString((String)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps((Object)service2), package$SwaggerService$.MODULE$.encodeSwaggerService()).spaces2()).root();
            }
        }, List$.MODULE$.canBuildFrom());
        return config.withValue("services", (ConfigValue)ConfigValueFactory.fromIterable((Iterable)((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter(servicesConfig).asJava())));
    }

    public List<ComponentDefinition> create(Config config, ProcessObjectDependencies dependencies) {
        OpenAPIServicesConfig openAPIsConfig = (OpenAPIServicesConfig)ConfigEnrichments$.MODULE$.RichConfig(config).rootAs(OpenAPIsConfig$.MODULE$.openAPIServicesConfigVR());
        String serviceDefinitionConfig = config.getList("services").render(ConfigRenderOptions.concise());
        List swaggerServices = (List)CirceUtil$.MODULE$.decodeJsonUnsafe(serviceDefinitionConfig, "Failed to parse service config", Decoder$.MODULE$.decodeList(package$SwaggerService$.MODULE$.decodeSwaggerService()));
        Map fixedParameters = Predef$.MODULE$.Map().empty();
        return ((TraversableOnce)new SwaggerEnrichers(openAPIsConfig.rootUrl(), this.prepareBaseEnricherCreator(config)).enrichers((List<package.SwaggerService>)swaggerServices, (List<String>)Nil$.MODULE$, (Map<String, Function0<Object>>)fixedParameters).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ComponentDefinition apply(SwaggerEnricherDefinition service2) {
                String x$2 = service2.name();
                ServiceWithExplicitMethod x$3 = service2.service();
                Option x$4 = Option$.MODULE$.apply((Object)service2.documentation());
                Option x$5 = ComponentDefinition$.MODULE$.apply$default$3();
                return new ComponentDefinition(x$2, (Component)x$3, x$5, x$4);
            }
        }, Seq$.MODULE$.canBuildFrom())).toList();
    }

    public BaseSwaggerEnricherCreator prepareBaseEnricherCreator(Config config) {
        HttpClientConfig clientConfig = (HttpClientConfig)Ficus$.MODULE$.toFicusConfig(config).getAs("httpClientConfig", Ficus$.MODULE$.optionValueReader(HttpClientConfig$.MODULE$.vr())).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final HttpClientConfig apply() {
                return DefaultHttpClientConfig$.MODULE$.apply();
            }
        });
        return BaseSwaggerEnricherCreator$.MODULE$.apply(clientConfig);
    }

    public boolean isCompatible(NussknackerVersion version) {
        return true;
    }

    public OpenAPIComponentProvider() {
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

