/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.openapi.parser;

import cats.Invariant;
import cats.Semigroupal;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.kernel.Semigroup;
import cats.syntax.ValidatedIdSyntax$;
import cats.syntax.package;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import pl.touk.nussknacker.engine.api.util.ReflectUtils$;
import pl.touk.nussknacker.openapi.ApiKeyConfig;
import pl.touk.nussknacker.openapi.ApiKeyInHeader;
import pl.touk.nussknacker.openapi.OpenAPISecurityConfig;
import pl.touk.nussknacker.openapi.SwaggerSecurity;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SeqView$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;

public final class SecuritiesParser$
implements LazyLogging {
    public static final SecuritiesParser$ MODULE$;
    private final transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SecuritiesParser$();
    }

    private Logger logger$lzycompute() {
        SecuritiesParser$ securitiesParser$ = this;
        synchronized (securitiesParser$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public Validated<NonEmptyList<String>, List<SwaggerSecurity>> parseSwaggerSecurities(List<SecurityRequirement> securityRequirements, Option<Map<String, SecurityScheme>> securitySchemes, Map<String, OpenAPISecurityConfig> securitiesConfigs) {
        Option<Map<String, SecurityScheme>> option;
        block6: {
            Validated validated;
            block3: {
                Validated validated2;
                block5: {
                    block4: {
                        block2: {
                            List<SecurityRequirement> list = securityRequirements;
                            if (!Nil$.MODULE$.equals(list)) break block2;
                            validated = ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)Nil$.MODULE$));
                            break block3;
                        }
                        option = securitySchemes;
                        if (!None$.MODULE$.equals(option)) break block4;
                        validated2 = ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)"There is no security scheme definition in the openAPI definition"));
                        break block5;
                    }
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    Map securitySchemes2 = (Map)some.x();
                    validated2 = (Validated)((TraversableOnce)securityRequirements.view().map((Function1)new Serializable(securitiesConfigs, securitySchemes2){
                        public static final long serialVersionUID = 0L;
                        private final Map securitiesConfigs$1;
                        private final Map securitySchemes$1;

                        public final Validated<NonEmptyList<String>, List<SwaggerSecurity>> apply(SecurityRequirement securityRequirement) {
                            return SecuritiesParser$.MODULE$.matchSecuritiesForRequiredSchemes((List<String>)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)securityRequirement).asScala()).keys().toList(), (Map<String, SecurityScheme>)this.securitySchemes$1, (Map<String, OpenAPISecurityConfig>)this.securitiesConfigs$1);
                        }
                        {
                            this.securitiesConfigs$1 = securitiesConfigs$1;
                            this.securitySchemes$1 = securitySchemes$1;
                        }
                    }, SeqView$.MODULE$.canBuildFrom())).foldLeft((Object)ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)"No security requirement can be met, because:")), (Function2)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Validated<NonEmptyList<String>, List<SwaggerSecurity>> apply(Validated<NonEmptyList<String>, List<SwaggerSecurity>> x$1, Validated<NonEmptyList<String>, List<SwaggerSecurity>> x$2) {
                            return x$1.findValid((Function0)new Serializable(this, x$2){
                                public static final long serialVersionUID = 0L;
                                private final Validated x$2$1;

                                public final Validated<NonEmptyList<String>, List<SwaggerSecurity>> apply() {
                                    return this.x$2$1;
                                }
                                {
                                    this.x$2$1 = x$2$1;
                                }
                            }, NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList());
                        }
                    });
                }
                validated = validated2;
            }
            return validated;
        }
        throw new MatchError(option);
    }

    public Validated<NonEmptyList<String>, List<SwaggerSecurity>> matchSecuritiesForRequiredSchemes(List<String> requiredSchemesNames, Map<String, SecurityScheme> securitySchemes, Map<String, OpenAPISecurityConfig> securitiesConfigs) {
        return (Validated)((LinearSeqOptimized)requiredSchemesNames.map((Function1)new Serializable(securitySchemes, securitiesConfigs){
            public static final long serialVersionUID = 0L;
            private final Map securitySchemes$2;
            private final Map securitiesConfigs$2;

            public final Validated<NonEmptyList<String>, List<SwaggerSecurity>> apply(String schemeName) {
                Validated securityScheme = Validated$.MODULE$.fromOption(this.securitySchemes$2.get((Object)schemeName), (Function0)new Serializable(this, schemeName){
                    public static final long serialVersionUID = 0L;
                    private final String schemeName$1;

                    public final NonEmptyList<String> apply() {
                        return NonEmptyList$.MODULE$.of((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There is no security scheme definition for scheme name \"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schemeName$1})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    }
                    {
                        this.schemeName$1 = schemeName$1;
                    }
                });
                Validated securityConfig = Validated$.MODULE$.fromOption(this.securitiesConfigs$2.get((Object)schemeName), (Function0)new Serializable(this, schemeName){
                    public static final long serialVersionUID = 0L;
                    private final String schemeName$1;

                    public final NonEmptyList<String> apply() {
                        return NonEmptyList$.MODULE$.of((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There is no security config for scheme name \"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schemeName$1})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    }
                    {
                        this.schemeName$1 = schemeName$1;
                    }
                });
                return ((Validated)package.apply$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)securityScheme, (Object)securityConfig)).tupled((Invariant)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).andThen((Function1)new Serializable(this, schemeName){
                    public static final long serialVersionUID = 0L;
                    private final String schemeName$1;

                    public final Validated<NonEmptyList<String>, List<SwaggerSecurity>> apply(Tuple2<SecurityScheme, OpenAPISecurityConfig> t) {
                        return SecuritiesParser$.MODULE$.getSecurityFromSchemeAndConfig((SecurityScheme)t._1(), (OpenAPISecurityConfig)t._2(), this.schemeName$1);
                    }
                    {
                        this.schemeName$1 = schemeName$1;
                    }
                });
            }
            {
                this.securitySchemes$2 = securitySchemes$2;
                this.securitiesConfigs$2 = securitiesConfigs$2;
            }
        }, List$.MODULE$.canBuildFrom())).foldLeft((Object)ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)Nil$.MODULE$)), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Validated<NonEmptyList<String>, List<SwaggerSecurity>> apply(Validated<NonEmptyList<String>, List<SwaggerSecurity>> x$3, Validated<NonEmptyList<String>, List<SwaggerSecurity>> x$4) {
                return x$3.combine(x$4, NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList(), (Semigroup)implicits$.MODULE$.catsKernelStdMonoidForList());
            }
        });
    }

    public Validated<NonEmptyList<String>, List<SwaggerSecurity>> getSecurityFromSchemeAndConfig(SecurityScheme securityScheme, OpenAPISecurityConfig securityConfig, String schemeName) {
        Tuple2 tuple2;
        block4: {
            Validated validated;
            block3: {
                SecurityScheme.Type otherType;
                block2: {
                    tuple2 = new Tuple2((Object)securityScheme.getType(), (Object)securityConfig);
                    if (tuple2 == null) break block2;
                    SecurityScheme.Type type = (SecurityScheme.Type)((Object)tuple2._1());
                    OpenAPISecurityConfig apiKeyConfig = (OpenAPISecurityConfig)tuple2._2();
                    if (!((Object)((Object)SecurityScheme.Type.APIKEY)).equals((Object)type) || !(apiKeyConfig instanceof ApiKeyConfig)) break block2;
                    ApiKeyConfig apiKeyConfig2 = (ApiKeyConfig)apiKeyConfig;
                    validated = this.getApiKeySecurity(securityScheme, apiKeyConfig2, schemeName);
                    break block3;
                }
                if (tuple2 == null || (otherType = (SecurityScheme.Type)((Object)tuple2._1())) == null) break block4;
                SecurityScheme.Type type = otherType;
                String securityConfigClassName = ReflectUtils$.MODULE$.fixedClassSimpleNameWithoutParentModule(securityConfig.getClass());
                validated = ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Security type ", " is not supported yet or (", ", ", ") is a mismatch security scheme type and security config pair"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{type, type, securityConfigClassName}))));
            }
            return validated;
        }
        throw new MatchError((Object)tuple2);
    }

    public Validated<NonEmptyList<String>, List<SwaggerSecurity>> getApiKeySecurity(SecurityScheme securityScheme, ApiKeyConfig apiKeyConfig, String schemeName) {
        Validated validated;
        String name = securityScheme.getName();
        String key = apiKeyConfig.apiKeyValue();
        SecurityScheme.In in = securityScheme.getIn();
        if (((Object)((Object)SecurityScheme.In.HEADER)).equals((Object)in)) {
            ApiKeyInHeader apiKeyInHeader = new ApiKeyInHeader(name, key);
            validated = ValidatedIdSyntax$.MODULE$.validNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)Nil$.MODULE$.$colon$colon((Object)apiKeyInHeader)));
        } else {
            validated = ValidatedIdSyntax$.MODULE$.invalidNel$extension(implicits$.MODULE$.catsSyntaxValidatedId((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Putting APIKEY in ", " is not supported yet"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{in}))));
        }
        return validated;
    }

    private SecuritiesParser$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

