/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.internals;

import cats.effect.IO;
import cats.effect.IO$Async$;
import cats.effect.internals.ArrayStack;
import cats.effect.internals.IOConnection;
import cats.effect.internals.IOConnection$;
import cats.effect.internals.IOContext;
import cats.effect.internals.IOFrame;
import cats.effect.internals.IORunLoop;
import cats.effect.internals.TracingPlatform;
import cats.effect.tracing.IOEvent;
import cats.effect.tracing.IOTrace$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class IORunLoop$ {
    public static IORunLoop$ MODULE$;
    private final List<String> runLoopFilter;
    private final int maxAutoCancelableBatchSize;

    static {
        new IORunLoop$();
    }

    public <A> void start(IO<A> source2, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$loop(source2, IOConnection$.MODULE$.uncancelable(), cb, null, null, null, null);
    }

    public <A> void restart(IO<A> source2, IOContext ctx, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$loop(source2, IOConnection$.MODULE$.uncancelable(), cb, ctx, null, null, null);
    }

    public <A> void startCancelable(IO<A> source2, IOConnection conn, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$loop(source2, conn, cb, null, null, null, null);
    }

    public <A> void restartCancelable(IO<A> source2, IOConnection conn, IOContext ctx, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$loop(source2, conn, cb, ctx, null, null, null);
    }

    public void cats$effect$internals$IORunLoop$$loop(IO<Object> source2, IOConnection cancelable, Function1<Either<Throwable, Object>, BoxedUnit> cb, IOContext ctxRef, IORunLoop.RestartCallback rcbRef, Function1<Object, IO<Object>> bFirstRef, ArrayStack<Function1<Object, IO<Object>>> bRestRef) {
        IO currentIO = source2;
        IOConnection conn = cancelable;
        IOContext ctx = ctxRef;
        IO.Map bFirst = bFirstRef;
        ArrayStack<Object> bRest = bRestRef;
        IORunLoop.RestartCallback rcb = rcbRef;
        boolean hasUnboxed = false;
        Object unboxed = null;
        int currentIndex = 0;
        do {
            BoxedUnit boxedUnit;
            IO<Object> iO;
            if ((iO = currentIO) instanceof IO.Bind) {
                IO.Bind bind = (IO.Bind)iO;
                IO fa = bind.source();
                Function1 bindNext = bind.f();
                if (TracingPlatform.isStackTracing) {
                    Object trace;
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if ((trace = bind.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                currentIO = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Pure) {
                IO.Pure pure = (IO.Pure)iO;
                Object value = pure.a();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Delay) {
                BoxedUnit boxedUnit2;
                IO.Delay delay = (IO.Delay)iO;
                Function0 thunk = delay.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    currentIO = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    currentIO = new IO.RaiseError(e);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (iO instanceof IO.Suspend) {
                IO.Suspend suspend = (IO.Suspend)iO;
                Function0 thunk = suspend.thunk();
                currentIO = IORunLoop$.liftedTree1$1(thunk);
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.RaiseError) {
                IO.RaiseError raiseError;
                IOFrame<Object, IO<Object>> iOFrame;
                IO.RaiseError raiseError2 = (IO.RaiseError)iO;
                Throwable ex = raiseError2.e();
                if (TracingPlatform.isStackTracing && TracingPlatform.enhancedExceptions && ctx != null) {
                    this.augmentException(ex, ctx);
                }
                if ((iOFrame = this.findErrorHandler(bFirst, bRest)) == null) {
                    cb.apply((Object)package$.MODULE$.Left().apply((Object)ex));
                    return;
                }
                try {
                    raiseError = iOFrame.recover(ex);
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable3);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    IO.RaiseError raiseError3 = new IO.RaiseError(e);
                    raiseError = raiseError3;
                }
                IO.RaiseError fa = raiseError;
                bFirst = null;
                currentIO = fa;
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Map) {
                IO.Map map = (IO.Map)iO;
                IO.RaiseError fa = map.source();
                if (TracingPlatform.isStackTracing) {
                    Object trace;
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if ((trace = map.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push(bFirst);
                }
                bFirst = map;
                currentIO = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (iO instanceof IO.Async) {
                    Object trace;
                    IO.Async async = (IO.Async)iO;
                    if (conn == null) {
                        conn = IOConnection$.MODULE$.apply();
                    }
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if (rcb == null) {
                        rcb = new IORunLoop.RestartCallback(conn, cb);
                    }
                    if (TracingPlatform.isStackTracing && (trace = async.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                    rcb.start(async, ctx, bFirst, bRest);
                    return;
                }
                if (iO instanceof IO.ContextSwitch) {
                    BoxedUnit boxedUnit5;
                    IO.ContextSwitch contextSwitch = (IO.ContextSwitch)iO;
                    IO next = contextSwitch.source();
                    Function1<IOConnection, IOConnection> modify2 = contextSwitch.modify();
                    Function4 restore = contextSwitch.restore();
                    IOConnection old = conn != null ? conn : IOConnection$.MODULE$.apply();
                    conn = (IOConnection)modify2.apply((Object)old);
                    currentIO = next;
                    if (conn != old) {
                        if (rcb != null) {
                            rcb.contextSwitch(conn);
                        }
                        if (restore != null) {
                            currentIO = new IO.Bind<Object, Object>(next, new IORunLoop.RestoreContext(old, restore), null);
                            boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit5 = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit5;
                } else if (iO instanceof IO.Trace) {
                    IO.Trace trace = (IO.Trace)iO;
                    IO source3 = trace.source();
                    IOEvent frame = trace.trace();
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    ctx.pushEvent(frame);
                    currentIO = source3;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(iO);
                }
            }
            if (hasUnboxed) {
                IO iO2;
                Function1<Object, IO<Object>> function1 = this.popNextBind(bFirst, bRest);
                if (function1 == null) {
                    cb.apply((Object)package$.MODULE$.Right().apply(unboxed));
                    return;
                }
                try {
                    iO2 = (IO)function1.apply(unboxed);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable4);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable ex = (Throwable)option.get();
                    IO.RaiseError raiseError = new IO.RaiseError(ex);
                    iO2 = raiseError;
                }
                IO fa = iO2;
                hasUnboxed = false;
                unboxed = null;
                bFirst = null;
                currentIO = fa;
                BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
            }
            if (++currentIndex != this.maxAutoCancelableBatchSize) continue;
            if (conn.isCanceled()) {
                return;
            }
            currentIndex = 0;
        } while (true);
    }

    public <A> IO<A> step(IO<A> source2) {
        IO currentIO = source2;
        IO.Map bFirst = null;
        ArrayStack<Object> bRest = null;
        IOContext ctx = null;
        boolean hasUnboxed = false;
        Object unboxed = null;
        do {
            IO iO;
            BoxedUnit boxedUnit;
            IO<A> iO2;
            if ((iO2 = currentIO) instanceof IO.Bind) {
                IO.Bind bind = (IO.Bind)iO2;
                IO fa = bind.source();
                IO.Map bindNext = bind.f();
                if (TracingPlatform.isStackTracing) {
                    Object trace;
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if ((trace = bind.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack<Function1<Object, IO<Object>>>();
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                currentIO = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO2 instanceof IO.Pure) {
                IO.Pure pure = (IO.Pure)iO2;
                Object value = pure.a();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO2 instanceof IO.Delay) {
                BoxedUnit boxedUnit2;
                IO.Delay delay = (IO.Delay)iO2;
                Function0 thunk = delay.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    currentIO = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    currentIO = new IO.RaiseError(e);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (iO2 instanceof IO.Suspend) {
                IO.Suspend suspend = (IO.Suspend)iO2;
                Function0 thunk = suspend.thunk();
                currentIO = IORunLoop$.liftedTree2$1(thunk);
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO2 instanceof IO.RaiseError) {
                IO.RaiseError raiseError;
                IOFrame<Object, IO<Object>> iOFrame;
                IO.RaiseError raiseError2 = (IO.RaiseError)iO2;
                Throwable ex = raiseError2.e();
                if (TracingPlatform.isStackTracing && TracingPlatform.enhancedExceptions && ctx != null) {
                    this.augmentException(ex, ctx);
                }
                if ((iOFrame = this.findErrorHandler(bFirst, bRest)) == null) {
                    return currentIO;
                }
                try {
                    raiseError = iOFrame.recover(ex);
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable3);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    IO.RaiseError raiseError3 = new IO.RaiseError(e);
                    raiseError = raiseError3;
                }
                IO.RaiseError fa = raiseError;
                bFirst = null;
                currentIO = fa;
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO2 instanceof IO.Map) {
                BoxedUnit boxedUnit5;
                IO.Map map = (IO.Map)iO2;
                IO.RaiseError fa = map.source();
                if (TracingPlatform.isStackTracing) {
                    Object trace;
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if ((trace = map.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push(bFirst);
                }
                bFirst = map;
                currentIO = fa;
                if (ctx == null) {
                    ctx = new IOContext();
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit5;
            } else if (iO2 instanceof IO.Trace) {
                IO.Trace trace = (IO.Trace)iO2;
                IO source3 = trace.source();
                IOEvent frame = trace.trace();
                if (ctx == null) {
                    ctx = new IOContext();
                }
                ctx.pushEvent(frame);
                currentIO = source3;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                return this.suspendAsync(currentIO, ctx, bFirst, bRest);
            }
            if (!hasUnboxed) continue;
            Function1<Object, IO<Object>> function1 = this.popNextBind(bFirst, bRest);
            if (function1 == null) {
                return currentIO != null ? currentIO : new IO.Pure<Object>(unboxed);
            }
            try {
                iO = (IO)function1.apply(unboxed);
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable4);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable ex = (Throwable)option.get();
                IO.RaiseError raiseError = new IO.RaiseError(ex);
                iO = raiseError;
            }
            IO fa = iO;
            hasUnboxed = false;
            unboxed = null;
            bFirst = null;
            currentIO = fa;
            BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
        } while (true);
        return null;
    }

    private <A> IO<A> suspendAsync(IO<A> currentIO, IOContext ctx, Function1<Object, IO<Object>> bFirst, ArrayStack<Function1<Object, IO<Object>>> bRest) {
        return new IO.Async((Function3 & Serializable & scala.Serializable)(conn, x$1, cb) -> {
            IORunLoop$.MODULE$.cats$effect$internals$IORunLoop$$loop(currentIO, conn, (Function1<Either<Throwable, Object>, BoxedUnit>)cb, ctx, null, (Function1<Object, IO<Object>>)bFirst, bRest);
            return BoxedUnit.UNIT;
        }, IO$Async$.MODULE$.apply$default$2(), IO$Async$.MODULE$.apply$default$3());
    }

    private Function1<Object, IO<Object>> popNextBind(Function1<Object, IO<Object>> bFirst, ArrayStack<Function1<Object, IO<Object>>> bRest) {
        if (bFirst != null && !(bFirst instanceof IOFrame.ErrorHandler)) {
            return bFirst;
        }
        if (bRest == null) {
            return null;
        }
        do {
            Function1<Object, IO<Object>> next;
            if ((next = bRest.pop()) == null) {
                return null;
            }
            if (next instanceof IOFrame.ErrorHandler) continue;
            return next;
        } while (true);
        return null;
    }

    private IOFrame<Object, IO<Object>> findErrorHandler(Function1<Object, IO<Object>> bFirst, ArrayStack<Function1<Object, IO<Object>>> bRest) {
        IOFrame iOFrame;
        Function1<Object, IO<Object>> function1 = bFirst;
        if (function1 instanceof IOFrame) {
            IOFrame iOFrame2;
            iOFrame = iOFrame2 = (IOFrame)function1;
        } else {
            Object v0;
            if (bRest == null) {
                v0 = null;
            } else {
                do {
                    Function1<Object, IO<Object>> ref;
                    if ((ref = bRest.pop()) == null) {
                        return null;
                    }
                    if (!(ref instanceof IOFrame)) continue;
                    return (IOFrame)ref;
                } while (true);
                v0 = null;
            }
            iOFrame = v0;
        }
        return iOFrame;
    }

    private void augmentException(Throwable ex, IOContext ctx) {
        block1: {
            boolean augmented;
            StackTraceElement[] stackTrace = ex.getStackTrace();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stackTrace)).isEmpty()) break block1;
            boolean bl = augmented = stackTrace[stackTrace.length - 1].getClassName().indexOf(64) != -1;
            if (!augmented) {
                StackTraceElement[] prefix = this.dropRunLoopFrames(stackTrace);
                StackTraceElement[] suffix = (StackTraceElement[])((TraversableOnce)((List)ctx.getStackTraces().flatMap((Function1 & Serializable & scala.Serializable)t -> Option$.MODULE$.option2Iterable(IOTrace$.MODULE$.getOpAndCallSite(t.stackTrace())), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StackTraceElement methodSite = (StackTraceElement)tuple2._1();
                    StackTraceElement callSite = (StackTraceElement)tuple2._2();
                    String op2 = NameTransformer$.MODULE$.decode(methodSite.getMethodName());
                    StackTraceElement stackTraceElement = new StackTraceElement(new StringBuilder(3).append(op2).append(" @ ").append(callSite.getClassName()).toString(), callSite.getMethodName(), callSite.getFileName(), callSite.getLineNumber());
                    return stackTraceElement;
                }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
                ex.setStackTrace((StackTraceElement[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])prefix)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])suffix)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StackTraceElement.class))));
            }
        }
    }

    private StackTraceElement[] dropRunLoopFrames(StackTraceElement[] frames) {
        return (StackTraceElement[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])frames)).takeWhile((Function1 & Serializable & scala.Serializable)ste -> BoxesRunTime.boxToBoolean((boolean)IORunLoop$.$anonfun$dropRunLoopFrames$1(ste)));
    }

    private static final /* synthetic */ IO liftedTree1$1(Function0 thunk$1) {
        IO iO;
        try {
            iO = (IO)thunk$1.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable ex = (Throwable)option.get();
            IO.RaiseError raiseError = new IO.RaiseError(ex);
            iO = raiseError;
        }
        return iO;
    }

    private static final /* synthetic */ IO liftedTree2$1(Function0 thunk$2) {
        IO iO;
        try {
            iO = (IO)thunk$2.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable ex = (Throwable)option.get();
            IO.RaiseError raiseError = new IO.RaiseError(ex);
            iO = raiseError;
        }
        return iO;
    }

    public static final /* synthetic */ boolean $anonfun$dropRunLoopFrames$2(StackTraceElement ste$1, String x$2) {
        return ste$1.getClassName().startsWith(x$2);
    }

    public static final /* synthetic */ boolean $anonfun$dropRunLoopFrames$1(StackTraceElement ste) {
        return !IORunLoop$.MODULE$.runLoopFilter.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)IORunLoop$.$anonfun$dropRunLoopFrames$2(ste, x$2)));
    }

    private IORunLoop$() {
        MODULE$ = this;
        this.runLoopFilter = new .colon.colon((Object)"cats.effect.", (List)new .colon.colon((Object)"scala.runtime.", (List)Nil$.MODULE$));
        this.maxAutoCancelableBatchSize = 512;
    }
}

