/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.internals;

import java.util.Optional;

public final class TracingPlatform {
    private static final String stackTracingMode = Optional.ofNullable(System.getProperty("cats.effect.stackTracingMode")).filter(string -> !string.isEmpty()).orElse("cached");
    public static final boolean isCachedStackTracing = stackTracingMode.equalsIgnoreCase("cached");
    public static final boolean isFullStackTracing = stackTracingMode.equalsIgnoreCase("full");
    public static final boolean isStackTracing = isFullStackTracing || isCachedStackTracing;
    public static final int traceBufferLogSize = Optional.ofNullable(System.getProperty("cats.effect.traceBufferLogSize")).filter(string -> !string.isEmpty()).flatMap(string -> {
        try {
            return Optional.of(Integer.valueOf(string));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }).orElse(4);
    public static final boolean enhancedExceptions = Optional.ofNullable(System.getProperty("cats.effect.enhancedExceptions")).map(string -> Boolean.valueOf(string)).orElse(true);
}

