/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UriUtil {
    static final Pattern PCT_ENCODDED_STRING;
    static final char[] GENERAL_DELIM_CHARS;
    static final char[] SUB_DELIMS_CHARS;
    private static final BitSet RESERVED;
    private static final BitSet ESCAPE_CHARS;

    private UriUtil() {
    }

    public static String encodeFragment(String sourceValue) throws UnsupportedEncodingException {
        Matcher m3 = PCT_ENCODDED_STRING.matcher(sourceValue);
        ArrayList<int[]> positions = new ArrayList<int[]>();
        while (m3.find()) {
            positions.add(new int[]{m3.start(), m3.end()});
        }
        if (!positions.isEmpty()) {
            StringBuilder b = new StringBuilder();
            int offset = 0;
            for (int[] pos : positions) {
                b.append(UriUtil.encode(sourceValue.substring(offset, pos[0]), ESCAPE_CHARS));
                b.append(sourceValue.substring(pos[0], pos[1]));
                offset = pos[1];
            }
            b.append(UriUtil.encode(sourceValue.substring(offset, sourceValue.length()), ESCAPE_CHARS));
            return b.toString();
        }
        return UriUtil.encode(sourceValue, ESCAPE_CHARS);
    }

    public static String encode(String sourceValue) throws UnsupportedEncodingException {
        return UriUtil.encode(sourceValue, RESERVED);
    }

    private static String encode(String sourceValue, BitSet chars) throws UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] source2 = sourceValue.getBytes(Charset.forName("UTF-8"));
        for (int i = 0; i < source2.length; ++i) {
            byte c = source2[i];
            if (chars.get(c & 0xFF) || c <= 32) {
                out.write(37);
                char hex1 = Character.toUpperCase(Character.forDigit(c >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(c & 0xF, 16));
                out.write(hex1);
                out.write(hex2);
                continue;
            }
            out.write(c);
        }
        return new String(out.toByteArray(), "UTF-8");
    }

    static {
        int i;
        PCT_ENCODDED_STRING = Pattern.compile("%[0-9A-Fa-f]{2}");
        GENERAL_DELIM_CHARS = new char[]{':', '/', ',', '?', '#', '[', ']', '@'};
        SUB_DELIMS_CHARS = new char[]{'!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '=', '<', '>', '{', '}'};
        RESERVED = new BitSet();
        for (i = 0; i < GENERAL_DELIM_CHARS.length; ++i) {
            RESERVED.set(GENERAL_DELIM_CHARS[i]);
        }
        RESERVED.set(32);
        RESERVED.set(37);
        RESERVED.set(124);
        RESERVED.set(92);
        RESERVED.set(96);
        RESERVED.set(34);
        RESERVED.set(94);
        for (i = 0; i < SUB_DELIMS_CHARS.length; ++i) {
            RESERVED.set(SUB_DELIMS_CHARS[i]);
        }
        ESCAPE_CHARS = new BitSet();
        ESCAPE_CHARS.set(60);
        ESCAPE_CHARS.set(62);
        ESCAPE_CHARS.set(37);
        ESCAPE_CHARS.set(34);
        ESCAPE_CHARS.set(123);
        ESCAPE_CHARS.set(125);
        ESCAPE_CHARS.set(124);
        ESCAPE_CHARS.set(92);
        ESCAPE_CHARS.set(94);
        ESCAPE_CHARS.set(91);
        ESCAPE_CHARS.set(93);
        ESCAPE_CHARS.set(96);
    }
}

