/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;

public class InstantDeserializer<T extends Temporal>
extends JSR310DateTimeDeserializerBase<T> {
    private static final long serialVersionUID = 1L;
    private static final Pattern ISO8601_UTC_ZERO_OFFSET_SUFFIX_REGEX = Pattern.compile("\\+00:?(00)?$");
    public static final InstantDeserializer<Instant> INSTANT = new InstantDeserializer<Instant>(Instant.class, DateTimeFormatter.ISO_INSTANT, Instant::from, a -> Instant.ofEpochMilli(a.value), a -> Instant.ofEpochSecond(a.integer, a.fraction), null, true);
    public static final InstantDeserializer<OffsetDateTime> OFFSET_DATE_TIME = new InstantDeserializer<OffsetDateTime>(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, OffsetDateTime::from, a -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), (d, z) -> d.withOffsetSameInstant(z.getRules().getOffset(d.toLocalDateTime())), true);
    public static final InstantDeserializer<ZonedDateTime> ZONED_DATE_TIME = new InstantDeserializer<ZonedDateTime>(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME, ZonedDateTime::from, a -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> ZonedDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), ZonedDateTime::withZoneSameInstant, false);
    protected final Function<FromIntegerArguments, T> fromMilliseconds;
    protected final Function<FromDecimalArguments, T> fromNanoseconds;
    protected final Function<TemporalAccessor, T> parsedToValue;
    protected final BiFunction<T, ZoneId, T> adjust;
    protected final boolean replaceZeroOffsetAsZ;
    protected final Boolean _adjustToContextTZOverride;

    protected InstantDeserializer(Class<T> supportedType, DateTimeFormatter formatter, Function<TemporalAccessor, T> parsedToValue, Function<FromIntegerArguments, T> fromMilliseconds, Function<FromDecimalArguments, T> fromNanoseconds, BiFunction<T, ZoneId, T> adjust, boolean replaceZeroOffsetAsZ) {
        super(supportedType, formatter);
        this.parsedToValue = parsedToValue;
        this.fromMilliseconds = fromMilliseconds;
        this.fromNanoseconds = fromNanoseconds;
        this.adjust = adjust == null ? (d, z) -> d : adjust;
        this.replaceZeroOffsetAsZ = replaceZeroOffsetAsZ;
        this._adjustToContextTZOverride = null;
    }

    protected InstantDeserializer(InstantDeserializer<T> base, DateTimeFormatter f) {
        super(base.handledType(), f);
        this.parsedToValue = base.parsedToValue;
        this.fromMilliseconds = base.fromMilliseconds;
        this.fromNanoseconds = base.fromNanoseconds;
        this.adjust = base.adjust;
        this.replaceZeroOffsetAsZ = this._formatter == DateTimeFormatter.ISO_INSTANT;
        this._adjustToContextTZOverride = base._adjustToContextTZOverride;
    }

    protected InstantDeserializer(InstantDeserializer<T> base, Boolean adjustToContextTimezoneOverride) {
        super(base.handledType(), base._formatter);
        this.parsedToValue = base.parsedToValue;
        this.fromMilliseconds = base.fromMilliseconds;
        this.fromNanoseconds = base.fromNanoseconds;
        this.adjust = base.adjust;
        this.replaceZeroOffsetAsZ = base.replaceZeroOffsetAsZ;
        this._adjustToContextTZOverride = adjustToContextTimezoneOverride;
    }

    protected InstantDeserializer(InstantDeserializer<T> base, DateTimeFormatter f, Boolean leniency) {
        super(base.handledType(), f, leniency);
        this.parsedToValue = base.parsedToValue;
        this.fromMilliseconds = base.fromMilliseconds;
        this.fromNanoseconds = base.fromNanoseconds;
        this.adjust = base.adjust;
        this.replaceZeroOffsetAsZ = this._formatter == DateTimeFormatter.ISO_INSTANT;
        this._adjustToContextTZOverride = base._adjustToContextTZOverride;
    }

    @Override
    protected InstantDeserializer<T> withDateFormat(DateTimeFormatter dtf) {
        if (dtf == this._formatter) {
            return this;
        }
        return new InstantDeserializer<T>(this, dtf);
    }

    @Override
    protected InstantDeserializer<T> withLeniency(Boolean leniency) {
        return new InstantDeserializer<T>(this, this._formatter, leniency);
    }

    @Override
    protected InstantDeserializer<T> withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    public T deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentTokenId()) {
            case 8: {
                return this._fromDecimal(context, parser.getDecimalValue());
            }
            case 7: {
                return this._fromLong(context, parser.getLongValue());
            }
            case 6: {
                Temporal value;
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    if (!this.isLenient()) {
                        return (T)((Temporal)this._failForNotLenient(parser, context, JsonToken.VALUE_STRING));
                    }
                    return null;
                }
                if (this._formatter == DateTimeFormatter.ISO_INSTANT || this._formatter == DateTimeFormatter.ISO_OFFSET_DATE_TIME || this._formatter == DateTimeFormatter.ISO_ZONED_DATE_TIME) {
                    int dots = this._countPeriods(string);
                    if (dots >= 0) {
                        try {
                            if (dots == 0) {
                                return this._fromLong(context, Long.parseLong(string));
                            }
                            if (dots == 1) {
                                return this._fromDecimal(context, new BigDecimal(string));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    string = this.replaceZeroOffsetAsZIfNecessary(string);
                }
                try {
                    TemporalAccessor acc = this._formatter.parse(string);
                    value = (Temporal)this.parsedToValue.apply(acc);
                    if (this.shouldAdjustToContextTimezone(context)) {
                        return (T)((Temporal)this.adjust.apply(value, this.getZone(context)));
                    }
                }
                catch (DateTimeException e) {
                    value = (Temporal)this._handleDateTimeException(context, e, string);
                }
                return (T)value;
            }
            case 12: {
                return (T)((Temporal)parser.getEmbeddedObject());
            }
            case 3: {
                return (T)((Temporal)this._deserializeFromArray(parser, context));
            }
        }
        return (T)((Temporal)this._handleUnexpectedToken(context, parser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT));
    }

    @Override
    public JsonDeserializer<T> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value val;
        JSR310DateTimeDeserializerBase deserializer = (InstantDeserializer<T>)super.createContextual(ctxt, property);
        if (deserializer != this && (val = this.findFormatOverrides(ctxt, property, this.handledType())) != null) {
            Boolean leniency;
            deserializer = new InstantDeserializer<T>(deserializer, val.getFeature(JsonFormat.Feature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE));
            if (val.hasLenient() && (leniency = val.getLenient()) != null) {
                deserializer = deserializer.withLeniency(leniency);
            }
        }
        return deserializer;
    }

    protected boolean shouldAdjustToContextTimezone(DeserializationContext context) {
        return this._adjustToContextTZOverride != null ? this._adjustToContextTZOverride.booleanValue() : context.isEnabled(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
    }

    protected int _countPeriods(String str) {
        int commas = 0;
        int end = str.length();
        for (int i = 0; i < end; ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            if (ch == '.') {
                ++commas;
                continue;
            }
            return -1;
        }
        return commas;
    }

    protected T _fromLong(DeserializationContext context, long timestamp) {
        if (context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
            return (T)((Temporal)this.fromNanoseconds.apply(new FromDecimalArguments(timestamp, 0, this.getZone(context))));
        }
        return (T)((Temporal)this.fromMilliseconds.apply(new FromIntegerArguments(timestamp, this.getZone(context))));
    }

    protected T _fromDecimal(DeserializationContext context, BigDecimal value) {
        FromDecimalArguments args = DecimalUtils.extractSecondsAndNanos(value, (s2, ns) -> new FromDecimalArguments((long)s2, (int)ns, this.getZone(context)));
        return (T)((Temporal)this.fromNanoseconds.apply(args));
    }

    private ZoneId getZone(DeserializationContext context) {
        return this._valueClass == Instant.class ? null : context.getTimeZone().toZoneId();
    }

    private String replaceZeroOffsetAsZIfNecessary(String text) {
        if (this.replaceZeroOffsetAsZ) {
            return ISO8601_UTC_ZERO_OFFSET_SUFFIX_REGEX.matcher(text).replaceFirst("Z");
        }
        return text;
    }

    public static class FromDecimalArguments {
        public final long integer;
        public final int fraction;
        public final ZoneId zoneId;

        private FromDecimalArguments(long integer, int fraction, ZoneId zoneId) {
            this.integer = integer;
            this.fraction = fraction;
            this.zoneId = zoneId;
        }
    }

    public static class FromIntegerArguments {
        public final long value;
        public final ZoneId zoneId;

        private FromIntegerArguments(long value, ZoneId zoneId) {
            this.value = value;
            this.zoneId = zoneId;
        }
    }
}

