/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.fge.Builder;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.bundle.PropertiesBundle;
import com.google.common.io.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class JsonNodeReader {
    private static final MessageBundle BUNDLE = PropertiesBundle.forPath("/com/github/fge/jackson/jsonNodeReader");
    private final ObjectReader reader;

    public JsonNodeReader(ObjectMapper mapper) {
        this.reader = mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true).reader(JsonNode.class);
    }

    public JsonNodeReader() {
        this(JacksonUtils.newMapper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode fromInputStream(InputStream in) throws IOException {
        Closer closer = Closer.create();
        try {
            JsonParser parser = closer.register(this.reader.getFactory().createParser(in));
            MappingIterator iterator = this.reader.readValues(parser);
            JsonNode jsonNode = JsonNodeReader.readNode(closer.register(iterator));
            return jsonNode;
        }
        finally {
            closer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode fromReader(Reader r) throws IOException {
        Closer closer = Closer.create();
        try {
            JsonParser parser = closer.register(this.reader.getFactory().createParser(r));
            MappingIterator iterator = this.reader.readValues(parser);
            JsonNode jsonNode = JsonNodeReader.readNode(closer.register(iterator));
            return jsonNode;
        }
        finally {
            closer.close();
        }
    }

    private static JsonNode readNode(MappingIterator<JsonNode> iterator) throws IOException {
        Object source2 = iterator.getParser().getInputSource();
        JsonParseExceptionBuilder builder = new JsonParseExceptionBuilder(source2);
        builder.setMessage(JsonNodeReader.BUNDLE.getMessage("read.noContent"));
        if (!iterator.hasNextValue()) {
            throw builder.build();
        }
        JsonNode ret = iterator.nextValue();
        builder.setMessage(JsonNodeReader.BUNDLE.getMessage("read.trailingData")).setLocation(iterator.getCurrentLocation());
        try {
            if (iterator.hasNextValue()) {
                throw builder.build();
            }
        }
        catch (JsonParseException e) {
            throw builder.setLocation(e.getLocation()).build();
        }
        return ret;
    }

    private static final class JsonParseExceptionBuilder
    implements Builder<JsonParseException> {
        private String message = "";
        private JsonLocation location;

        private JsonParseExceptionBuilder(@Nonnull Object source2) {
            BUNDLE.checkNotNull(source2, "read.nullArgument");
            this.location = new JsonLocation(source2, 0L, 1, 1);
        }

        private JsonParseExceptionBuilder setMessage(@Nonnull String message) {
            this.message = BUNDLE.checkNotNull(message, "read.nullArgument");
            return this;
        }

        private JsonParseExceptionBuilder setLocation(@Nonnull JsonLocation location) {
            this.location = BUNDLE.checkNotNull(location, "read.nullArgument");
            return this;
        }

        @Override
        public JsonParseException build() {
            return new JsonParseException(this.message, this.location);
        }
    }
}

