/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson.jsonpointer;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.ReferenceToken;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JsonNodeResolver
extends TokenResolver<JsonNode> {
    private static final char ZERO = '0';

    public JsonNodeResolver(ReferenceToken token) {
        super(token);
    }

    @Override
    public JsonNode get(JsonNode node2) {
        if (node2 == null || !node2.isContainerNode()) {
            return null;
        }
        String raw = this.token.getRaw();
        return node2.isObject() ? node2.get(raw) : node2.get(JsonNodeResolver.arrayIndexFor(raw));
    }

    private static int arrayIndexFor(String raw) {
        if (raw.isEmpty()) {
            return -1;
        }
        if (raw.charAt(0) == '0') {
            return raw.length() == 1 ? 0 : -1;
        }
        try {
            return Integer.parseInt(raw);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }
}

