/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.diff.Diff;
import com.github.fge.jsonpatch.diff.DiffFactorizer;
import com.github.fge.jsonpatch.diff.DiffOperation;
import com.github.fge.jsonpatch.diff.IndexedJsonArray;
import com.github.fge.jsonpatch.diff.LCS;
import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public final class JsonDiff {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();

    private JsonDiff() {
    }

    public static JsonNode asJson(JsonNode source2, JsonNode target) {
        ArrayList<Diff> diffs = Lists.newArrayList();
        JsonDiff.generateDiffs(diffs, JsonPointer.empty(), source2, target);
        DiffFactorizer.factorizeDiffs(diffs);
        ArrayNode patch = FACTORY.arrayNode();
        for (Diff diff : diffs) {
            patch.add(diff.asJsonPatch());
        }
        return patch;
    }

    private static void generateDiffs(List<Diff> diffs, JsonPointer path, JsonNode source2, JsonNode target) {
        NodeType targetType;
        if (EQUIVALENCE.equivalent(source2, target)) {
            return;
        }
        NodeType sourceType = NodeType.getNodeType(source2);
        if (sourceType != (targetType = NodeType.getNodeType(target)) || !source2.isContainerNode()) {
            diffs.add(Diff.simpleDiff(DiffOperation.REPLACE, path, target));
            return;
        }
        if (sourceType == NodeType.OBJECT) {
            JsonDiff.generateObjectDiffs(diffs, path, source2, target);
        } else {
            JsonDiff.generateArrayDiffs(diffs, path, source2, target);
        }
    }

    private static void generateObjectDiffs(List<Diff> diffs, JsonPointer path, JsonNode source2, JsonNode target) {
        ArrayList<String> inFirst = Lists.newArrayList(source2.fieldNames());
        ArrayList<String> inSecond = Lists.newArrayList(target.fieldNames());
        ArrayList<String> fields = Lists.newArrayList(inSecond);
        fields.removeAll(inFirst);
        for (String s2 : fields) {
            diffs.add(Diff.simpleDiff(DiffOperation.ADD, path.append(s2), target.get(s2)));
        }
        fields = Lists.newArrayList(inFirst);
        fields.removeAll(inSecond);
        for (String s2 : fields) {
            diffs.add(Diff.simpleDiff(DiffOperation.REMOVE, path.append(s2), source2.get(s2)));
        }
        fields = Lists.newArrayList(inFirst);
        fields.retainAll(inSecond);
        for (String s2 : fields) {
            JsonDiff.generateDiffs(diffs, path.append(s2), source2.get(s2), target.get(s2));
        }
    }

    private static void generateArrayDiffs(List<Diff> diffs, JsonPointer path, JsonNode source2, JsonNode target) {
        IndexedJsonArray src = new IndexedJsonArray(source2);
        IndexedJsonArray dst = new IndexedJsonArray(target);
        IndexedJsonArray lcs = LCS.doLCS(source2, target);
        JsonDiff.preLCS(diffs, path, lcs, src, dst);
        JsonDiff.inLCS(diffs, path, lcs, src, dst);
        JsonDiff.postLCS(diffs, path, src, dst);
    }

    private static void preLCS(List<Diff> diffs, JsonPointer path, IndexedJsonArray lcs, IndexedJsonArray source2, IndexedJsonArray target) {
        if (lcs.isEmpty()) {
            return;
        }
        JsonNode sentinel = lcs.getElement();
        while (true) {
            int nrEquivalences = 0;
            JsonNode srcNode = source2.getElement();
            JsonNode dstNode = target.getElement();
            if (EQUIVALENCE.equivalent(sentinel, srcNode)) {
                ++nrEquivalences;
            }
            if (EQUIVALENCE.equivalent(sentinel, dstNode)) {
                ++nrEquivalences;
            }
            if (nrEquivalences == 2) {
                return;
            }
            if (nrEquivalences == 0) {
                JsonDiff.generateDiffs(diffs, path.append(source2.getIndex()), srcNode, dstNode);
                source2.shift();
                target.shift();
                continue;
            }
            if (!EQUIVALENCE.equivalent(sentinel, srcNode)) {
                diffs.add(Diff.arrayRemove(path, source2, target));
                source2.shift();
                continue;
            }
            diffs.add(Diff.arrayInsert(path, source2, target));
            target.shift();
        }
    }

    private static void inLCS(List<Diff> diffs, JsonPointer path, IndexedJsonArray lcs, IndexedJsonArray source2, IndexedJsonArray target) {
        while (!lcs.isEmpty()) {
            JsonNode sourceNode = source2.getElement();
            JsonNode targetNode = target.getElement();
            JsonNode lcsNode = lcs.getElement();
            boolean sourceMatch = EQUIVALENCE.equivalent(sourceNode, lcsNode);
            boolean targetMatch = EQUIVALENCE.equivalent(targetNode, lcsNode);
            if (!sourceMatch) {
                diffs.add(Diff.arrayRemove(path, source2, target));
                source2.shift();
                continue;
            }
            if (targetMatch) {
                source2.shift();
                lcs.shift();
            } else {
                diffs.add(Diff.arrayInsert(path, source2, target));
            }
            target.shift();
        }
    }

    private static void postLCS(List<Diff> diffs, JsonPointer path, IndexedJsonArray source2, IndexedJsonArray target) {
        while (!source2.isEmpty() && !target.isEmpty()) {
            JsonNode src = source2.getElement();
            JsonNode dst = target.getElement();
            JsonDiff.generateDiffs(diffs, path.append(source2.getIndex()), src, dst);
            source2.shift();
            target.shift();
        }
        JsonDiff.addRemaining(diffs, path, target);
        JsonDiff.removeRemaining(diffs, path, source2);
    }

    private static void addRemaining(List<Diff> diffs, JsonPointer path, IndexedJsonArray array) {
        while (!array.isEmpty()) {
            Object node2 = array.getElement().deepCopy();
            Diff diff = Diff.arrayAdd(path, node2);
            diffs.add(diff);
            array.shift();
        }
    }

    private static void removeRemaining(List<Diff> diffs, JsonPointer path, IndexedJsonArray array) {
        int startingIndex = array.getIndex();
        while (!array.isEmpty()) {
            JsonNode node2 = array.getElement();
            Diff diff = Diff.tailArrayRemove(path, startingIndex, node2);
            diffs.add(diff);
            array.shift();
        }
    }
}

