/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword.syntax.checkers.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;

public final class RequiredSyntaxChecker
extends AbstractSyntaxChecker {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    private static final SyntaxChecker INSTANCE = new RequiredSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private RequiredSyntaxChecker() {
        super("required", NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle2, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node2 = this.getNode(tree);
        int size = node2.size();
        if (size == 0) {
            report.error(this.newMsg(tree, bundle2, "common.array.empty"));
            return;
        }
        HashSet<Equivalence.Wrapper<JsonNode>> set = Sets.newHashSet();
        boolean uniqueElements = true;
        for (int index = 0; index < size; ++index) {
            JsonNode element = node2.get(index);
            uniqueElements = set.add(EQUIVALENCE.wrap(element));
            NodeType type = NodeType.getNodeType(element);
            if (type == NodeType.STRING) continue;
            report.error(this.newMsg(tree, bundle2, "common.array.element.incorrectType").putArgument("index", index).putArgument("expected", EnumSet.of(NodeType.STRING)).putArgument("found", type));
        }
        if (!uniqueElements) {
            report.error(this.newMsg(tree, bundle2, "common.array.duplicateElements"));
        }
    }
}

