/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword.syntax.checkers.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.Collection;

public final class PositiveIntegerSyntaxChecker
extends AbstractSyntaxChecker {
    public PositiveIntegerSyntaxChecker(String keyword) {
        super(keyword, NodeType.INTEGER, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle2, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node2 = this.getNode(tree);
        if (!node2.canConvertToInt()) {
            report.error(this.newMsg(tree, bundle2, "common.integerTooLarge").put("max", Integer.MAX_VALUE));
            return;
        }
        if (node2.intValue() < 0) {
            report.error(this.newMsg(tree, bundle2, "common.integerIsNegative"));
        }
    }
}

