/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword.syntax.checkers.hyperschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.uritemplate.URITemplate;
import com.github.fge.uritemplate.URITemplateParseException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class LinksSyntaxChecker
extends AbstractSyntaxChecker {
    private static final List<String> REQUIRED_LDO_PROPERTIES = ImmutableList.of("href", "rel");
    private static final SyntaxChecker INSTANCE = new LinksSyntaxChecker();

    private LinksSyntaxChecker() {
        super("links", NodeType.ARRAY, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle2, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node2 = this.getNode(tree);
        int size = node2.size();
        for (int index = 0; index < size; ++index) {
            JsonNode ldo = this.getNode(tree).get(index);
            NodeType type = NodeType.getNodeType(ldo);
            if (type != NodeType.OBJECT) {
                report.error(this.LDOMsg(tree, bundle2, "draftv4.ldo.incorrectType", index).put("expected", NodeType.OBJECT).putArgument("found", type));
                continue;
            }
            HashSet<String> set = Sets.newHashSet(ldo.fieldNames());
            ArrayList<String> list = Lists.newArrayList(REQUIRED_LDO_PROPERTIES);
            list.removeAll(set);
            if (!list.isEmpty()) {
                ProcessingMessage msg = this.LDOMsg(tree, bundle2, "draftv4.ldo.missingRequired", index);
                report.error(msg.put("required", REQUIRED_LDO_PROPERTIES).putArgument("missing", list));
                continue;
            }
            if (ldo.has("schema")) {
                pointers.add(JsonPointer.of(this.keyword, index, "schema"));
            }
            if (ldo.has("targetSchema")) {
                pointers.add(JsonPointer.of(this.keyword, index, "targetSchema"));
            }
            this.checkLDO(report, bundle2, tree, index);
        }
    }

    private void checkLDO(ProcessingReport report, MessageBundle bundle2, SchemaTree tree, int index) throws ProcessingException {
        String value;
        JsonNode ldo = this.getNode(tree).get(index);
        this.checkLDOProperty(report, bundle2, tree, index, "rel", NodeType.STRING, "draftv4.ldo.rel.incorrectType");
        if (this.checkLDOProperty(report, bundle2, tree, index, "href", NodeType.STRING, "draftv4.ldo.href.incorrectType")) {
            value = ldo.get("href").textValue();
            try {
                new URITemplate(value);
            }
            catch (URITemplateParseException ignored) {
                report.error(this.LDOMsg(tree, bundle2, "draftv4.ldo.href.notURITemplate", index).putArgument("value", value));
            }
        }
        this.checkLDOProperty(report, bundle2, tree, index, "title", NodeType.STRING, "draftv4.ldo.title.incorrectType");
        if (this.checkLDOProperty(report, bundle2, tree, index, "mediaType", NodeType.STRING, "draftv4.ldo.mediaType.incorrectType")) {
            value = ldo.get("mediaType").textValue();
            try {
                MediaType.parse(value);
            }
            catch (IllegalArgumentException ignored) {
                report.error(this.LDOMsg(tree, bundle2, "draftv4.ldo.mediaType.notMediaType", index).putArgument("value", value));
            }
        }
        this.checkLDOProperty(report, bundle2, tree, index, "method", NodeType.STRING, "draftv4.ldo.method.incorrectType");
        if (this.checkLDOProperty(report, bundle2, tree, index, "encType", NodeType.STRING, "draftv4.ldo.enctype.incorrectType")) {
            value = ldo.get("encType").textValue();
            try {
                MediaType.parse(value);
            }
            catch (IllegalArgumentException ignored) {
                report.error(this.LDOMsg(tree, bundle2, "draftv4.ldo.enctype.notMediaType", index).putArgument("value", value));
            }
        }
    }

    private ProcessingMessage LDOMsg(SchemaTree tree, MessageBundle bundle2, String key, int index) {
        return this.newMsg(tree, bundle2, key).put("index", index);
    }

    private boolean checkLDOProperty(ProcessingReport report, MessageBundle bundle2, SchemaTree tree, int index, String name, NodeType expected, String key) throws ProcessingException {
        JsonNode node2 = this.getNode(tree).get(index).get(name);
        if (node2 == null) {
            return false;
        }
        NodeType type = NodeType.getNodeType(node2);
        if (type == expected) {
            return true;
        }
        report.error(this.LDOMsg(tree, bundle2, key, index).put("expected", expected).putArgument("found", type));
        return false;
    }
}

