/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.load.uri;

import com.github.fge.jsonschema.core.load.uri.URITranslatorConfiguration;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.util.URIUtils;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public final class URITranslator {
    private final URI namespace;
    private final Map<URI, URI> pathRedirects;
    private final Map<URI, URI> schemaRedirects;

    public URITranslator(URITranslatorConfiguration cfg) {
        this.namespace = cfg.namespace;
        this.pathRedirects = ImmutableMap.copyOf(cfg.pathRedirects);
        this.schemaRedirects = ImmutableMap.copyOf(cfg.schemaRedirects);
    }

    public URI translate(URI source2) {
        URI uri = URIUtils.normalizeURI(this.namespace.resolve(source2));
        String fragment = uri.getFragment();
        try {
            uri = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("How did I get there??", e);
        }
        for (Map.Entry<URI, URI> entry : this.pathRedirects.entrySet()) {
            URI relative = entry.getKey().relativize(uri);
            if (relative.equals(uri)) continue;
            uri = entry.getValue().resolve(relative);
        }
        if (this.schemaRedirects.containsKey(uri = JsonRef.fromURI(uri).getLocator())) {
            uri = this.schemaRedirects.get(uri);
        }
        try {
            return new URI(uri.getScheme(), uri.getSchemeSpecificPart(), fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("How did I get there??", e);
        }
    }
}

