/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.digest.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import com.github.fge.jsonschema.keyword.digest.Digester;
import java.util.EnumSet;

public final class DraftV4TypeDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new DraftV4TypeDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private DraftV4TypeDigester() {
        super("type", NodeType.ARRAY, NodeType.values());
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ArrayNode allowedTypes = FACTORY.arrayNode();
        ret.put(this.keyword, allowedTypes);
        JsonNode node2 = schema.get(this.keyword);
        EnumSet<NodeType> typeSet = EnumSet.noneOf(NodeType.class);
        if (node2.isTextual()) {
            typeSet.add(NodeType.fromName(node2.textValue()));
        } else {
            for (JsonNode element : node2) {
                typeSet.add(NodeType.fromName(element.textValue()));
            }
        }
        if (typeSet.contains((Object)NodeType.NUMBER)) {
            typeSet.add(NodeType.INTEGER);
        }
        for (NodeType type : typeSet) {
            allowedTypes.add(type.toString());
        }
        return ret;
    }
}

