/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.digest.helpers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import java.math.BigDecimal;

public abstract class NumericDigester
extends AbstractDigester {
    protected NumericDigester(String keyword) {
        super(keyword, NodeType.INTEGER, NodeType.NUMBER);
    }

    private static boolean valueIsLong(JsonNode node2) {
        if (!node2.canConvertToLong()) {
            return false;
        }
        if (NodeType.getNodeType(node2) == NodeType.INTEGER) {
            return true;
        }
        return node2.decimalValue().remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0;
    }

    protected final ObjectNode digestedNumberNode(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        JsonNode node2 = schema.get(this.keyword);
        boolean isLong = NumericDigester.valueIsLong(node2);
        ret.put("valueIsLong", isLong);
        if (isLong) {
            ret.put(this.keyword, node2.canConvertToInt() ? FACTORY.numberNode(node2.intValue()) : FACTORY.numberNode(node2.longValue()));
            return ret;
        }
        BigDecimal decimal = node2.decimalValue();
        ret.put(this.keyword, decimal.scale() == 0 ? FACTORY.numberNode(decimal.toBigIntegerExact()) : node2);
        return ret;
    }
}

