/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.HashSet;

public final class ObjectSchemaDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new ObjectSchemaDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private ObjectSchemaDigester() {
        super("", NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ret.put("hasAdditional", schema.path("additionalProperties").isObject());
        ArrayNode node2 = FACTORY.arrayNode();
        ret.put("properties", node2);
        HashSet<String> set = Sets.newHashSet(schema.path("properties").fieldNames());
        for (String field : Ordering.natural().sortedCopy(set)) {
            node2.add(field);
        }
        node2 = FACTORY.arrayNode();
        ret.put("patternProperties", node2);
        set = Sets.newHashSet(schema.path("patternProperties").fieldNames());
        for (String field : Ordering.natural().sortedCopy(set)) {
            node2.add(field);
        }
        return ret;
    }
}

