/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate;

import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.URITemplateParseException;
import com.github.fge.uritemplate.expression.URITemplateExpression;
import com.github.fge.uritemplate.parse.URITemplateParser;
import com.github.fge.uritemplate.vars.VariableMap;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

public final class URITemplate {
    private final List<URITemplateExpression> expressions;

    public URITemplate(String input) throws URITemplateParseException {
        this.expressions = URITemplateParser.parse(input);
    }

    public String toString(VariableMap vars) throws URITemplateException {
        StringBuilder sb = new StringBuilder();
        for (URITemplateExpression expression2 : this.expressions) {
            sb.append(expression2.expand(vars));
        }
        return sb.toString();
    }

    public URI toURI(VariableMap vars) throws URITemplateException, URISyntaxException {
        return new URI(this.toString(vars));
    }

    public URL toURL(VariableMap vars) throws URITemplateException, MalformedURLException {
        return new URL(this.toString(vars));
    }
}

