/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.HttpMethod;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.RefPath;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.refs.RefFormat;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.SwaggerResolver;
import io.swagger.parser.processors.OperationProcessor;
import io.swagger.parser.processors.ParameterProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PathsProcessor {
    private final Swagger swagger;
    private final ResolverCache cache;
    private final SwaggerResolver.Settings settings;
    private final ParameterProcessor parameterProcessor;
    private final OperationProcessor operationProcessor;

    public PathsProcessor(ResolverCache cache, Swagger swagger) {
        this(cache, swagger, new SwaggerResolver.Settings());
    }

    public PathsProcessor(ResolverCache cache, Swagger swagger, SwaggerResolver.Settings settings) {
        this.swagger = swagger;
        this.cache = cache;
        this.settings = settings;
        this.parameterProcessor = new ParameterProcessor(cache, swagger);
        this.operationProcessor = new OperationProcessor(cache, swagger);
    }

    public void processPaths() {
        Map<String, Path> pathMap = this.swagger.getPaths();
        if (pathMap == null) {
            return;
        }
        for (String pathStr : pathMap.keySet()) {
            Path path = pathMap.get(pathStr);
            if (this.settings.addParametersToEachOperation()) {
                List<Operation> operations;
                List<Parameter> parameters = path.getParameters();
                if (parameters != null && (operations = path.getOperations()) != null) {
                    for (Operation operation : operations) {
                        ArrayList<Parameter> parametersToAdd = new ArrayList<Parameter>();
                        List<Parameter> existingParameters = operation.getParameters();
                        for (Parameter parameterToAdd : parameters) {
                            boolean matched = false;
                            for (Parameter existingParameter : existingParameters) {
                                if (parameterToAdd.getIn() == null || !parameterToAdd.getIn().equals(existingParameter.getIn()) || !parameterToAdd.getName().equals(existingParameter.getName())) continue;
                                matched = true;
                            }
                            if (matched) continue;
                            parametersToAdd.add(parameterToAdd);
                        }
                        if (parametersToAdd.size() <= 0) continue;
                        operation.getParameters().addAll(0, parametersToAdd);
                    }
                }
                path.setParameters(null);
            }
            if (path instanceof RefPath) {
                RefPath refPath = (RefPath)path;
                Path resolvedPath = this.cache.loadRef(refPath.get$ref(), refPath.getRefFormat(), Path.class);
                String pathRef = refPath.get$ref().split("#")[0];
                if (resolvedPath != null) {
                    this.updateLocalRefs(resolvedPath, pathRef);
                    this.swagger.path(pathStr, resolvedPath);
                    path = resolvedPath;
                }
            }
            List<Parameter> processedPathParameters = this.parameterProcessor.processParameters(path.getParameters());
            path.setParameters(processedPathParameters);
            Map<HttpMethod, Operation> operationMap = path.getOperationMap();
            for (HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = operationMap.get((Object)httpMethod);
                this.operationProcessor.processOperation(operation);
            }
        }
    }

    protected void updateLocalRefs(Path path, String pathRef) {
        if (path.getParameters() != null) {
            List<Parameter> params = path.getParameters();
            for (Parameter param : params) {
                this.updateLocalRefs(param, pathRef);
            }
        }
        List<Operation> ops = path.getOperations();
        for (Operation op2 : ops) {
            if (op2.getParameters() != null) {
                for (Parameter param : op2.getParameters()) {
                    this.updateLocalRefs(param, pathRef);
                }
            }
            if (op2.getResponses() == null) continue;
            for (Response response : op2.getResponses().values()) {
                this.updateLocalRefs(response, pathRef);
            }
        }
    }

    protected void updateLocalRefs(Response response, String pathRef) {
        if (response.getResponseSchema() != null) {
            this.updateLocalRefs(response.getResponseSchema(), pathRef);
        }
    }

    protected void updateLocalRefs(Parameter param, String pathRef) {
        BodyParameter bp;
        if (param instanceof BodyParameter && (bp = (BodyParameter)param).getSchema() != null) {
            this.updateLocalRefs(bp.getSchema(), pathRef);
        }
    }

    protected void updateLocalRefs(Model model, String pathRef) {
        ArrayModel am;
        if (model instanceof RefModel) {
            RefModel ref = (RefModel)model;
            if (ref.getRefFormat() == RefFormat.INTERNAL) {
                ref.set$ref(this.computeLocalRef(ref.get$ref(), pathRef));
            } else if (ref.getRefFormat() == RefFormat.RELATIVE) {
                ref.set$ref(this.computeRelativeRef(ref.get$ref(), pathRef));
            }
        } else if (model instanceof ModelImpl) {
            ModelImpl impl = (ModelImpl)model;
            if (impl.getProperties() != null) {
                for (Property property : impl.getProperties().values()) {
                    this.updateLocalRefs(property, pathRef);
                }
            }
        } else if (model instanceof ComposedModel) {
            ComposedModel cm = (ComposedModel)model;
            for (Model innerModel : cm.getAllOf()) {
                this.updateLocalRefs(innerModel, pathRef);
            }
        } else if (model instanceof ArrayModel && (am = (ArrayModel)model).getItems() != null) {
            this.updateLocalRefs(am.getItems(), pathRef);
        }
    }

    protected void updateLocalRefs(Property property, String pathRef) {
        if (property instanceof RefProperty) {
            RefProperty ref = (RefProperty)property;
            if (ref.getRefFormat() == RefFormat.INTERNAL) {
                ref.set$ref(this.computeLocalRef(ref.get$ref(), pathRef));
            } else if (ref.getRefFormat() == RefFormat.RELATIVE) {
                ref.set$ref(this.computeRelativeRef(ref.get$ref(), pathRef));
            }
        }
    }

    protected String computeLocalRef(String ref, String prefix) {
        return prefix + ref;
    }

    protected String computeRelativeRef(String ref, String prefix) {
        int index = prefix.lastIndexOf(47);
        if (index > 1) {
            return prefix.substring(0, index + 1) + ref;
        }
        return ref;
    }
}

