/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.transform.migrate.resourcelisting;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import io.swagger.transform.migrate.SwaggerMigrator;
import io.swagger.transform.util.SwaggerMigrationException;
import javax.annotation.Nonnull;
import javax.annotation.Untainted;

public final class PathAppenderMigrator
implements SwaggerMigrator {
    private final String basePath;

    public PathAppenderMigrator(@Untainted @Nonnull String basePath) {
        this.basePath = basePath;
    }

    @Override
    @Nonnull
    public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
        try {
            Preconditions.checkArgument(input.isObject(), "expected JSON to be a JSON object but it isn't");
            Preconditions.checkArgument(input.path("path").isTextual(), "\"path\" member of API object is not a JSON string");
        }
        catch (IllegalArgumentException e) {
            throw new SwaggerMigrationException(e.getMessage());
        }
        ObjectNode node2 = (ObjectNode)input.deepCopy();
        String oldPath = node2.get("path").textValue();
        node2.put("path", this.basePath + oldPath);
        return node2;
    }
}

