/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.transform.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.google.common.collect.ImmutableSet;
import io.swagger.transform.migrate.SwaggerMigrator;
import io.swagger.transform.util.SwaggerMigrationException;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SwaggerMigrators {
    private static final ObjectMapper MAPPER = JacksonUtils.newMapper();

    public static SwaggerMigrator membersToString(String first2, String ... others) {
        return new MembersToString(first2, others);
    }

    public static SwaggerMigrator fromPatch(final JsonPatch patch) {
        Objects.requireNonNull(patch, "patch cannot be null");
        return new SwaggerMigrator(){

            @Override
            @Nonnull
            public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
                Objects.requireNonNull(input);
                try {
                    return patch.apply(input);
                }
                catch (JsonPatchException e) {
                    throw new SwaggerMigrationException(e);
                }
            }
        };
    }

    public static SwaggerMigrator renameMember(final String from, final String to) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        return new SwaggerMigrator(){

            @Override
            @Nonnull
            public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
                Objects.requireNonNull(input);
                if (!input.has(from)) {
                    return input;
                }
                if (input.has(to)) {
                    throw new SwaggerMigrationException("object already has a member named \"" + to + '\"');
                }
                ObjectNode ret = (ObjectNode)input.deepCopy();
                ret.put(to, ret.get(from));
                ret.remove(from);
                return ret;
            }
        };
    }

    public static SwaggerMigrator patchFromResource(String resourcePath) {
        JsonPatch patch;
        Objects.requireNonNull(resourcePath);
        try {
            JsonNode node2 = JsonLoader.fromResource(resourcePath);
            patch = MAPPER.readValue(node2.traverse(), JsonPatch.class);
        }
        catch (IOException e) {
            throw new RuntimeException("cannot load resource", e);
        }
        return SwaggerMigrators.fromPatch(patch);
    }

    public static final class MembersToString
    implements SwaggerMigrator {
        private final Set<String> memberNames;

        private MembersToString(String first2, String ... others) {
            this.memberNames = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(first2)).add(others)).build();
        }

        @Override
        @Nonnull
        public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
            Objects.requireNonNull(input, "input cannot be null");
            ObjectNode ret = (ObjectNode)input.deepCopy();
            for (String memberName : this.memberNames) {
                JsonNode node2 = input.path(memberName);
                if (node2.isMissingNode()) continue;
                if (node2.isContainerNode()) {
                    throw new SwaggerMigrationException("operation does not apply to JSON arrays or objects");
                }
                if (node2.isTextual()) continue;
                ret.put(memberName, node2.asText());
            }
            return ret;
        }
    }
}

