/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.util.Json;
import java.io.IOException;

public class ParameterDeserializer
extends JsonDeserializer<Parameter> {
    @Override
    public Parameter deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Parameter result = null;
        JsonNode node2 = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode sub = node2.get("$ref");
        JsonNode inNode = node2.get("in");
        if (sub != null) {
            result = Json.mapper().convertValue((Object)sub, RefParameter.class);
        } else if (inNode != null) {
            String in = inNode.asText();
            if ("query".equals(in)) {
                result = Json.mapper().convertValue((Object)node2, QueryParameter.class);
            } else if ("header".equals(in)) {
                result = Json.mapper().convertValue((Object)node2, HeaderParameter.class);
            } else if ("path".equals(in)) {
                result = Json.mapper().convertValue((Object)node2, PathParameter.class);
            } else if ("formData".equals(in)) {
                result = Json.mapper().convertValue((Object)node2, FormParameter.class);
            } else if ("body".equals(in)) {
                result = Json.mapper().convertValue((Object)node2, BodyParameter.class);
            } else if ("cookie".equals(in)) {
                result = Json.mapper().convertValue((Object)node2, CookieParameter.class);
            }
        }
        return result;
    }
}

