/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.PasswordSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class ModelDeserializer
extends JsonDeserializer<Schema> {
    @Override
    public Schema deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String format;
        JsonNode node2 = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode allOf = node2.get("allOf");
        JsonNode anyOf = node2.get("anyOf");
        JsonNode oneOf = node2.get("oneOf");
        Schema schema = null;
        if (allOf != null || anyOf != null || oneOf != null) {
            return Json.mapper().convertValue((Object)node2, ComposedSchema.class);
        }
        JsonNode type = node2.get("type");
        String string = format = node2.get("format") == null ? "" : node2.get("format").textValue();
        if (type != null && "array".equals(((TextNode)type).textValue())) {
            schema = Json.mapper().convertValue((Object)node2, ArraySchema.class);
        } else if (type != null) {
            if (type.textValue().equals("integer")) {
                schema = Json.mapper().convertValue((Object)node2, IntegerSchema.class);
                if (StringUtils.isBlank(format)) {
                    schema.setFormat(null);
                }
            } else if (type.textValue().equals("number")) {
                schema = Json.mapper().convertValue((Object)node2, NumberSchema.class);
            } else if (type.textValue().equals("boolean")) {
                schema = Json.mapper().convertValue((Object)node2, BooleanSchema.class);
            } else if (type.textValue().equals("string")) {
                schema = "date".equals(format) ? (Schema)Json.mapper().convertValue((Object)node2, DateSchema.class) : ("date-time".equals(format) ? (Schema)Json.mapper().convertValue((Object)node2, DateTimeSchema.class) : ("email".equals(format) ? (Schema)Json.mapper().convertValue((Object)node2, EmailSchema.class) : ("password".equals(format) ? (Schema)Json.mapper().convertValue((Object)node2, PasswordSchema.class) : ("uuid".equals(format) ? (Schema)Json.mapper().convertValue((Object)node2, UUIDSchema.class) : (Schema)Json.mapper().convertValue((Object)node2, StringSchema.class)))));
            } else if (type.textValue().equals("object")) {
                schema = this.deserializeObjectSchema(node2);
            }
        } else {
            schema = node2.get("$ref") != null ? new Schema().$ref(node2.get("$ref").asText()) : this.deserializeObjectSchema(node2);
        }
        return schema;
    }

    private Schema deserializeObjectSchema(JsonNode node2) {
        JsonNode additionalProperties = node2.get("additionalProperties");
        Schema schema = null;
        if (additionalProperties != null) {
            try {
                Schema innerSchema = Json.mapper().convertValue((Object)additionalProperties, Schema.class);
                ((ObjectNode)node2).remove("additionalProperties");
                MapSchema ms = Json.mapper().convertValue((Object)node2, MapSchema.class);
                ms.setAdditionalProperties(innerSchema);
                schema = ms;
            }
            catch (Exception e) {
                Boolean additionalPropsBoolean = Json.mapper().convertValue((Object)additionalProperties, Boolean.class);
                schema = additionalPropsBoolean != false ? (Schema)Json.mapper().convertValue((Object)node2, MapSchema.class) : (Schema)Json.mapper().convertValue((Object)node2, ObjectSchema.class);
                schema.setAdditionalProperties(additionalPropsBoolean);
            }
        } else {
            schema = Json.mapper().convertValue((Object)node2, ObjectSchema.class);
        }
        return schema;
    }
}

