/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Set;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.ReflectionUtils;

class EquinoxClassLoaderHandler
implements ClassLoaderHandler {
    private static boolean alreadyReadSystemBundles;
    private static final String[] FIELD_NAMES;

    private EquinoxClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "org.eclipse.osgi.internal.loader.EquinoxClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    private static void addBundleFile(Object bundlefile, Set<Object> path, ClassLoader classLoader, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        if (bundlefile != null && path.add(bundlefile)) {
            Object baseFile = ReflectionUtils.getFieldVal(bundlefile, "basefile", false);
            if (baseFile != null) {
                boolean foundClassPathElement = false;
                for (String fieldName : FIELD_NAMES) {
                    Object baseBundleFile;
                    Object fieldVal = ReflectionUtils.getFieldVal(bundlefile, fieldName, false);
                    if (fieldVal == null) continue;
                    foundClassPathElement = true;
                    Object base = baseFile;
                    String sep = "/";
                    if (bundlefile.getClass().getName().equals("org.eclipse.osgi.storage.bundlefile.NestedDirBundleFile") && (baseBundleFile = ReflectionUtils.getFieldVal(bundlefile, "baseBundleFile", false)) != null && baseBundleFile.getClass().getName().equals("org.eclipse.osgi.storage.bundlefile.ZipBundleFile")) {
                        base = baseBundleFile;
                        sep = "!/";
                    }
                    String pathElement = base.toString() + sep + fieldVal.toString();
                    classpathOrderOut.addClasspathEntry((Object)pathElement, classLoader, scanSpec, log);
                    break;
                }
                if (!foundClassPathElement) {
                    classpathOrderOut.addClasspathEntry((Object)baseFile.toString(), classLoader, scanSpec, log);
                }
            }
            EquinoxClassLoaderHandler.addBundleFile(ReflectionUtils.getFieldVal(bundlefile, "wrapped", false), path, classLoader, classpathOrderOut, scanSpec, log);
            EquinoxClassLoaderHandler.addBundleFile(ReflectionUtils.getFieldVal(bundlefile, "next", false), path, classLoader, classpathOrderOut, scanSpec, log);
        }
    }

    private static void addClasspathEntries(Object owner, ClassLoader classLoader, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        Object entries = ReflectionUtils.getFieldVal(owner, "entries", false);
        if (entries != null) {
            int n = Array.getLength(entries);
            for (int i = 0; i < n; ++i) {
                Object entry = Array.get(entries, i);
                Object bundlefile = ReflectionUtils.getFieldVal(entry, "bundlefile", false);
                EquinoxClassLoaderHandler.addBundleFile(bundlefile, new HashSet<Object>(), classLoader, classpathOrderOut, scanSpec, log);
            }
        }
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Object manager = ReflectionUtils.getFieldVal(classLoader, "manager", false);
        EquinoxClassLoaderHandler.addClasspathEntries(manager, classLoader, classpathOrder, scanSpec, log);
        Object fragments = ReflectionUtils.getFieldVal(manager, "fragments", false);
        if (fragments != null) {
            int fragLength = Array.getLength(fragments);
            for (int f = 0; f < fragLength; ++f) {
                Object fragment = Array.get(fragments, f);
                EquinoxClassLoaderHandler.addClasspathEntries(fragment, classLoader, classpathOrder, scanSpec, log);
            }
        }
        if (!alreadyReadSystemBundles) {
            Object delegate = ReflectionUtils.getFieldVal(classLoader, "delegate", false);
            Object container = ReflectionUtils.getFieldVal(delegate, "container", false);
            Object storage = ReflectionUtils.getFieldVal(container, "storage", false);
            Object moduleContainer = ReflectionUtils.getFieldVal(storage, "moduleContainer", false);
            Object moduleDatabase = ReflectionUtils.getFieldVal(moduleContainer, "moduleDatabase", false);
            Object modulesById = ReflectionUtils.getFieldVal(moduleDatabase, "modulesById", false);
            Object module0 = ReflectionUtils.invokeMethod(modulesById, "get", Object.class, 0L, false);
            Object bundle2 = ReflectionUtils.invokeMethod(module0, "getBundle", false);
            Object bundleContext = ReflectionUtils.invokeMethod(bundle2, "getBundleContext", false);
            Object bundles = ReflectionUtils.invokeMethod(bundleContext, "getBundles", false);
            if (bundles != null) {
                int n = Array.getLength(bundles);
                for (int i = 0; i < n; ++i) {
                    int fileIdx;
                    Object equinoxBundle = Array.get(bundles, i);
                    Object module = ReflectionUtils.getFieldVal(equinoxBundle, "module", false);
                    String location = (String)ReflectionUtils.getFieldVal(module, "location", false);
                    if (location == null || (fileIdx = location.indexOf("file:")) < 0) continue;
                    location = location.substring(fileIdx);
                    classpathOrder.addClasspathEntry((Object)location, classLoader, scanSpec, log);
                }
            }
            alreadyReadSystemBundles = true;
        }
    }

    static {
        FIELD_NAMES = new String[]{"cp", "nestedDirName"};
    }
}

