/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classpath;

import io.github.classgraph.ClassGraph;
import java.io.File;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import nonapi.io.github.classgraph.classpath.SystemJarFinder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.FastPathResolver;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.JarUtils;
import nonapi.io.github.classgraph.utils.LogNode;

public class ClasspathOrder {
    private final ScanSpec scanSpec;
    private final Set<String> classpathEntryUniqueResolvedPaths = new HashSet<String>();
    private final List<ClasspathElementAndClassLoader> order = new ArrayList<ClasspathElementAndClassLoader>();

    ClasspathOrder(ScanSpec scanSpec) {
        this.scanSpec = scanSpec;
    }

    public List<ClasspathElementAndClassLoader> getOrder() {
        return this.order;
    }

    public Set<String> getClasspathEntryUniqueResolvedPaths() {
        return this.classpathEntryUniqueResolvedPaths;
    }

    private boolean filter(String classpathElementPath) {
        if (this.scanSpec.classpathElementFilters != null) {
            for (ClassGraph.ClasspathElementFilter filter2 : this.scanSpec.classpathElementFilters) {
                if (filter2.includeClasspathElement(classpathElementPath)) continue;
                return false;
            }
        }
        return true;
    }

    boolean addSystemClasspathEntry(String pathEntry, ClassLoader classLoader) {
        if (this.classpathEntryUniqueResolvedPaths.add(pathEntry)) {
            this.order.add(new ClasspathElementAndClassLoader(pathEntry, classLoader));
            return true;
        }
        return false;
    }

    private boolean addClasspathEntry(Object pathElement, String pathElementStr, ClassLoader classLoader, ScanSpec scanSpec) {
        if (pathElement instanceof URL || pathElement instanceof URI) {
            if (this.classpathEntryUniqueResolvedPaths.add(pathElementStr)) {
                this.order.add(new ClasspathElementAndClassLoader(pathElement, classLoader));
                return true;
            }
        } else {
            if (scanSpec.overrideClasspath == null && (SystemJarFinder.getJreLibOrExtJars().contains(pathElementStr) || pathElementStr.equals(SystemJarFinder.getJreRtJarPath()))) {
                return false;
            }
            if (this.classpathEntryUniqueResolvedPaths.add(pathElementStr)) {
                this.order.add(new ClasspathElementAndClassLoader(pathElementStr, classLoader));
                return true;
            }
        }
        return false;
    }

    public boolean addClasspathEntry(Object pathElement, ClassLoader classLoader, ScanSpec scanSpec, LogNode log) {
        if (pathElement == null) {
            return false;
        }
        String pathElementStr = pathElement.toString();
        if (pathElementStr.isEmpty()) {
            return false;
        }
        if (pathElement instanceof URL || pathElement instanceof URI || pathElement instanceof File) {
            String classpathElementObj;
            if (!this.filter(pathElementStr)) {
                if (log != null) {
                    log.log("Classpath element did not match filter criterion, skipping: " + pathElementStr);
                }
                return false;
            }
            try {
                classpathElementObj = pathElement instanceof File ? pathElementStr : (pathElement instanceof URI ? ((URI)pathElement).toURL() : pathElement);
            }
            catch (MalformedURLException e) {
                if (log != null) {
                    log.log("Cannot convert from URI to URL: " + pathElementStr);
                }
                return false;
            }
            if (this.addClasspathEntry((Object)classpathElementObj, pathElementStr, classLoader, scanSpec)) {
                if (log != null) {
                    log.log("Found classpath element: " + pathElementStr);
                }
                return true;
            }
            if (log != null) {
                log.log("Ignoring duplicate classpath element: " + pathElementStr);
            }
            return false;
        }
        if (pathElementStr.endsWith("*")) {
            if (pathElementStr.length() == 1 || pathElementStr.length() > 2 && pathElementStr.charAt(pathElementStr.length() - 1) == '*' && (pathElementStr.charAt(pathElementStr.length() - 2) == File.separatorChar || File.separatorChar != '/' && pathElementStr.charAt(pathElementStr.length() - 2) == '/')) {
                String baseDirPath = pathElementStr.length() == 1 ? "" : pathElementStr.substring(0, pathElementStr.length() - 2);
                String baseDirPathResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, baseDirPath);
                if (!this.filter(baseDirPath) || !baseDirPathResolved.equals(baseDirPath) && !this.filter(baseDirPathResolved)) {
                    if (log != null) {
                        log.log("Classpath element did not match filter criterion, skipping: " + pathElementStr);
                    }
                    return false;
                }
                File baseDir = new File(baseDirPathResolved);
                if (!baseDir.exists()) {
                    if (log != null) {
                        log.log("Directory does not exist for wildcard classpath element: " + pathElementStr);
                    }
                    return false;
                }
                if (!FileUtils.canRead(baseDir)) {
                    if (log != null) {
                        log.log("Cannot read directory for wildcard classpath element: " + pathElementStr);
                    }
                    return false;
                }
                if (!baseDir.isDirectory()) {
                    if (log != null) {
                        log.log("Wildcard is appended to something other than a directory: " + pathElementStr);
                    }
                    return false;
                }
                LogNode dirLog = log == null ? null : log.log("Adding classpath elements from wildcarded directory: " + pathElementStr);
                File[] baseDirFiles = baseDir.listFiles();
                if (baseDirFiles != null) {
                    for (File fileInDir : baseDirFiles) {
                        String name = fileInDir.getName();
                        if (name.equals(".") || name.equals("..")) continue;
                        String fileInDirPath = fileInDir.getPath();
                        String fileInDirPathResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, fileInDirPath);
                        if (this.addClasspathEntry((Object)fileInDirPathResolved, fileInDirPathResolved, classLoader, scanSpec)) {
                            if (dirLog == null) continue;
                            dirLog.log("Found classpath element: " + fileInDirPath + (fileInDirPath.equals(fileInDirPathResolved) ? "" : " -> " + fileInDirPathResolved));
                            continue;
                        }
                        if (dirLog == null) continue;
                        dirLog.log("Ignoring duplicate classpath element: " + fileInDirPath + (fileInDirPath.equals(fileInDirPathResolved) ? "" : " -> " + fileInDirPathResolved));
                    }
                    return true;
                }
                return false;
            }
            if (log != null) {
                log.log("Wildcard classpath elements can only end with a leaf of \"*\", can't have a partial name and then a wildcard: " + pathElementStr);
            }
            return false;
        }
        String pathElementResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, pathElementStr);
        if (!this.filter(pathElementStr) || !pathElementResolved.equals(pathElementStr) && !this.filter(pathElementResolved)) {
            if (log != null) {
                log.log("Classpath element did not match filter criterion, skipping: " + pathElementStr + (pathElementStr.equals(pathElementResolved) ? "" : " -> " + pathElementResolved));
            }
            return false;
        }
        if (this.addClasspathEntry((Object)pathElementResolved, pathElementResolved, classLoader, scanSpec)) {
            if (log != null) {
                log.log("Found classpath element: " + pathElementStr + (pathElementStr.equals(pathElementResolved) ? "" : " -> " + pathElementResolved));
            }
            return true;
        }
        if (log != null) {
            log.log("Ignoring duplicate classpath element: " + pathElementStr + (pathElementStr.equals(pathElementResolved) ? "" : " -> " + pathElementResolved));
        }
        return false;
    }

    public boolean addClasspathEntries(List<Object> overrideClasspath, ClassLoader classLoader, ScanSpec scanSpec, LogNode log) {
        if (overrideClasspath == null || overrideClasspath.isEmpty()) {
            return false;
        }
        for (Object pathElement : overrideClasspath) {
            this.addClasspathEntry(pathElement, classLoader, scanSpec, log);
        }
        return true;
    }

    public boolean addClasspathPathStr(String pathStr, ClassLoader classLoader, ScanSpec scanSpec, LogNode log) {
        if (pathStr == null || pathStr.isEmpty()) {
            return false;
        }
        String[] parts = JarUtils.smartPathSplit(pathStr, scanSpec);
        if (parts.length == 0) {
            return false;
        }
        for (String pathElement : parts) {
            this.addClasspathEntry((Object)pathElement, classLoader, scanSpec, log);
        }
        return true;
    }

    public boolean addClasspathEntryObject(Object pathObject, ClassLoader classLoader, ScanSpec scanSpec, LogNode log) {
        boolean valid = false;
        if (pathObject != null) {
            if (pathObject instanceof URL || pathObject instanceof URI) {
                valid |= this.addClasspathEntry(pathObject, classLoader, scanSpec, log);
            } else if (pathObject instanceof Iterable) {
                for (Object elt : (Iterable)pathObject) {
                    valid |= this.addClasspathEntryObject(elt, classLoader, scanSpec, log);
                }
            } else {
                Class<?> valClass = pathObject.getClass();
                if (valClass.isArray()) {
                    int n = Array.getLength(pathObject);
                    for (int j = 0; j < n; ++j) {
                        Object elt = Array.get(pathObject, j);
                        valid |= this.addClasspathEntryObject(elt, classLoader, scanSpec, log);
                    }
                } else {
                    valid |= this.addClasspathPathStr(pathObject.toString(), classLoader, scanSpec, log);
                }
            }
        }
        return valid;
    }

    public static class ClasspathElementAndClassLoader {
        public final Object classpathElement;
        public final ClassLoader classLoader;

        public ClasspathElementAndClassLoader(Object classpathElement, ClassLoader classLoader) {
            this.classpathElement = classpathElement;
            this.classLoader = classLoader;
        }

        public int hashCode() {
            return Objects.hash(this.classpathElement, this.classLoader);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClasspathElementAndClassLoader)) {
                return false;
            }
            ClasspathElementAndClassLoader other = (ClasspathElementAndClassLoader)obj;
            return Objects.equals(this.classpathElement, other.classpathElement) && Objects.equals(this.classLoader, other.classLoader);
        }
    }
}

