/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.util.typing;

import java.io.Serializable;
import java.math.BigDecimal;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.TrueSchema;
import pl.touk.nussknacker.engine.api.typed.typing;
import pl.touk.nussknacker.engine.api.typed.typing$Typed$;
import pl.touk.nussknacker.engine.api.typed.typing$TypedObjectTypingResult$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;

public final class SchemaToTypingResultConverter$ {
    public static SchemaToTypingResultConverter$ MODULE$;

    static {
        new SchemaToTypingResultConverter$();
    }

    public typing.TypingResult jsonSchemaToTypingResult(Schema schema) {
        Schema schema2 = schema;
        if (!(schema2 instanceof ObjectSchema)) {
            throw new IllegalArgumentException("Schema should be represented as object schema \"type\": \"object\"");
        }
        ObjectSchema objectSchema = (ObjectSchema)schema2;
        typing.TypingResult typingResult = this.parseObjectSchema(objectSchema);
        return typingResult;
    }

    private typing.TypingResult parseObjectSchema(ObjectSchema schema) {
        Map propertySchemas = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(schema.getPropertySchemas()).asScala()).toMap(Predef$.MODULE$.$conforms());
        return this.jsonValuesToTypingResult((Map<String, Schema>)propertySchemas);
    }

    private typing.TypingResult jsonValuesToTypingResult(Map<String, Schema> namedSchema) {
        return typing$TypedObjectTypingResult$.MODULE$.apply((List<Tuple2<String, typing.TypingResult>>)namedSchema.mapValues((Function1 & Serializable & scala.Serializable)schema -> MODULE$.resolveJsonTypingResult((Schema)schema)).toList());
    }

    public typing.TypingResult resolveJsonTypingResult(Schema schema) {
        typing.TypingResult typingResult;
        Schema schema2 = schema;
        if (schema2 instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema2;
            typingResult = this.getArrayTypingResult(arraySchema);
        } else if (schema2 instanceof ObjectSchema) {
            ObjectSchema objectSchema = (ObjectSchema)schema2;
            typingResult = this.parseObjectSchema(objectSchema);
        } else if (schema2 instanceof NumberSchema) {
            NumberSchema numberSchema = (NumberSchema)schema2;
            typingResult = numberSchema.requiresInteger() ? typing$Typed$.MODULE$.typedClass(ClassTag$.MODULE$.apply(Long.class)) : typing$Typed$.MODULE$.typedClass(ClassTag$.MODULE$.apply(BigDecimal.class));
        } else if (schema2 instanceof BooleanSchema) {
            typingResult = typing$Typed$.MODULE$.typedClass(ClassTag$.MODULE$.Boolean());
        } else if (schema2 instanceof TrueSchema) {
            typingResult = typing$Typed$.MODULE$.typedClass(ClassTag$.MODULE$.Boolean());
        } else if (schema2 instanceof FalseSchema) {
            typingResult = typing$Typed$.MODULE$.typedClass(ClassTag$.MODULE$.Boolean());
        } else if (schema2 instanceof NullSchema) {
            typingResult = typing$Typed$.MODULE$.typedClass(ClassTag$.MODULE$.Null());
        } else if (schema2 instanceof StringSchema) {
            typingResult = typing$Typed$.MODULE$.typedClass(ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new IllegalArgumentException(new StringBuilder(31).append("Schema '").append(schema2.toString()).append("' is not supported yet.").toString());
        }
        return typingResult;
    }

    public typing.TypingResult getArrayTypingResult(ArraySchema schema) {
        Schema itemSchema = schema.getAllItemSchema();
        return typing$Typed$.MODULE$.genericTypeClass((List<typing.TypingResult>)new .colon.colon((Object)this.resolveJsonTypingResult(itemSchema), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(java.util.List.class));
    }

    private SchemaToTypingResultConverter$() {
        MODULE$ = this;
    }
}

