/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.openapi.extractor;

import io.circe.Json;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import pl.touk.nussknacker.engine.api.typed.TypedMap$;
import pl.touk.nussknacker.openapi.SwaggerArray;
import pl.touk.nussknacker.openapi.SwaggerBigDecimal$;
import pl.touk.nussknacker.openapi.SwaggerBool$;
import pl.touk.nussknacker.openapi.SwaggerDateTime$;
import pl.touk.nussknacker.openapi.SwaggerDouble$;
import pl.touk.nussknacker.openapi.SwaggerEnum;
import pl.touk.nussknacker.openapi.SwaggerLong$;
import pl.touk.nussknacker.openapi.SwaggerObject;
import pl.touk.nussknacker.openapi.SwaggerString$;
import pl.touk.nussknacker.openapi.SwaggerTyped;
import pl.touk.nussknacker.openapi.extractor.JsonToObject;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector$;
import scala.runtime.BoxesRunTime;

public final class JsonToObject$ {
    public static JsonToObject$ MODULE$;

    static {
        new JsonToObject$();
    }

    public Object apply(Json json, SwaggerTyped definition) {
        Object object;
        SwaggerTyped swaggerTyped = definition;
        if (json.isNull()) {
            object = null;
        } else if (SwaggerString$.MODULE$.equals(swaggerTyped)) {
            object = JsonToObject$.extract$1((Function1 & Serializable & scala.Serializable)x$3 -> x$3.asString(), JsonToObject$.extract$default$2$1(), json, definition);
        } else if (swaggerTyped instanceof SwaggerEnum) {
            object = JsonToObject$.extract$1((Function1 & Serializable & scala.Serializable)x$4 -> x$4.asString(), JsonToObject$.extract$default$2$1(), json, definition);
        } else if (SwaggerBool$.MODULE$.equals(swaggerTyped)) {
            object = JsonToObject$.extract$1((Function1 & Serializable & scala.Serializable)x$5 -> x$5.asBoolean(), (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.boolean2Boolean(BoxesRunTime.unboxToBoolean((Object)x)), json, definition);
        } else if (SwaggerLong$.MODULE$.equals(swaggerTyped)) {
            object = JsonToObject$.extract$1((Function1 & Serializable & scala.Serializable)x$6 -> x$6.asNumber(), (Function1 & Serializable & scala.Serializable)n -> Predef$.MODULE$.long2Long((long)n.toDouble()), json, definition);
        } else if (SwaggerDateTime$.MODULE$.equals(swaggerTyped)) {
            object = JsonToObject$.extract$1((Function1 & Serializable & scala.Serializable)x$7 -> x$7.asString(), (Function1 & Serializable & scala.Serializable)dateTime -> MODULE$.parseDateTime((String)dateTime), json, definition);
        } else if (SwaggerDouble$.MODULE$.equals(swaggerTyped)) {
            object = JsonToObject$.extract$1((Function1 & Serializable & scala.Serializable)x$8 -> x$8.asNumber(), (Function1 & Serializable & scala.Serializable)n -> Predef$.MODULE$.double2Double(n.toDouble()), json, definition);
        } else if (SwaggerBigDecimal$.MODULE$.equals(swaggerTyped)) {
            object = JsonToObject$.extract$1((Function1 & Serializable & scala.Serializable)x$9 -> x$9.asNumber(), (Function1 & Serializable & scala.Serializable)x$10 -> x$10.toBigDecimal().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.bigDecimal()).orNull(Predef$.MODULE$.$conforms()), json, definition);
        } else if (swaggerTyped instanceof SwaggerArray) {
            SwaggerArray swaggerArray = (SwaggerArray)swaggerTyped;
            SwaggerTyped elementType = swaggerArray.elementType();
            object = JsonToObject$.extract$1((Function1 & Serializable & scala.Serializable)x$12 -> x$12.asArray(), (Function1 & Serializable & scala.Serializable)x$13 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)x$13.map((Function1 & Serializable & scala.Serializable)x$14 -> MODULE$.apply((Json)x$14, elementType), Vector$.MODULE$.canBuildFrom())).asJava(), json, definition);
        } else if (swaggerTyped instanceof SwaggerObject) {
            SwaggerObject swaggerObject = (SwaggerObject)swaggerTyped;
            Map<String, SwaggerTyped> elementType = swaggerObject.elementType();
            Set<String> required = swaggerObject.required();
            object = JsonToObject$.extractObject$1(elementType, required, json, definition);
        } else {
            throw new MatchError((Object)swaggerTyped);
        }
        return object;
    }

    private LocalDateTime parseDateTime(String dateTime2) {
        return (LocalDateTime)Option$.MODULE$.apply((Object)dateTime2).filterNot((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.isEmpty())).map((Function1 & Serializable & scala.Serializable)dateTime -> LocalDateTime.ofInstant(ZonedDateTime.parse(dateTime, DateTimeFormatter.ISO_DATE_TIME).toInstant(), ZoneId.systemDefault())).orNull(Predef$.MODULE$.$conforms());
    }

    private static final Object extract$1(Function1 fun, Function1 trans, Json json$1, SwaggerTyped definition$1) {
        return ((Option)fun.apply((Object)json$1)).map(trans).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new JsonToObject.JsonToObjectError(json$1, definition$1);
        });
    }

    private static final Function1 extract$default$2$1() {
        return (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x);
    }

    private static final Object nullOrError$1(String jsonField, Set required$1, Json json$1, SwaggerTyped definition$1) {
        if (required$1.contains((Object)jsonField)) {
            throw new JsonToObject.JsonToObjectError(json$1, definition$1);
        }
        return null;
    }

    private static final Object extractObject$1(Map elementType, Set required, Json json$1, SwaggerTyped definition$1) {
        return JsonToObject$.extract$1((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asObject(), (Function1 & Serializable & scala.Serializable)jo -> TypedMap$.MODULE$.apply((Map<String, Object>)((Map)elementType.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String jsonField = (String)tuple2._1();
            SwaggerTyped jsonDef = (SwaggerTyped)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)jsonField), jo.apply(jsonField).map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.apply((Json)x$2, jsonDef)).getOrElse((Function0 & Serializable & scala.Serializable)() -> JsonToObject$.nullOrError$1(jsonField, required, json$1, definition$1)));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()))), json$1, definition$1);
    }

    private JsonToObject$() {
        MODULE$ = this;
    }
}

