/*
 * Decompiled with CFR 0.152.
 */
package sttp.model;

import java.io.Serializable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sttp.model.Cookie$;
import sttp.model.CookieValueWithMeta;
import sttp.model.CookieValueWithMeta$;
import sttp.model.CookieWithMeta;
import sttp.model.internal.Validate$;

public final class CookieWithMeta$
implements scala.Serializable {
    public static CookieWithMeta$ MODULE$;
    private final String Rfc850DatetimePattern;
    private final DateTimeFormatter Rfc850DatetimeFormat;
    private final Set<String> Rfc850WeekDays;
    private volatile byte bitmap$init$0;

    static {
        new CookieWithMeta$();
    }

    public CookieWithMeta unsafeApply(String name, String value, Option<Instant> expires, Option<Object> maxAge, Option<String> domain, Option<String> path, boolean secure, boolean httpOnly, Map<String, Option<String>> otherDirectives) {
        return Validate$.MODULE$.RichEither(this.safeApply(name, value, expires, maxAge, domain, path, secure, httpOnly, otherDirectives)).getOrThrow();
    }

    public Option<Instant> unsafeApply$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> unsafeApply$default$4() {
        return None$.MODULE$;
    }

    public Option<String> unsafeApply$default$5() {
        return None$.MODULE$;
    }

    public Option<String> unsafeApply$default$6() {
        return None$.MODULE$;
    }

    public boolean unsafeApply$default$7() {
        return false;
    }

    public boolean unsafeApply$default$8() {
        return false;
    }

    public Map<String, Option<String>> unsafeApply$default$9() {
        return Predef$.MODULE$.Map().empty();
    }

    public Either<String, CookieWithMeta> safeApply(String name, String value, Option<Instant> expires, Option<Object> maxAge, Option<String> domain, Option<String> path, boolean secure, boolean httpOnly, Map<String, Option<String>> otherDirectives) {
        Left left;
        Option<String> option = Cookie$.MODULE$.validateName(name);
        if (option instanceof Some) {
            Some some = (Some)option;
            String e = (String)some.value();
            left = package$.MODULE$.Left().apply((Object)e);
        } else if (None$.MODULE$.equals(option)) {
            left = CookieValueWithMeta$.MODULE$.safeApply(value, expires, maxAge, domain, path, secure, httpOnly, otherDirectives).right().map((Function1 & Serializable & scala.Serializable)v -> MODULE$.apply(name, (CookieValueWithMeta)v));
        } else {
            throw new MatchError(option);
        }
        return left;
    }

    public Option<Instant> safeApply$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> safeApply$default$4() {
        return None$.MODULE$;
    }

    public Option<String> safeApply$default$5() {
        return None$.MODULE$;
    }

    public Option<String> safeApply$default$6() {
        return None$.MODULE$;
    }

    public boolean safeApply$default$7() {
        return false;
    }

    public boolean safeApply$default$8() {
        return false;
    }

    public Map<String, Option<String>> safeApply$default$9() {
        return Predef$.MODULE$.Map().empty();
    }

    public CookieWithMeta apply(String name, String value, Option<Instant> expires, Option<Object> maxAge, Option<String> domain, Option<String> path, boolean secure, boolean httpOnly, Map<String, Option<String>> otherDirectives) {
        return this.apply(name, new CookieValueWithMeta(value, expires, maxAge, domain, path, secure, httpOnly, otherDirectives));
    }

    public Option<Instant> apply$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$5() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$6() {
        return None$.MODULE$;
    }

    public boolean apply$default$7() {
        return false;
    }

    public boolean apply$default$8() {
        return false;
    }

    public Map<String, Option<String>> apply$default$9() {
        return Predef$.MODULE$.Map().empty();
    }

    public CookieWithMeta notValidated(String name, String value, Option<Instant> expires, Option<Object> maxAge, Option<String> domain, Option<String> path, boolean secure, boolean httpOnly, Map<String, Option<String>> otherDirectives) {
        return this.apply(name, value, expires, maxAge, domain, path, secure, httpOnly, otherDirectives);
    }

    public CookieWithMeta notValidated(String name, CookieValueWithMeta valueWithMeta) {
        return this.apply(name, valueWithMeta);
    }

    public Option<Instant> notValidated$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> notValidated$default$4() {
        return None$.MODULE$;
    }

    public Option<String> notValidated$default$5() {
        return None$.MODULE$;
    }

    public Option<String> notValidated$default$6() {
        return None$.MODULE$;
    }

    public boolean notValidated$default$7() {
        return false;
    }

    public boolean notValidated$default$8() {
        return false;
    }

    public Map<String, Option<String>> notValidated$default$9() {
        return Predef$.MODULE$.Map().empty();
    }

    public Either<String, CookieWithMeta> parse(String s2) {
        String[] components = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s2.split(";"))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Tuple2 tuple2 = new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])components)).head(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])components)).tail());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String first2 = (String)tuple2._1();
        String[] other = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)first2, (Object)other);
        Tuple2 tuple23 = tuple22;
        String first3 = (String)tuple23._1();
        String[] other2 = (String[])tuple23._2();
        Tuple2 tuple24 = CookieWithMeta$.splitkv$1(first3);
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        String name = (String)tuple24._1();
        Option value = (Option)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)name, (Object)value);
        Tuple2 tuple26 = tuple25;
        String name2 = (String)tuple26._1();
        Option value2 = (Option)tuple26._2();
        ObjectRef result = ObjectRef.create((Object)package$.MODULE$.Right().apply((Object)this.apply(name2, (String)value2.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), this.apply$default$3(), this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8(), this.apply$default$9())));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])other2)).map((Function1 & Serializable & scala.Serializable)kv -> CookieWithMeta$.splitkv$1(kv), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2(t._1(), t._2()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CookieWithMeta$.$anonfun$parse$8(result, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Either)result.elem;
    }

    private String Rfc850DatetimePattern() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/adamw/projects/sttp-model/core/shared/src/main/scala/sttp/model/Cookie.scala: 293");
        }
        return this.Rfc850DatetimePattern;
    }

    private DateTimeFormatter Rfc850DatetimeFormat() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/adamw/projects/sttp-model/core/shared/src/main/scala/sttp/model/Cookie.scala: 294");
        }
        return this.Rfc850DatetimeFormat;
    }

    public Set<String> Rfc850WeekDays() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/adamw/projects/sttp-model/core/shared/src/main/scala/sttp/model/Cookie.scala: 296");
        }
        return this.Rfc850WeekDays;
    }

    private Instant parseRfc850DateTime(String v) {
        String[] expiresParts = v.split(", ");
        if (expiresParts.length != 2) {
            throw new Exception("There must be exactly one \", \"");
        }
        if (!this.Rfc850WeekDays().contains((Object)expiresParts[0].trim().toLowerCase(Locale.ENGLISH))) {
            throw new Exception("String must start with weekday name");
        }
        return Instant.from(this.Rfc850DatetimeFormat().parse(expiresParts[1]));
    }

    private Either<BoxedUnit, Instant> parseDatetime(String v) {
        Right right;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(v)));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Instant r = (Instant)success.value();
            right = package$.MODULE$.Right().apply((Object)r);
        } else if (try_ instanceof Failure) {
            Left left;
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.parseRfc850DateTime(v));
            if (try_2 instanceof Success) {
                Success success = (Success)try_2;
                Instant r = (Instant)success.value();
                left = package$.MODULE$.Right().apply((Object)r);
            } else if (try_2 instanceof Failure) {
                left = package$.MODULE$.Left().apply((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError((Object)try_2);
            }
            right = left;
        } else {
            throw new MatchError((Object)try_);
        }
        return right;
    }

    private CookieWithMeta.StringInterpolations StringInterpolations(StringContext sc) {
        return new CookieWithMeta.StringInterpolations(sc);
    }

    public CookieWithMeta apply(String name, CookieValueWithMeta valueWithMeta) {
        return new CookieWithMeta(name, valueWithMeta);
    }

    public Option<Tuple2<String, CookieValueWithMeta>> unapply(CookieWithMeta x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.name(), (Object)x$0.valueWithMeta()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Tuple2 splitkv$1(String kv) {
        Tuple2 tuple2;
        String[] stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv.split("=", 2))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
            String v1 = (String)((SeqLike)option.get()).apply(0);
            tuple2 = new Tuple2((Object)v1, (Object)None$.MODULE$);
        } else {
            Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
                String v1 = (String)((SeqLike)option2.get()).apply(0);
                String v2 = (String)((SeqLike)option2.get()).apply(1);
                tuple2 = new Tuple2((Object)v1, (Object)new Some((Object)v2));
            } else {
                throw new MatchError((Object)stringArray);
            }
        }
        return tuple2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$parse$8(ObjectRef result$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (MODULE$.StringInterpolations(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expires"}))).ci().unapply(string) && option instanceof Some) {
                Some some = (Some)option;
                String v = (String)some.value();
                Either<BoxedUnit, Instant> either2 = MODULE$.parseDatetime(v);
                if (either2 instanceof Right) {
                    Right right = (Right)either2;
                    Instant expires = (Instant)right.value();
                    result$1.elem = ((Either)result$1.elem).right().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.expires((Option<Instant>)new Some((Object)expires)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (!(either2 instanceof Left)) throw new MatchError(either2);
                    result$1.elem = package$.MODULE$.Left().apply((Object)new StringBuilder(68).append("Expires cookie directive is not a valid RFC1123 or RFC850 datetime: ").append(v).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (MODULE$.StringInterpolations(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max-age"}))).ci().unapply(string) && option instanceof Some) {
                Some some = (Some)option;
                String v = (String)some.value();
                Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(v)).toLong());
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    long maxAge = BoxesRunTime.unboxToLong((Object)success.value());
                    result$1.elem = ((Either)result$1.elem).right().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.maxAge((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)maxAge))));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                    result$1.elem = package$.MODULE$.Left().apply((Object)new StringBuilder(42).append("Max-Age cookie directive is not a number: ").append(v).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Option v = (Option)tuple2._2();
            if (MODULE$.StringInterpolations(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"domain"}))).ci().unapply(string)) {
                result$1.elem = ((Either)result$1.elem).right().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.domain((Option<String>)new Some(v.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Option v = (Option)tuple2._2();
            if (MODULE$.StringInterpolations(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"path"}))).ci().unapply(string)) {
                result$1.elem = ((Either)result$1.elem).right().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.path((Option<String>)new Some(v.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            if (MODULE$.StringInterpolations(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"secure"}))).ci().unapply(string)) {
                result$1.elem = ((Either)result$1.elem).right().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.secure(true));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            if (MODULE$.StringInterpolations(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"httponly"}))).ci().unapply(string)) {
                result$1.elem = ((Either)result$1.elem).right().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.httpOnly(true));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String k = (String)tuple2._1();
        Option v = (Option)tuple2._2();
        result$1.elem = ((Either)result$1.elem).right().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.otherDirective((Tuple2<String, Option<String>>)new Tuple2((Object)k, (Object)v)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private CookieWithMeta$() {
        MODULE$ = this;
        this.Rfc850DatetimePattern = "dd-MMM-yyyy HH:mm:ss zzz";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.Rfc850DatetimeFormat = DateTimeFormatter.ofPattern(this.Rfc850DatetimePattern(), Locale.US);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.Rfc850WeekDays = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mon", "tue", "wed", "thu", "fri", "sat", "sun"}));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

