/*
 * Decompiled with CFR 0.152.
 */
package sttp.model;

import java.io.Serializable;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple7;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import sttp.model.Uri;
import sttp.model.Uri$FragmentSegment$;
import sttp.model.Uri$HostSegment$;
import sttp.model.Uri$PathSegment$;
import sttp.model.UriInterpolator;
import sttp.model.internal.Validate$;

public final class Uri$
implements UriInterpolator,
scala.Serializable {
    public static Uri$ MODULE$;
    private final Regex AllowedSchemeCharacters;
    private volatile int bitmap$init$0;

    static {
        new Uri$();
    }

    @Override
    public UriInterpolator.UriContext UriContext(StringContext sc) {
        return UriInterpolator.UriContext$(this, sc);
    }

    private Regex AllowedSchemeCharacters() {
        if ((this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/adamw/projects/sttp-model/core/shared/src/main/scala/sttp/model/Uri.scala: 225");
        }
        return this.AllowedSchemeCharacters;
    }

    private Option<String> validateHost(String h2) {
        return h2.isEmpty() ? new Some((Object)"Host cannot be empty") : None$.MODULE$;
    }

    private Option<String> validateScheme(String s2) {
        return this.AllowedSchemeCharacters().unapplySeq((CharSequence)s2).isEmpty() ? new Some((Object)"Scheme can only contain alphanumeric characters, +, - and .") : None$.MODULE$;
    }

    public Either<String, Uri> safeApply(String host) {
        return this.safeApply("http", (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String host, int port) {
        return this.safeApply("http", (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String host, int port, scala.collection.immutable.Seq<String> path) {
        return this.safeApply("http", (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$14 -> Uri$PathSegment$.MODULE$.apply((String)x$14), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host) {
        return this.safeApply(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host, int port) {
        return this.safeApply(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host, int port, scala.collection.immutable.Seq<String> path) {
        return this.safeApply(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$15 -> Uri$PathSegment$.MODULE$.apply((String)x$15), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host, scala.collection.immutable.Seq<String> path) {
        return this.safeApply(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$16 -> Uri$PathSegment$.MODULE$.apply((String)x$16), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host, scala.collection.immutable.Seq<String> path, Option<String> fragment) {
        return this.safeApply(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$17 -> Uri$PathSegment$.MODULE$.apply((String)x$17), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)fragment.map((Function1 & Serializable & scala.Serializable)x$18 -> Uri$FragmentSegment$.MODULE$.apply((String)x$18)));
    }

    public Either<String, Uri> safeApply(String scheme, Option<Uri.UserInfo> userInfo, String host, Option<Object> port, scala.collection.immutable.Seq<String> path, scala.collection.immutable.Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return this.safeApply(scheme, userInfo, Uri$HostSegment$.MODULE$.apply(host), port, (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$19 -> Uri$PathSegment$.MODULE$.apply((String)x$19), Seq$.MODULE$.canBuildFrom())), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable & scala.Serializable)x$20 -> Uri$FragmentSegment$.MODULE$.apply((String)x$20)));
    }

    public Either<String, Uri> safeApply(String scheme, Option<Uri.UserInfo> userInfo, Uri.Segment hostSegment, Option<Object> port, scala.collection.immutable.Seq<Uri.Segment> pathSegments, scala.collection.immutable.Seq<Uri.QuerySegment> querySegments, Option<Uri.Segment> fragmentSegment) {
        return Validate$.MODULE$.all((Seq<Option<String>>)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{this.validateScheme(scheme), this.validateHost(hostSegment.v())}), (Function0 & Serializable & scala.Serializable)() -> new Uri(scheme, userInfo, hostSegment, port, pathSegments, querySegments, fragmentSegment));
    }

    public Uri unsafeApply(String host) {
        return this.unsafeApply("http", (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String host, int port) {
        return this.unsafeApply("http", (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String host, int port, scala.collection.immutable.Seq<String> path) {
        return this.unsafeApply("http", (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$21 -> Uri$PathSegment$.MODULE$.apply((String)x$21), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host) {
        return this.unsafeApply(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host, int port) {
        return this.unsafeApply(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host, int port, scala.collection.immutable.Seq<String> path) {
        return this.unsafeApply(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$22 -> Uri$PathSegment$.MODULE$.apply((String)x$22), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host, scala.collection.immutable.Seq<String> path) {
        return this.unsafeApply(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$23 -> Uri$PathSegment$.MODULE$.apply((String)x$23), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host, scala.collection.immutable.Seq<String> path, Option<String> fragment) {
        return this.unsafeApply(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$24 -> Uri$PathSegment$.MODULE$.apply((String)x$24), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)fragment.map((Function1 & Serializable & scala.Serializable)x$25 -> Uri$FragmentSegment$.MODULE$.apply((String)x$25)));
    }

    public Uri unsafeApply(String scheme, Option<Uri.UserInfo> userInfo, String host, Option<Object> port, scala.collection.immutable.Seq<String> path, scala.collection.immutable.Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return this.unsafeApply(scheme, userInfo, Uri$HostSegment$.MODULE$.apply(host), port, (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$26 -> Uri$PathSegment$.MODULE$.apply((String)x$26), Seq$.MODULE$.canBuildFrom())), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable & scala.Serializable)x$27 -> Uri$FragmentSegment$.MODULE$.apply((String)x$27)));
    }

    public Uri unsafeApply(String scheme, Option<Uri.UserInfo> userInfo, Uri.Segment hostSegment, Option<Object> port, scala.collection.immutable.Seq<Uri.Segment> pathSegments, scala.collection.immutable.Seq<Uri.QuerySegment> querySegments, Option<Uri.Segment> fragmentSegment) {
        return Validate$.MODULE$.RichEither(this.safeApply(scheme, userInfo, hostSegment, port, pathSegments, querySegments, fragmentSegment)).getOrThrow();
    }

    public Uri apply(String host) {
        return new Uri("http", (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String host, int port) {
        return new Uri("http", (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String host, int port, scala.collection.immutable.Seq<String> path) {
        return new Uri("http", (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$28 -> Uri$PathSegment$.MODULE$.apply((String)x$28), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host) {
        return new Uri(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host, int port) {
        return new Uri(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host, int port, scala.collection.immutable.Seq<String> path) {
        return new Uri(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$29 -> Uri$PathSegment$.MODULE$.apply((String)x$29), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host, scala.collection.immutable.Seq<String> path) {
        return new Uri(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$30 -> Uri$PathSegment$.MODULE$.apply((String)x$30), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host, scala.collection.immutable.Seq<String> path, Option<String> fragment) {
        return new Uri(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$31 -> Uri$PathSegment$.MODULE$.apply((String)x$31), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)fragment.map((Function1 & Serializable & scala.Serializable)x$32 -> Uri$FragmentSegment$.MODULE$.apply((String)x$32)));
    }

    public Uri apply(String scheme, Option<Uri.UserInfo> userInfo, String host, Option<Object> port, scala.collection.immutable.Seq<String> path, scala.collection.immutable.Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return new Uri(scheme, userInfo, Uri$HostSegment$.MODULE$.apply(host), port, (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$33 -> Uri$PathSegment$.MODULE$.apply((String)x$33), Seq$.MODULE$.canBuildFrom())), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable & scala.Serializable)x$34 -> Uri$FragmentSegment$.MODULE$.apply((String)x$34)));
    }

    public Uri notValidated(String host) {
        return new Uri("http", (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri notValidated(String host, int port) {
        return new Uri("http", (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri notValidated(String host, int port, scala.collection.immutable.Seq<String> path) {
        return new Uri("http", (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$35 -> Uri$PathSegment$.MODULE$.apply((String)x$35), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri notValidated(String scheme, String host) {
        return new Uri(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri notValidated(String scheme, String host, int port) {
        return new Uri(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri notValidated(String scheme, String host, int port, scala.collection.immutable.Seq<String> path) {
        return new Uri(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$36 -> Uri$PathSegment$.MODULE$.apply((String)x$36), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri notValidated(String scheme, String host, scala.collection.immutable.Seq<String> path) {
        return new Uri(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$37 -> Uri$PathSegment$.MODULE$.apply((String)x$37), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri notValidated(String scheme, String host, scala.collection.immutable.Seq<String> path, Option<String> fragment) {
        return new Uri(scheme, (Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host), (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$38 -> Uri$PathSegment$.MODULE$.apply((String)x$38), Seq$.MODULE$.canBuildFrom())), (scala.collection.immutable.Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)fragment.map((Function1 & Serializable & scala.Serializable)x$39 -> Uri$FragmentSegment$.MODULE$.apply((String)x$39)));
    }

    public Uri notValidated(String scheme, Option<Uri.UserInfo> userInfo, String host, Option<Object> port, scala.collection.immutable.Seq<String> path, scala.collection.immutable.Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return new Uri(scheme, userInfo, Uri$HostSegment$.MODULE$.apply(host), port, (scala.collection.immutable.Seq<Uri.Segment>)((scala.collection.immutable.Seq)path.map((Function1 & Serializable & scala.Serializable)x$40 -> Uri$PathSegment$.MODULE$.apply((String)x$40), Seq$.MODULE$.canBuildFrom())), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable & scala.Serializable)x$41 -> Uri$FragmentSegment$.MODULE$.apply((String)x$41)));
    }

    public Uri notValidated(String scheme, Option<Uri.UserInfo> userInfo, Uri.Segment hostSegment, Option<Object> port, scala.collection.immutable.Seq<Uri.Segment> pathSegments, scala.collection.immutable.Seq<Uri.QuerySegment> querySegments, Option<Uri.Segment> fragmentSegment) {
        return new Uri(scheme, userInfo, hostSegment, port, pathSegments, querySegments, fragmentSegment);
    }

    public Uri apply(URI javaUri) {
        return this.UriContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).uri((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{javaUri.toString()}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<String, Uri> parse(String uri) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.UriContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).uri((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Uri u = (Uri)success.value();
            return package$.MODULE$.Right().apply((Object)u);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable e = failure.exception();
            if (e instanceof Exception) {
                Exception exception = (Exception)e;
                return package$.MODULE$.Left().apply((Object)exception.getMessage());
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable t = failure.exception();
        if (t == null) throw new MatchError((Object)try_);
        Throwable throwable = t;
        throw throwable;
    }

    public Uri apply(String scheme, Option<Uri.UserInfo> userInfo, Uri.Segment hostSegment, Option<Object> port, scala.collection.immutable.Seq<Uri.Segment> pathSegments, scala.collection.immutable.Seq<Uri.QuerySegment> querySegments, Option<Uri.Segment> fragmentSegment) {
        return new Uri(scheme, userInfo, hostSegment, port, pathSegments, querySegments, fragmentSegment);
    }

    public Option<Tuple7<String, Option<Uri.UserInfo>, Uri.Segment, Option<Object>, scala.collection.immutable.Seq<Uri.Segment>, scala.collection.immutable.Seq<Uri.QuerySegment>, Option<Uri.Segment>>> unapply(Uri x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.scheme(), x$0.userInfo(), (Object)x$0.hostSegment(), x$0.port(), x$0.pathSegments(), x$0.querySegments(), x$0.fragmentSegment()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Uri$() {
        MODULE$ = this;
        UriInterpolator.$init$(this);
        this.AllowedSchemeCharacters = new StringOps(Predef$.MODULE$.augmentString("[a-zA-Z][a-zA-Z0-9+-.]*")).r();
        this.bitmap$init$0 |= 1;
    }
}

