/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.diff.Diff;
import com.github.fge.jsonpatch.diff.DiffFactorizer;
import com.github.fge.jsonpatch.diff.DiffOperation;
import com.github.fge.jsonpatch.diff.IndexedJsonArray;
import com.github.fge.jsonpatch.diff.LCS;
import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public final class JsonDiff {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();

    private JsonDiff() {
    }

    public static JsonNode asJson(JsonNode source, JsonNode target) {
        ArrayList<Diff> diffs = Lists.newArrayList();
        JsonDiff.generateDiffs(diffs, JsonPointer.empty(), source, target);
        DiffFactorizer.factorizeDiffs(diffs);
        ArrayNode patch = FACTORY.arrayNode();
        for (Diff diff : diffs) {
            patch.add(diff.asJsonPatch());
        }
        return patch;
    }

    private static void generateDiffs(List<Diff> diffs, JsonPointer path, JsonNode source, JsonNode target) {
        NodeType targetType;
        if (EQUIVALENCE.equivalent(source, target)) {
            return;
        }
        NodeType sourceType = NodeType.getNodeType(source);
        if (sourceType != (targetType = NodeType.getNodeType(target)) || !source.isContainerNode()) {
            diffs.add(Diff.simpleDiff(DiffOperation.REPLACE, path, target));
            return;
        }
        if (sourceType == NodeType.OBJECT) {
            JsonDiff.generateObjectDiffs(diffs, path, source, target);
        } else {
            JsonDiff.generateArrayDiffs(diffs, path, source, target);
        }
    }

    private static void generateObjectDiffs(List<Diff> diffs, JsonPointer path, JsonNode source, JsonNode target) {
        ArrayList<String> inFirst = Lists.newArrayList(source.fieldNames());
        ArrayList<String> inSecond = Lists.newArrayList(target.fieldNames());
        ArrayList<String> fields = Lists.newArrayList(inSecond);
        fields.removeAll(inFirst);
        for (String s : fields) {
            diffs.add(Diff.simpleDiff(DiffOperation.ADD, path.append(s), target.get(s)));
        }
        fields = Lists.newArrayList(inFirst);
        fields.removeAll(inSecond);
        for (String s : fields) {
            diffs.add(Diff.simpleDiff(DiffOperation.REMOVE, path.append(s), source.get(s)));
        }
        fields = Lists.newArrayList(inFirst);
        fields.retainAll(inSecond);
        for (String s : fields) {
            JsonDiff.generateDiffs(diffs, path.append(s), source.get(s), target.get(s));
        }
    }

    private static void generateArrayDiffs(List<Diff> diffs, JsonPointer path, JsonNode source, JsonNode target) {
        IndexedJsonArray src = new IndexedJsonArray(source);
        IndexedJsonArray dst = new IndexedJsonArray(target);
        IndexedJsonArray lcs = LCS.doLCS(source, target);
        JsonDiff.preLCS(diffs, path, lcs, src, dst);
        JsonDiff.inLCS(diffs, path, lcs, src, dst);
        JsonDiff.postLCS(diffs, path, src, dst);
    }

    private static void preLCS(List<Diff> diffs, JsonPointer path, IndexedJsonArray lcs, IndexedJsonArray source, IndexedJsonArray target) {
        if (lcs.isEmpty()) {
            return;
        }
        JsonNode sentinel = lcs.getElement();
        while (true) {
            int nrEquivalences = 0;
            JsonNode srcNode = source.getElement();
            JsonNode dstNode = target.getElement();
            if (EQUIVALENCE.equivalent(sentinel, srcNode)) {
                ++nrEquivalences;
            }
            if (EQUIVALENCE.equivalent(sentinel, dstNode)) {
                ++nrEquivalences;
            }
            if (nrEquivalences == 2) {
                return;
            }
            if (nrEquivalences == 0) {
                JsonDiff.generateDiffs(diffs, path.append(source.getIndex()), srcNode, dstNode);
                source.shift();
                target.shift();
                continue;
            }
            if (!EQUIVALENCE.equivalent(sentinel, srcNode)) {
                diffs.add(Diff.arrayRemove(path, source, target));
                source.shift();
                continue;
            }
            diffs.add(Diff.arrayInsert(path, source, target));
            target.shift();
        }
    }

    private static void inLCS(List<Diff> diffs, JsonPointer path, IndexedJsonArray lcs, IndexedJsonArray source, IndexedJsonArray target) {
        while (!lcs.isEmpty()) {
            JsonNode sourceNode = source.getElement();
            JsonNode targetNode = target.getElement();
            JsonNode lcsNode = lcs.getElement();
            boolean sourceMatch = EQUIVALENCE.equivalent(sourceNode, lcsNode);
            boolean targetMatch = EQUIVALENCE.equivalent(targetNode, lcsNode);
            if (!sourceMatch) {
                diffs.add(Diff.arrayRemove(path, source, target));
                source.shift();
                continue;
            }
            if (targetMatch) {
                source.shift();
                lcs.shift();
            } else {
                diffs.add(Diff.arrayInsert(path, source, target));
            }
            target.shift();
        }
    }

    private static void postLCS(List<Diff> diffs, JsonPointer path, IndexedJsonArray source, IndexedJsonArray target) {
        while (!source.isEmpty() && !target.isEmpty()) {
            JsonNode src = source.getElement();
            JsonNode dst = target.getElement();
            JsonDiff.generateDiffs(diffs, path.append(source.getIndex()), src, dst);
            source.shift();
            target.shift();
        }
        JsonDiff.addRemaining(diffs, path, target);
        JsonDiff.removeRemaining(diffs, path, source);
    }

    private static void addRemaining(List<Diff> diffs, JsonPointer path, IndexedJsonArray array) {
        while (!array.isEmpty()) {
            Object node = array.getElement().deepCopy();
            Diff diff = Diff.arrayAdd(path, node);
            diffs.add(diff);
            array.shift();
        }
    }

    private static void removeRemaining(List<Diff> diffs, JsonPointer path, IndexedJsonArray array) {
        int startingIndex = array.getIndex();
        while (!array.isEmpty()) {
            JsonNode node = array.getElement();
            Diff diff = Diff.tailArrayRemove(path, startingIndex, node);
            diffs.add(diff);
            array.shift();
        }
    }
}

