/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main;

import com.github.fge.Thawed;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.report.ListReportProvider;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ReportProvider;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.messages.JsonSchemaConfigurationBundle;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class JsonSchemaFactoryBuilder
implements Thawed<JsonSchemaFactory> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaConfigurationBundle.class);
    ReportProvider reportProvider;
    LoadingConfiguration loadingCfg;
    ValidationConfiguration validationCfg;

    JsonSchemaFactoryBuilder() {
        this.reportProvider = new ListReportProvider(LogLevel.INFO, LogLevel.FATAL);
        this.loadingCfg = LoadingConfiguration.byDefault();
        this.validationCfg = ValidationConfiguration.byDefault();
    }

    JsonSchemaFactoryBuilder(JsonSchemaFactory factory) {
        this.reportProvider = factory.reportProvider;
        this.loadingCfg = factory.loadingCfg;
        this.validationCfg = factory.validationCfg;
    }

    public JsonSchemaFactoryBuilder setReportProvider(ReportProvider reportProvider) {
        BUNDLE.checkNotNull(reportProvider, "nullReportProvider");
        this.reportProvider = reportProvider;
        return this;
    }

    public JsonSchemaFactoryBuilder setLoadingConfiguration(LoadingConfiguration loadingCfg) {
        BUNDLE.checkNotNull(loadingCfg, "nullLoadingCfg");
        this.loadingCfg = loadingCfg;
        return this;
    }

    public JsonSchemaFactoryBuilder setValidationConfiguration(ValidationConfiguration validationCfg) {
        BUNDLE.checkNotNull(validationCfg, "nullValidationCfg");
        this.validationCfg = validationCfg;
        return this;
    }

    @Override
    public JsonSchemaFactory freeze() {
        return new JsonSchemaFactory(this);
    }
}

