/*
 * Decompiled with CFR 0.152.
 */
package sttp.client;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.client.HttpClientError;
import sttp.client.HttpError;
import sttp.client.Response;
import sttp.model.StatusCode;
import sttp.model.StatusCode$;

public final class HttpClientErrorHandler$
implements LazyLogging {
    public static HttpClientErrorHandler$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new HttpClientErrorHandler$();
    }

    private Logger logger$lzycompute() {
        HttpClientErrorHandler$ httpClientErrorHandler$ = this;
        synchronized (httpClientErrorHandler$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Future<BoxedUnit> handleUnitResponse(String action, Option<String> message, Response<Either<String, String>> response) {
        Tuple2 tuple2 = new Tuple2((Object)new StatusCode(response.code()), response.body());
        if (tuple2 != null) {
            int code = ((StatusCode)tuple2._1()).code();
            Either either = (Either)tuple2._2();
            if (either instanceof Right && StatusCode$.MODULE$.isSuccess$extension(code)) {
                return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int code = ((StatusCode)tuple2._1()).code();
        Either either = (Either)tuple2._2();
        if (!(either instanceof Left)) throw new MatchError((Object)tuple2);
        Left left = (Left)either;
        String error = (String)left.value();
        return this.sttp$client$HttpClientErrorHandler$$handleClientError(error, code, action, message);
    }

    public Option<String> handleUnitResponse$default$2() {
        return None$.MODULE$;
    }

    public <T> PartialFunction<Throwable, Future<T>> recoverWithMessage(String action, Option<String> message) {
        return new scala.Serializable(action, message){
            public static final long serialVersionUID = 0L;
            private final String action$1;
            private final Option message$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Future<Nothing$> future;
                A1 A1 = x1;
                if (A1 instanceof HttpError) {
                    HttpError httpError = (HttpError)A1;
                    String body = httpError.body();
                    int status = httpError.statusCode();
                    future = HttpClientErrorHandler$.MODULE$.sttp$client$HttpClientErrorHandler$$handleClientError(body, status, this.action$1, (Option<String>)this.message$1);
                } else {
                    future = function1.apply(x1);
                }
                return (B1)future;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof HttpError;
                return bl;
            }
            {
                this.action$1 = action$1;
                this.message$1 = message$1;
            }
        };
    }

    public <T> Option<String> recoverWithMessage$default$2() {
        return None$.MODULE$;
    }

    public Future<Nothing$> sttp$client$HttpClientErrorHandler$$handleClientError(String body, int status, String action, Option<String> message) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Failed to {}, status code: {}, errors: {}.", action, new StatusCode(status), body);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String errorMessage = (String)message.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Failed to ").append(action).append(". Detailed error information in logs.").toString());
        return Future$.MODULE$.failed((Throwable)new HttpClientError(errorMessage));
    }

    private HttpClientErrorHandler$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

