/*
 * Decompiled with CFR 0.152.
 */
package sttp.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.file.Files;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import sttp.client.BasicRequestBody;
import sttp.client.ByteArrayBody;
import sttp.client.ByteBufferBody;
import sttp.client.FileBody;
import sttp.client.HttpURLConnectionBackend$;
import sttp.client.IgnoreResponse$;
import sttp.client.InputStreamBody;
import sttp.client.MappedResponseAs;
import sttp.client.MultipartBody;
import sttp.client.NoBody$;
import sttp.client.RequestBody;
import sttp.client.RequestT;
import sttp.client.Response;
import sttp.client.ResponseAs;
import sttp.client.ResponseAsByteArray$;
import sttp.client.ResponseAsFile;
import sttp.client.ResponseAsFromMetadata;
import sttp.client.ResponseAsStream;
import sttp.client.ResponseMetadata;
import sttp.client.ResponseMetadata$;
import sttp.client.StreamBody;
import sttp.client.StringBody;
import sttp.client.SttpBackend;
import sttp.client.SttpBackendOptions;
import sttp.client.SttpClientException$;
import sttp.client.internal.FileHelpers$;
import sttp.client.internal.SttpFile;
import sttp.client.internal.package$;
import sttp.client.monad.IdMonad$;
import sttp.client.monad.MonadError;
import sttp.client.testing.SttpBackendStub;
import sttp.model.Header;
import sttp.model.Header$;
import sttp.model.HeaderNames$;
import sttp.model.Method;
import sttp.model.Part;
import sttp.model.StatusCode$;
import sttp.model.Uri;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001\u0002\u0014(\u00011B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011!!\bA!A!\u0002\u0013)\bB\u0002@\u0001\t\u0013\t9\bC\u0004\u0002\u0006\u0002!\t%a\"\t\u000f\u0005-\u0006\u0001\"\u0011\u0002.\"I\u0011Q\u001b\u0001C\u0002\u0013\u0005\u0013q\u001b\u0005\t\u0003K\u0004\u0001\u0015!\u0003\u0002Z\"1q\r\u0001C\u0005\u0003ODq!!?\u0001\t\u0013\tY\u0010C\u0004\u0003\u0016\u0001!IAa\u0006\t\u000f\tM\u0002\u0001\"\u0003\u00036!I!Q\t\u0001C\u0002\u0013%!q\t\u0005\t\u0005+\u0002\u0001\u0015!\u0003\u0003J!9!q\u000b\u0001\u0005\n\te\u0003b\u0002B:\u0001\u0011%!Q\u000f\u0005\b\u0005\u001f\u0003A\u0011\u0002BI\u0011\u001d\u0011I\u000b\u0001C\u0005\u0005WCqAa,\u0001\t\u0013\u0011\t\fC\u0004\u0003<\u0002!IA!0\t\u000f\t5\u0007\u0001\"\u0011\u0003P\u001e)1p\nE\u0001y\u001a)ae\nE\u0001{\")a0\u0007C\u0001\u007f\u00161\u0011\u0011A\r\u0001\u0003\u0007A!\"a\u0007\u001a\u0005\u0004%\taJA\u000f\u0011\u001d\ty\"\u0007Q\u0001\n!Dq!!\t\u001a\t\u0003\t\u0019\u0003C\u0005\u00026e\t\n\u0011\"\u0001\u00028!I\u0011QJ\r\u0012\u0002\u0013\u0005\u0011q\n\u0005\n\u0003'J\u0012\u0013!C\u0001\u0003+B\u0011\"!\u0017\u001a#\u0003%\t!a\u0017\t\u0013\u0005}\u0013$%A\u0005\u0002\u0005\u0005\u0004bBA33\u0011\u0005\u0011q\r\u0005\n\u0003kJ\u0012\u0013!C\u0005\u0003C\u0012\u0001\u0004\u0013;uaV\u0013FjQ8o]\u0016\u001cG/[8o\u0005\u0006\u001c7.\u001a8e\u0015\tA\u0013&\u0001\u0004dY&,g\u000e\u001e\u0006\u0002U\u0005!1\u000f\u001e;q\u0007\u0001\u00192\u0001A\u00174!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fMB)A'N\u001c?\u00036\tq%\u0003\u00027O\tY1\u000b\u001e;q\u0005\u0006\u001c7.\u001a8e!\tA4H\u0004\u00025s%\u0011!hJ\u0001\ba\u0006\u001c7.Y4f\u0013\taTH\u0001\u0005JI\u0016tG/\u001b;z\u0015\tQt\u0005\u0005\u0002/\u007f%\u0011\u0001i\f\u0002\b\u001d>$\b.\u001b8h!\tA$)\u0003\u0002D{\tAaj\u001c;iS:<G+\u0001\u0003paR\u001c\bC\u0001\u001bG\u0013\t9uE\u0001\nTiR\u0004()Y2lK:$w\n\u001d;j_:\u001c\u0018aE2vgR|W.\u001b>f\u0007>tg.Z2uS>t\u0007\u0003\u0002\u0018K\u0019RK!aS\u0018\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA'S\u001b\u0005q%BA(Q\u0003\rqW\r\u001e\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019fJA\tIiR\u0004XK\u0015'D_:tWm\u0019;j_:\u0004\"AL+\n\u0005Y{#\u0001B+oSR\f\u0011b\u0019:fCR,WK\u0015'\u0011\t9R\u0015\f\u001a\t\u00035\u0006t!aW0\u0011\u0005q{S\"A/\u000b\u0005y[\u0013A\u0002\u001fs_>$h(\u0003\u0002a_\u00051\u0001K]3eK\u001aL!AY2\u0003\rM#(/\u001b8h\u0015\t\u0001w\u0006\u0005\u0002NK&\u0011aM\u0014\u0002\u0004+Jc\u0015AD8qK:\u001cuN\u001c8fGRLwN\u001c\t\u0006]%$7.]\u0005\u0003U>\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u00079bg.\u0003\u0002n_\t1q\n\u001d;j_:\u0004\"!T8\n\u0005At%!\u0002)s_bL\bCA's\u0013\t\u0019hJA\u0007V%2\u001buN\u001c8fGRLwN\\\u0001\u0016GV\u001cHo\\7F]\u000e|G-\u001b8h\u0011\u0006tG\r\\3s!\t18D\u0004\u0002x19\u0011\u0001P\u001f\b\u00039fL\u0011AK\u0005\u0003Q%\n\u0001\u0004\u0013;uaV\u0013FjQ8o]\u0016\u001cG/[8o\u0005\u0006\u001c7.\u001a8e!\t!\u0014d\u0005\u0002\u001a[\u00051A(\u001b8jiz\"\u0012\u0001 \u0002\u0010\u000b:\u001cw\u000eZ5oO\"\u000bg\u000e\u001a7feB9a&!\u0002\u0002\n\u0005=\u0011bAA\u0004_\ty\u0001+\u0019:uS\u0006dg)\u001e8di&|g\u000e\u0005\u0004/\u0003\u0017\ty!W\u0005\u0004\u0003\u001by#A\u0002+va2,'\u0007\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002U\u0001\u0003S>LA!!\u0007\u0002\u0014\tY\u0011J\u001c9viN#(/Z1n\u0003U!WMZ1vYR|\u0005/\u001a8D_:tWm\u0019;j_:,\u0012\u0001[\u0001\u0017I\u00164\u0017-\u001e7u\u001fB,gnQ8o]\u0016\u001cG/[8oA\u0005)\u0011\r\u001d9msRY1'!\n\u0002*\u0005-\u0012QFA\u0018\u0011!\t9C\bI\u0001\u0002\u0004)\u0015aB8qi&|gn\u001d\u0005\b\u0011z\u0001\n\u00111\u0001J\u0011\u001d9f\u0004%AA\u0002aCqa\u001a\u0010\u0011\u0002\u0003\u0007\u0001\u000e\u0003\u0005u=A\u0005\t\u0019AA\u0019!\r\t\u0019dG\u0007\u00023\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002:)\u001aQ)a\u000f,\u0005\u0005u\u0002\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u00120\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\n\tEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq\"\u00199qYf$C-\u001a4bk2$HEM\u000b\u0003\u0003#R3!SA\u001e\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001aTCAA,U\rA\u00161H\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\f\u0016\u0004Q\u0006m\u0012aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005\r$\u0006BA\u0019\u0003w\tAa\u001d;vEV\u0011\u0011\u0011\u000e\t\b\u0003W\n\th\u000e B\u001b\t\tiGC\u0002\u0002p\u001d\nq\u0001^3ti&tw-\u0003\u0003\u0002t\u00055$aD*uiB\u0014\u0015mY6f]\u0012\u001cF/\u001e2\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136)1\tI(a\u001f\u0002~\u0005}\u0014\u0011QAB!\t!\u0004\u0001C\u0003E\r\u0001\u0007Q\tC\u0003I\r\u0001\u0007\u0011\nC\u0003X\r\u0001\u0007\u0001\fC\u0003h\r\u0001\u0007\u0001\u000eC\u0004u\rA\u0005\t\u0019A;\u0002\tM,g\u000eZ\u000b\u0005\u0003\u0013\u000b)\n\u0006\u0003\u0002\f\u0006\u0005\u0006#\u0002\u001b\u0002\u000e\u0006E\u0015bAAHO\tA!+Z:q_:\u001cX\r\u0005\u0003\u0002\u0014\u0006UE\u0002\u0001\u0003\b\u0003/;!\u0019AAM\u0005\u0005!\u0016c\u0001 \u0002\u001cB\u0019a&!(\n\u0007\u0005}uFA\u0002B]fDq!a)\b\u0001\u0004\t)+A\u0001s!\u0019A\u0014qUAI}%\u0019\u0011\u0011V\u001f\u0003\u000fI+\u0017/^3ti\u0006iq\u000e]3o/\u0016\u00147o\\2lKR,b!a,\u0002N\u0006\u0005GCBAY\u0003\u000b\fy\r\u0005\u00039\u0005\u0006M\u0006CBA[\u0003w\u000by,\u0004\u0002\u00028*\u0019\u0011\u0011X\u0014\u0002\u0005]\u001c\u0018\u0002BA_\u0003o\u0013\u0011cV3c'>\u001c7.\u001a;SKN\u0004xN\\:f!\u0011\t\u0019*!1\u0005\u000f\u0005\r\u0007B1\u0001\u0002\u001a\n\u0011qK\u0015\u0005\b\u0003\u000fD\u0001\u0019AAe\u0003\u001d\u0011X-];fgR\u0004b\u0001OAT\u0003\u0017t\u0004\u0003BAJ\u0003\u001b$q!a&\t\u0005\u0004\tI\nC\u0004\u0002R\"\u0001\r!a5\u0002\u000f!\fg\u000e\u001a7feB!\u0001HQA`\u00035\u0011Xm\u001d9p]N,Wj\u001c8bIV\u0011\u0011\u0011\u001c\t\u0006\u00037\f\toN\u0007\u0003\u0003;T1!a8(\u0003\u0015iwN\\1e\u0013\u0011\t\u0019/!8\u0003\u00155{g.\u00193FeJ|'/\u0001\bsKN\u0004xN\\:f\u001b>t\u0017\r\u001a\u0011\u0015\u00071\u000bI\u000fC\u0004\u0002l.\u0001\r!!<\u0002\u0007U\u0014\u0018\u000e\u0005\u0003\u0002p\u0006UXBAAy\u0015\r\t\u00190K\u0001\u0006[>$W\r\\\u0005\u0005\u0003o\f\tPA\u0002Ve&\f\u0011b\u001e:ji\u0016\u0014u\u000eZ=\u0015\r\u0005u(Q\u0001B\t!\u0011qC.a@\u0011\t\u0005E!\u0011A\u0005\u0005\u0005\u0007\t\u0019B\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002$2\u0001\rAa\u00021\t\t%!Q\u0002\t\u0007q\u0005\u001d&1\u0002 \u0011\t\u0005M%Q\u0002\u0003\r\u0005\u001f\u0011)!!A\u0001\u0002\u000b\u0005\u0011\u0011\u0014\u0002\u0004?\u0012\n\u0004B\u0002B\n\u0019\u0001\u0007A*A\u0001d\u0003\u001d!\u0018.\\3pkR$BA!\u0007\u0003 A\u0019aFa\u0007\n\u0007\tuqFA\u0002J]RDqA!\t\u000e\u0001\u0004\u0011\u0019#A\u0001u!\u0011\u0011)Ca\f\u000e\u0005\t\u001d\"\u0002\u0002B\u0015\u0005W\t\u0001\u0002Z;sCRLwN\u001c\u0006\u0004\u0005[y\u0013AC2p]\u000e,(O]3oi&!!\u0011\u0007B\u0014\u0005!!UO]1uS>t\u0017AD<sSR,')Y:jG\n{G-\u001f\u000b\u0006)\n]\"\u0011\t\u0005\b\u0005sq\u0001\u0019\u0001B\u001e\u0003\u0011\u0011w\u000eZ=\u0011\u0007Q\u0012i$C\u0002\u0003@\u001d\u0012\u0001CQ1tS\u000e\u0014V-];fgR\u0014u\u000eZ=\t\u000f\t\rc\u00021\u0001\u0002\u0000\u0006\u0011qn]\u0001\u000e\u0005>,h\u000eZ1ss\u000eC\u0017M]:\u0016\u0005\t%\u0003#\u0002\u0018\u0003L\t=\u0013b\u0001B'_\t)\u0011I\u001d:bsB\u0019aF!\u0015\n\u0007\tMsF\u0001\u0003DQ\u0006\u0014\u0018A\u0004\"pk:$\u0017M]=DQ\u0006\u00148\u000fI\u0001\u0011g\u0016$X*\u001e7uSB\f'\u000f\u001e\"pIf$\u0002\"!@\u0003\\\t\u001d$\u0011\u000f\u0005\b\u0003G\u000b\u0002\u0019\u0001B/a\u0011\u0011yFa\u0019\u0011\ra\n9K!\u0019?!\u0011\t\u0019Ja\u0019\u0005\u0019\t\u0015$1LA\u0001\u0002\u0003\u0015\t!!'\u0003\u0007}##\u0007C\u0004\u0003jE\u0001\rAa\u001b\u0002\u00055\u0004\bc\u0001\u001b\u0003n%\u0019!qN\u0014\u0003\u001b5+H\u000e^5qCJ$(i\u001c3z\u0011\u0019\u0011\u0019\"\u0005a\u0001\u0019\u0006a!/Z1e%\u0016\u001c\bo\u001c8tKV!!q\u000fB?)!\u0011IHa \u0003\u0002\n\u0015\u0005#\u0002\u001b\u0002\u000e\nm\u0004\u0003BAJ\u0005{\"q!a&\u0013\u0005\u0004\tI\n\u0003\u0004\u0003\u0014I\u0001\r\u0001\u0014\u0005\b\u0005\u0007\u0013\u0002\u0019AA\b\u0003\tI7\u000fC\u0004\u0003\bJ\u0001\rA!#\u0002\u0015I,7\u000f]8og\u0016\f5\u000f\u0005\u00045\u0005\u0017\u0013YHP\u0005\u0004\u0005\u001b;#A\u0003*fgB|gn]3Bg\u0006\u0001\"/Z1e%\u0016\u001c\bo\u001c8tK\n{G-_\u000b\u0005\u0005'\u00139\n\u0006\u0005\u0003\u0016\ne%1\u0014BP!\u0011\t\u0019Ja&\u0005\u000f\u0005]5C1\u0001\u0002\u001a\"9!1Q\nA\u0002\u0005=\u0001b\u0002BD'\u0001\u0007!Q\u0014\t\u0007i\t-%Q\u0013 \t\u000f\t\u00056\u00031\u0001\u0003$\u0006!Q.\u001a;b!\r!$QU\u0005\u0004\u0005O;#\u0001\u0005*fgB|gn]3NKR\fG-\u0019;b\u0003=A\u0017M\u001c3mK:+H\u000e\\%oaV$H\u0003BA\b\u0005[CqAa!\u0015\u0001\u0004\ty!A\u0005xe\u0006\u0004\u0018J\u001c9viR1\u0011q\u0002BZ\u0005sCqA!.\u0016\u0001\u0004\u00119,A\bd_:$XM\u001c;F]\u000e|G-\u001b8h!\rqC.\u0017\u0005\b\u0005\u0007+\u0002\u0019AA\b\u0003A\tGM[;ti\u0016C8-\u001a9uS>t7/\u0006\u0003\u0003@\n\rG\u0003\u0002Ba\u0005\u000b\u0004B!a%\u0003D\u00129\u0011q\u0013\fC\u0002\u0005e\u0005\u0002\u0003B\u0011-\u0011\u0005\rAa2\u0011\u000b9\u0012IM!1\n\u0007\t-wF\u0001\u0005=Eft\u0017-\\3?\u0003\u0015\u0019Gn\\:f)\u0005!\u0006")
public class HttpURLConnectionBackend
implements SttpBackend<Object, Nothing$, Nothing$> {
    private final SttpBackendOptions opts;
    private final Function1<HttpURLConnection, BoxedUnit> customizeConnection;
    private final Function1<String, URL> createURL;
    private final Function2<URL, Option<Proxy>, URLConnection> openConnection;
    private final PartialFunction<Tuple2<InputStream, String>, InputStream> customEncodingHandler;
    private final MonadError<Object> responseMonad;
    private final char[] BoundaryChars;
    private volatile byte bitmap$init$0;

    public static SttpBackendStub<Object, Nothing$, Nothing$> stub() {
        return HttpURLConnectionBackend$.MODULE$.stub();
    }

    public static PartialFunction<Tuple2<InputStream, String>, InputStream> apply$default$5() {
        return HttpURLConnectionBackend$.MODULE$.apply$default$5();
    }

    public static Function2<URL, Option<Proxy>, URLConnection> apply$default$4() {
        return HttpURLConnectionBackend$.MODULE$.apply$default$4();
    }

    public static Function1<String, URL> apply$default$3() {
        return HttpURLConnectionBackend$.MODULE$.apply$default$3();
    }

    public static Function1<HttpURLConnection, BoxedUnit> apply$default$2() {
        return HttpURLConnectionBackend$.MODULE$.apply$default$2();
    }

    public static SttpBackendOptions apply$default$1() {
        return HttpURLConnectionBackend$.MODULE$.apply$default$1();
    }

    public static SttpBackend<Object, Nothing$, Nothing$> apply(SttpBackendOptions sttpBackendOptions, Function1<HttpURLConnection, BoxedUnit> function1, Function1<String, URL> function12, Function2<URL, Option<Proxy>, URLConnection> function2, PartialFunction<Tuple2<InputStream, String>, InputStream> partialFunction) {
        return HttpURLConnectionBackend$.MODULE$.apply(sttpBackendOptions, function1, function12, function2, partialFunction);
    }

    @Override
    public <T> Response<T> send(RequestT<Object, T, Nothing$> r) {
        return (Response)this.adjustExceptions((Function0 & Serializable & scala.Serializable)() -> {
            Response response;
            HttpURLConnection c = this.openConnection((Uri)r.uri());
            c.setRequestMethod(((Method)r.method()).method());
            r.headers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                HttpURLConnectionBackend.$anonfun$send$2(c, x0$1);
                return BoxedUnit.UNIT;
            });
            c.setDoInput(true);
            c.setReadTimeout(this.timeout(r.options().readTimeout()));
            c.setConnectTimeout(this.timeout((Duration)$this.opts.connectionTimeout()));
            c.setInstanceFollowRedirects(false);
            $this.customizeConnection.apply((Object)c);
            RequestBody requestBody = r.body();
            NoBody$ noBody$ = NoBody$.MODULE$;
            if (requestBody == null ? noBody$ != null : !requestBody.equals(noBody$)) {
                c.setDoOutput(true);
                this.writeBody(r, c).foreach((Function1 & Serializable & scala.Serializable)os -> {
                    HttpURLConnectionBackend.$anonfun$send$3(os);
                    return BoxedUnit.UNIT;
                });
            }
            try {
                InputStream is = c.getInputStream();
                response = this.readResponse(c, is, r.response());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof CharacterCodingException) {
                    CharacterCodingException characterCodingException = (CharacterCodingException)throwable2;
                    throw characterCodingException;
                }
                if (throwable2 instanceof UnsupportedEncodingException) {
                    UnsupportedEncodingException unsupportedEncodingException = (UnsupportedEncodingException)throwable2;
                    throw unsupportedEncodingException;
                }
                if (throwable2 instanceof SocketException) {
                    SocketException socketException = (SocketException)throwable2;
                    throw socketException;
                }
                if (!(throwable2 instanceof IOException) || c.getResponseCode() == -1) {
                    throw throwable;
                }
                Response response2 = this.readResponse(c, c.getErrorStream(), r.response());
                response = response2;
            }
            return response;
        });
    }

    @Override
    public <T, WR> Nothing$ openWebsocket(RequestT<Object, T, Nothing$> request, Nothing$ handler) {
        return handler;
    }

    @Override
    public MonadError<Object> responseMonad() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/jenkins/agent/workspace/Release/sttp-release/core/src/main/scalajvm/sttp/client/HttpURLConnectionBackend.scala: 72");
        }
        return this.responseMonad;
    }

    private HttpURLConnection openConnection(Uri uri) {
        URLConnection uRLConnection;
        Some some;
        SttpBackendOptions.Proxy p;
        URL url = (URL)this.createURL.apply((Object)uri.toString());
        Option<SttpBackendOptions.Proxy> option = this.opts.proxy();
        if (option instanceof Some && !(p = (SttpBackendOptions.Proxy)(some = (Some)option).value()).ignoreProxy(uri.host())) {
            p.auth().foreach((Function1 & Serializable & scala.Serializable)proxyAuth -> {
                HttpURLConnectionBackend.$anonfun$openConnection$1(proxyAuth);
                return BoxedUnit.UNIT;
            });
            uRLConnection = (URLConnection)this.openConnection.apply((Object)url, (Object)new Some((Object)p.asJavaProxy()));
        } else {
            uRLConnection = (URLConnection)this.openConnection.apply((Object)url, (Object)None$.MODULE$);
        }
        URLConnection conn = uRLConnection;
        return (HttpURLConnection)conn;
    }

    private Option<OutputStream> writeBody(RequestT<Object, ?, Nothing$> r, HttpURLConnection c) {
        Option<OutputStream> option;
        RequestBody<Nothing$> requestBody = r.body();
        if (NoBody$.MODULE$.equals(requestBody)) {
            option = None$.MODULE$;
        } else if (requestBody instanceof BasicRequestBody) {
            BasicRequestBody basicRequestBody = (BasicRequestBody)requestBody;
            OutputStream os = c.getOutputStream();
            this.writeBasicBody(basicRequestBody, os);
            option = new Some((Object)os);
        } else if (requestBody instanceof StreamBody) {
            option = None$.MODULE$;
        } else if (requestBody instanceof MultipartBody) {
            MultipartBody multipartBody = (MultipartBody)requestBody;
            option = this.setMultipartBody(r, multipartBody, c);
        } else {
            throw new MatchError(requestBody);
        }
        return option;
    }

    private int timeout(Duration t) {
        return t.isFinite() ? (int)t.toMillis() : 0;
    }

    private void writeBasicBody(BasicRequestBody body, OutputStream os) {
        BasicRequestBody basicRequestBody = body;
        if (basicRequestBody instanceof StringBody) {
            StringBody stringBody = (StringBody)basicRequestBody;
            String b = stringBody.s();
            String encoding = stringBody.encoding();
            OutputStreamWriter writer = new OutputStreamWriter(os, encoding);
            writer.write(b);
            writer.flush();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (basicRequestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)basicRequestBody;
            byte[] b = byteArrayBody.b();
            os.write(b);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (basicRequestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = (ByteBufferBody)basicRequestBody;
            ByteBuffer b = byteBufferBody.b();
            WritableByteChannel channel = Channels.newChannel(os);
            channel.write(b);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (basicRequestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)basicRequestBody;
            InputStream b = inputStreamBody.b();
            package$.MODULE$.transfer(b, os);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (basicRequestBody instanceof FileBody) {
            FileBody fileBody = (FileBody)basicRequestBody;
            SttpFile f = fileBody.f();
            Files.copy(f.toPath(), os);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)basicRequestBody);
        }
    }

    private char[] BoundaryChars() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/jenkins/agent/workspace/Release/sttp-release/core/src/main/scalajvm/sttp/client/HttpURLConnectionBackend.scala: 141");
        }
        return this.BoundaryChars;
    }

    private Option<OutputStream> setMultipartBody(RequestT<Object, ?, Nothing$> r, MultipartBody mp, HttpURLConnection c) {
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        String boundary = ((TraversableOnce)List$.MODULE$.fill(32, (Function0)(JFunction0.mcC.sp & Serializable & scala.Serializable)() -> this.BoundaryChars()[tlr.nextInt(this.BoundaryChars().length)])).mkString();
        Seq partsWithHeaders = (Seq)mp.parts().map((Function1 & Serializable & scala.Serializable)p -> {
            String contentDisposition = new StringBuilder(2).append(HeaderNames$.MODULE$.ContentDisposition()).append(": ").append(p.contentDispositionHeaderValue()).toString();
            Seq otherHeaders = (Seq)p.headers().map((Function1 & Serializable & scala.Serializable)h -> new StringBuilder(2).append(h.name()).append(": ").append(h.value()).toString(), Seq$.MODULE$.canBuildFrom());
            List allHeaders = (List)new .colon.colon((Object)contentDisposition, (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)otherHeaders, List$.MODULE$.canBuildFrom());
            return new Tuple2((Object)allHeaders.mkString(package$.MODULE$.CrLf()), p);
        }, Seq$.MODULE$.canBuildFrom());
        String dashes = "--";
        long dashesLen = dashes.length();
        long crLfLen = package$.MODULE$.CrLf().length();
        long boundaryLen = boundary.length();
        long finalBoundaryLen = dashesLen + boundaryLen + dashesLen + crLfLen;
        Option contentLength = (Option)((TraversableOnce)partsWithHeaders.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            None$ none$;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String headers = (String)tuple2._1();
            Part p = (Part)tuple2._2();
            BasicRequestBody basicRequestBody = (BasicRequestBody)p.body();
            if (basicRequestBody instanceof StringBody) {
                StringBody stringBody = (StringBody)basicRequestBody;
                String b = stringBody.s();
                String encoding = stringBody.encoding();
                none$ = new Some((Object)BoxesRunTime.boxToLong((long)b.getBytes(encoding).length));
            } else if (basicRequestBody instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)basicRequestBody;
                byte[] b = byteArrayBody.b();
                none$ = new Some((Object)BoxesRunTime.boxToLong((long)b.length));
            } else if (basicRequestBody instanceof ByteBufferBody) {
                none$ = None$.MODULE$;
            } else if (basicRequestBody instanceof InputStreamBody) {
                none$ = None$.MODULE$;
            } else {
                if (!(basicRequestBody instanceof FileBody)) throw new MatchError((Object)basicRequestBody);
                FileBody fileBody = (FileBody)basicRequestBody;
                SttpFile b = fileBody.f();
                none$ = new Some((Object)BoxesRunTime.boxToLong((long)b.toFile().length()));
            }
            None$ bodyLen = none$;
            int headersLen = headers.getBytes(package$.MODULE$.Iso88591()).length;
            return bodyLen.map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)bl -> dashesLen + boundaryLen + crLfLen + (long)headersLen + crLfLen + crLfLen + bl + crLfLen);
        }, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)finalBoundaryLen)), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 == null) return None$.MODULE$;
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (!(option instanceof Some)) return None$.MODULE$;
            Some some = (Some)option;
            long acc = BoxesRunTime.unboxToLong((Object)some.value());
            if (!(option2 instanceof Some)) return None$.MODULE$;
            Some some2 = (Some)option2;
            long l = BoxesRunTime.unboxToLong((Object)some2.value());
            return new Some((Object)BoxesRunTime.boxToLong((long)(acc + l)));
        });
        String baseContentType = (String)r.headers().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.is(HeaderNames$.MODULE$.ContentType()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "multipart/form-data");
        c.setRequestProperty(HeaderNames$.MODULE$.ContentType(), new StringBuilder(11).append(baseContentType).append("; boundary=").append(boundary).toString());
        contentLength.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)cl -> {
            c.setFixedLengthStreamingMode(cl);
            c.setRequestProperty(HeaderNames$.MODULE$.ContentLength(), ((Object)BoxesRunTime.boxToLong((long)cl)).toString());
        });
        LongRef total = LongRef.create((long)0L);
        OutputStream os = c.getOutputStream();
        partsWithHeaders.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            HttpURLConnectionBackend.$anonfun$setMultipartBody$11(this, dashes, boundary, os, total, x0$3);
            return BoxedUnit.UNIT;
        });
        HttpURLConnectionBackend.writeMeta$1(dashes, os, total);
        HttpURLConnectionBackend.writeMeta$1(boundary, os, total);
        HttpURLConnectionBackend.writeMeta$1(dashes, os, total);
        HttpURLConnectionBackend.writeMeta$1(package$.MODULE$.CrLf(), os, total);
        return new Some((Object)os);
    }

    private <T> Response<T> readResponse(HttpURLConnection c, InputStream is, ResponseAs<T, Nothing$> responseAs) {
        Vector headers = (Vector)((TraversableLike)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(c.getHeaderFields()).asScala()).toVector().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HttpURLConnectionBackend.$anonfun$readResponse$1(x$3)))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            java.util.List vv = (java.util.List)tuple2._2();
            Buffer buffer = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(vv).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> Header$.MODULE$.apply(k, (String)x$4), Buffer$.MODULE$.canBuildFrom());
            return buffer;
        }, Vector$.MODULE$.canBuildFrom());
        Option contentEncoding = Option$.MODULE$.apply((Object)c.getHeaderField(HeaderNames$.MODULE$.ContentEncoding()));
        int code = StatusCode$.MODULE$.apply(c.getResponseCode());
        String string = c.getRequestMethod();
        String string2 = "HEAD";
        InputStream wrappedIs = (string == null ? string2 != null : !string.equals(string2)) ? this.wrapInput((Option<String>)contentEncoding, this.handleNullInput(is)) : this.handleNullInput(is);
        ResponseMetadata responseMetadata = ResponseMetadata$.MODULE$.apply((Seq<Header>)headers, code, c.getResponseMessage());
        T body = this.readResponseBody(wrappedIs, responseAs, responseMetadata);
        return new Response<T>(body, code, c.getResponseMessage(), (Seq<Header>)headers, (List<Response<BoxedUnit>>)Nil$.MODULE$);
    }

    private <T> T readResponseBody(InputStream is, ResponseAs<T, Nothing$> responseAs, ResponseMetadata meta) {
        Object object;
        block9: {
            ResponseAs responseAs2;
            while (true) {
                if ((responseAs2 = responseAs) instanceof MappedResponseAs) {
                    MappedResponseAs mappedResponseAs = (MappedResponseAs)responseAs2;
                    ResponseAs raw = mappedResponseAs.raw();
                    Function2 g = mappedResponseAs.g();
                    object = g.apply(this.readResponseBody(is, raw, meta), (Object)meta);
                    break block9;
                }
                if (!(responseAs2 instanceof ResponseAsFromMetadata)) break;
                ResponseAsFromMetadata responseAsFromMetadata = (ResponseAsFromMetadata)responseAs2;
                Function1 f = responseAsFromMetadata.f();
                ResponseAs responseAs3 = (ResponseAs)f.apply((Object)meta);
                responseAs = responseAs3;
            }
            if (IgnoreResponse$.MODULE$.equals(responseAs2)) {
                this.consume$1(is);
                object = BoxedUnit.UNIT;
            } else if (ResponseAsByteArray$.MODULE$.equals(responseAs2)) {
                object = package$.MODULE$.toByteArray(is);
            } else {
                if (responseAs2 instanceof ResponseAsStream) {
                    throw new IllegalStateException();
                }
                if (responseAs2 instanceof ResponseAsFile) {
                    ResponseAsFile responseAsFile = (ResponseAsFile)responseAs2;
                    SttpFile output = responseAsFile.output();
                    FileHelpers$.MODULE$.saveFile(output.toFile(), is);
                    object = output;
                } else {
                    throw new MatchError((Object)responseAs2);
                }
            }
        }
        return (T)object;
    }

    private InputStream handleNullInput(InputStream is) {
        return is == null ? new ByteArrayInputStream((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())) : is;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream wrapInput(Option<String> contentEncoding, InputStream is) {
        String ce;
        String string;
        boolean bl = false;
        Some some = null;
        Option option = contentEncoding.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toLowerCase());
        if (None$.MODULE$.equals(option)) {
            return is;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string2 = (String)some.value();
            if ("gzip".equals(string2)) {
                return new GZIPInputStream(is);
            }
        }
        if (bl && "deflate".equals(string = (String)some.value())) {
            return new InflaterInputStream(is);
        }
        if (bl && this.customEncodingHandler.isDefinedAt((Object)new Tuple2((Object)is, (Object)(ce = (String)some.value())))) {
            return (InputStream)this.customEncodingHandler.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)is), (Object)ce));
        }
        if (!bl) throw new MatchError((Object)option);
        String ce2 = (String)some.value();
        throw new UnsupportedEncodingException(new StringBuilder(22).append("Unsupported encoding: ").append(ce2).toString());
    }

    private <T> T adjustExceptions(Function0<T> t) {
        return SttpClientException$.MODULE$.adjustSynchronousExceptions(t, (Function1<Exception, Option<Exception>>)(Function1 & Serializable & scala.Serializable)e -> SttpClientException$.MODULE$.defaultExceptionToSttpClientException((Exception)e));
    }

    @Override
    public void close() {
    }

    public static final /* synthetic */ void $anonfun$send$2(HttpURLConnection c$1, Header x0$1) {
        Header header = x0$1;
        Option<Tuple2<String, String>> option = Header$.MODULE$.unapply(header);
        if (option.isEmpty()) {
            throw new MatchError((Object)header);
        }
        String k = (String)((Tuple2)option.get())._1();
        String v = (String)((Tuple2)option.get())._2();
        c$1.setRequestProperty(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$send$3(OutputStream os) {
        os.flush();
        os.close();
    }

    public static final /* synthetic */ void $anonfun$openConnection$1(SttpBackendOptions.ProxyAuth proxyAuth) {
        Authenticator.setDefault(new Authenticator(null, proxyAuth){
            private final SttpBackendOptions.ProxyAuth proxyAuth$1;

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(this.proxyAuth$1.username(), this.proxyAuth$1.password().toCharArray());
            }
            {
                this.proxyAuth$1 = proxyAuth$1;
            }
        });
    }

    private static final void writeMeta$1(String s, OutputStream os$1, LongRef total$1) {
        os$1.write(s.getBytes(package$.MODULE$.Iso88591()));
        total$1.elem += (long)s.getBytes(package$.MODULE$.Iso88591()).length;
    }

    public static final /* synthetic */ void $anonfun$setMultipartBody$11(HttpURLConnectionBackend $this, String dashes$1, String boundary$1, OutputStream os$1, LongRef total$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String headers = (String)tuple2._1();
        Part p = (Part)tuple2._2();
        HttpURLConnectionBackend.writeMeta$1(dashes$1, os$1, total$1);
        HttpURLConnectionBackend.writeMeta$1(boundary$1, os$1, total$1);
        HttpURLConnectionBackend.writeMeta$1(package$.MODULE$.CrLf(), os$1, total$1);
        HttpURLConnectionBackend.writeMeta$1(headers, os$1, total$1);
        HttpURLConnectionBackend.writeMeta$1(package$.MODULE$.CrLf(), os$1, total$1);
        HttpURLConnectionBackend.writeMeta$1(package$.MODULE$.CrLf(), os$1, total$1);
        $this.writeBasicBody((BasicRequestBody)p.body(), os$1);
        HttpURLConnectionBackend.writeMeta$1(package$.MODULE$.CrLf(), os$1, total$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$readResponse$1(Tuple2 x$3) {
        return x$3._1() != null;
    }

    private final void consume$1(InputStream is$1) {
        while (is$1.read() != -1) {
        }
    }

    public HttpURLConnectionBackend(SttpBackendOptions opts, Function1<HttpURLConnection, BoxedUnit> customizeConnection, Function1<String, URL> createURL, Function2<URL, Option<Proxy>, URLConnection> openConnection, PartialFunction<Tuple2<InputStream, String>, InputStream> customEncodingHandler) {
        this.opts = opts;
        this.customizeConnection = customizeConnection;
        this.createURL = createURL;
        this.openConnection = openConnection;
        this.customEncodingHandler = customEncodingHandler;
        this.responseMonad = IdMonad$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.BoundaryChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

