/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.openapi;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.ceedubs.ficus.Ficus$;
import org.apache.commons.io.IOUtils;
import pl.touk.nussknacker.engine.api.CirceUtil$;
import pl.touk.nussknacker.engine.api.EagerService;
import pl.touk.nussknacker.engine.api.component.Component;
import pl.touk.nussknacker.engine.api.component.ComponentDefinition;
import pl.touk.nussknacker.engine.api.component.ComponentDefinition$;
import pl.touk.nussknacker.engine.api.component.ComponentProvider;
import pl.touk.nussknacker.engine.api.component.NussknackerVersion;
import pl.touk.nussknacker.engine.api.process.ProcessObjectDependencies;
import pl.touk.nussknacker.engine.util.config.ConfigEnrichments$;
import pl.touk.nussknacker.openapi.OpenAPIServicesConfig;
import pl.touk.nussknacker.openapi.OpenAPIsConfig$;
import pl.touk.nussknacker.openapi.enrichers.SwaggerEnricherCreator;
import pl.touk.nussknacker.openapi.enrichers.SwaggerEnricherCreator$;
import pl.touk.nussknacker.openapi.enrichers.SwaggerEnrichers;
import pl.touk.nussknacker.openapi.http.backend.DefaultHttpClientConfig$;
import pl.touk.nussknacker.openapi.http.backend.HttpClientConfig;
import pl.touk.nussknacker.openapi.http.backend.HttpClientConfig$;
import pl.touk.nussknacker.openapi.package;
import pl.touk.nussknacker.openapi.package$SwaggerService$;
import pl.touk.nussknacker.openapi.parser.SwaggerParser$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001\u0002\u0005\n\u0001IAQ!\f\u0001\u0005\u00029BQ!\r\u0001\u0005BIBQA\u0010\u0001\u0005B}BQa\u0012\u0001\u0005\n!CQA\u0017\u0001\u0005BmCQ\u0001\u001d\u0001\u0005\u0012EDQ!\u001f\u0001\u0005Bi\u0014\u0001d\u00149f]\u0006\u0003\u0016jQ8na>tWM\u001c;Qe>4\u0018\u000eZ3s\u0015\tQ1\"A\u0004pa\u0016t\u0017\r]5\u000b\u00051i\u0011a\u00038vgN\\g.Y2lKJT!AD\b\u0002\tQ|Wo\u001b\u0006\u0002!\u0005\u0011\u0001\u000f\\\u0002\u0001'\u0011\u00011#G\u0012\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQ\u0012%D\u0001\u001c\u0015\taR$A\u0005d_6\u0004xN\\3oi*\u0011adH\u0001\u0004CBL'B\u0001\u0011\f\u0003\u0019)gnZ5oK&\u0011!e\u0007\u0002\u0012\u0007>l\u0007o\u001c8f]R\u0004&o\u001c<jI\u0016\u0014\bC\u0001\u0013,\u001b\u0005)#B\u0001\u0014(\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tA\u0013&\u0001\u0005usB,7/\u00194f\u0015\u0005Q\u0013aA2p[&\u0011A&\n\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002_A\u0011\u0001\u0007A\u0007\u0002\u0013\u0005a\u0001O]8wS\u0012,'OT1nKV\t1\u0007\u0005\u00025w9\u0011Q'\u000f\t\u0003mUi\u0011a\u000e\u0006\u0003qE\ta\u0001\u0010:p_Rt\u0014B\u0001\u001e\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i*\u0012!\u0007:fg>dg/Z\"p]\u001aLwMR8s\u000bb,7-\u001e;j_:$\"\u0001\u0011$\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r;\u0013AB2p]\u001aLw-\u0003\u0002F\u0005\n11i\u001c8gS\u001eDQaQ\u0002A\u0002\u0001\u000bq\u0003Z5tG>4XM](qK:\f\u0005+S*feZL7-Z:\u0015\u0007%#V\u000bE\u0002K\u001fFk\u0011a\u0013\u0006\u0003\u00196\u000b\u0011\"[7nkR\f'\r\\3\u000b\u00059+\u0012AC2pY2,7\r^5p]&\u0011\u0001k\u0013\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002B%&\u00111K\u0011\u0002\r\u0007>tg-[4PE*,7\r\u001e\u0005\u0006\u0007\u0012\u0001\r\u0001\u0011\u0005\u0006-\u0012\u0001\raV\u0001\u000f_B,g.\u0011)Jg\u000e{gNZ5h!\t\u0001\u0004,\u0003\u0002Z\u0013\t)r\n]3o\u0003BK5+\u001a:wS\u000e,7oQ8oM&<\u0017AB2sK\u0006$X\rF\u0002]O\"\u00042!\u00182e\u001d\tq\u0006M\u0004\u00027?&\ta#\u0003\u0002b+\u00059\u0001/Y2lC\u001e,\u0017B\u0001)d\u0015\t\tW\u0003\u0005\u0002\u001bK&\u0011am\u0007\u0002\u0014\u0007>l\u0007o\u001c8f]R$UMZ5oSRLwN\u001c\u0005\u0006\u0007\u0016\u0001\r\u0001\u0011\u0005\u0006S\u0016\u0001\rA[\u0001\rI\u0016\u0004XM\u001c3f]\u000eLWm\u001d\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[v\tq\u0001\u001d:pG\u0016\u001c8/\u0003\u0002pY\nI\u0002K]8dKN\u001cxJ\u00196fGR$U\r]3oI\u0016t7-[3t\u0003i\u0001(/\u001a9be\u0016\u0014\u0015m]3F]JL7\r[3s\u0007J,\u0017\r^8s)\t\u0011\b\u0010\u0005\u0002tm6\tAO\u0003\u0002v\u0013\u0005IQM\u001c:jG\",'o]\u0005\u0003oR\u0014acU<bO\u001e,'/\u00128sS\u000eDWM]\"sK\u0006$xN\u001d\u0005\u0006\u0007\u001a\u0001\r\u0001Q\u0001\rSN\u001cu.\u001c9bi&\u0014G.\u001a\u000b\u0003wz\u0004\"\u0001\u0006?\n\u0005u,\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u007f\u001e\u0001\r!!\u0001\u0002\u000fY,'o]5p]B\u0019!$a\u0001\n\u0007\u0005\u00151D\u0001\nOkN\u001c8N\\1dW\u0016\u0014h+\u001a:tS>t\u0007")
public class OpenAPIComponentProvider
implements ComponentProvider,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public boolean isAutoLoaded() {
        return ComponentProvider.isAutoLoaded$((ComponentProvider)this);
    }

    private Logger logger$lzycompute() {
        OpenAPIComponentProvider openAPIComponentProvider = this;
        synchronized (openAPIComponentProvider) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String providerName() {
        return "openAPI";
    }

    public Config resolveConfigForExecution(Config config) {
        List list;
        OpenAPIServicesConfig openAPIsConfig = (OpenAPIServicesConfig)ConfigEnrichments$.MODULE$.RichConfig(config).rootAs(OpenAPIsConfig$.MODULE$.openAPIServicesConfigVR());
        try {
            list = this.discoverOpenAPIServices(config, openAPIsConfig);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable ex = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("OpenAPI service resolution failed. Will be used empty services lists", ex);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            List list2 = List$.MODULE$.empty();
            list = list2;
        }
        List serviceConfigs = list;
        return config.withValue("services", (ConfigValue)ConfigValueFactory.fromIterable((Iterable)((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter(serviceConfigs).asJava())));
    }

    private List<ConfigObject> discoverOpenAPIServices(Config config, OpenAPIServicesConfig openAPIsConfig) {
        BoxedUnit boxedUnit;
        String definition = IOUtils.toString((URL)((URL)Ficus$.MODULE$.toFicusConfig(config).as("url", Ficus$.MODULE$.javaURLReader())), (Charset)StandardCharsets.UTF_8);
        List<package.SwaggerService> services = SwaggerParser$.MODULE$.parse(definition, openAPIsConfig);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Discovered OpenAPI: {}", new Object[]{services.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), List$.MODULE$.canBuildFrom())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (List)services.map((Function1 & Serializable & scala.Serializable)service -> ConfigFactory.parseString((String)package.EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps(service), package$SwaggerService$.MODULE$.codecForSwaggerService()).spaces2()).root(), List$.MODULE$.canBuildFrom());
    }

    public List<ComponentDefinition> create(Config config, ProcessObjectDependencies dependencies) {
        OpenAPIServicesConfig openAPIsConfig = (OpenAPIServicesConfig)ConfigEnrichments$.MODULE$.RichConfig(config).rootAs(OpenAPIsConfig$.MODULE$.openAPIServicesConfigVR());
        String serviceDefinitionConfig = config.getList("services").render(ConfigRenderOptions.concise());
        List swaggerServices = (List)CirceUtil$.MODULE$.decodeJsonUnsafe(serviceDefinitionConfig, "Failed to parse service config", Decoder$.MODULE$.decodeList(package$SwaggerService$.MODULE$.codecForSwaggerService()));
        Map fixedParameters = Predef$.MODULE$.Map().empty();
        return ((TraversableOnce)new SwaggerEnrichers(openAPIsConfig.rootUrl(), this.prepareBaseEnricherCreator(config)).enrichers((List<package.SwaggerService>)swaggerServices, (List<String>)Nil$.MODULE$, (Map<String, Function0<Object>>)fixedParameters).map((Function1 & Serializable & scala.Serializable)service -> {
            String x$1 = service.name();
            EagerService x$2 = service.service();
            Option<String> x$3 = service.documentation();
            Option x$4 = ComponentDefinition$.MODULE$.apply$default$3();
            return new ComponentDefinition(x$1, (Component)x$2, x$4, x$3);
        }, Seq$.MODULE$.canBuildFrom())).toList();
    }

    public SwaggerEnricherCreator prepareBaseEnricherCreator(Config config) {
        HttpClientConfig clientConfig = (HttpClientConfig)Ficus$.MODULE$.toFicusConfig(config).getAs("httpClientConfig", Ficus$.MODULE$.optionValueReader(HttpClientConfig$.MODULE$.vr())).getOrElse((Function0 & Serializable & scala.Serializable)() -> DefaultHttpClientConfig$.MODULE$.apply());
        return SwaggerEnricherCreator$.MODULE$.apply(clientConfig);
    }

    public boolean isCompatible(NussknackerVersion version) {
        return true;
    }

    public OpenAPIComponentProvider() {
        ComponentProvider.$init$((ComponentProvider)this);
        LazyLogging.$init$((LazyLogging)this);
    }
}

