/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.processCounts.CannotFetchCountsError;
import pl.touk.nussknacker.processCounts.CountsReporter;
import pl.touk.nussknacker.processCounts.CountsRequest;
import pl.touk.nussknacker.processCounts.ExecutionCount;
import pl.touk.nussknacker.processCounts.RangeCount;
import pl.touk.nussknacker.processCounts.influxdb.InfluxBaseCountsReporter;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import sttp.client.SttpBackend;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001\u0002\u0007\u000e\u0001aA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\t_\u0001\u0011\t\u0011)A\u0005a!AA\u0007\u0001B\u0001B\u0003-Q\u0007C\u0003R\u0001\u0011\u0005!\u000bC\u0004Y\u0001\t\u0007I\u0011B-\t\r\u0011\u0004\u0001\u0015!\u0003[\u0011\u001d)\u0007A1A\u0005\n\u0019DaA\u001b\u0001!\u0002\u00139\u0007\"B6\u0001\t\u0003b\u0007bBA\u0005\u0001\u0011%\u00111\u0002\u0005\b\u0003G\u0001A\u0011BA\u0013\u0005QIeN\u001a7vq\u000e{WO\u001c;t%\u0016\u0004xN\u001d;fe*\u0011abD\u0001\tS:4G.\u001e=eE*\u0011\u0001#E\u0001\u000eaJ|7-Z:t\u0007>,h\u000e^:\u000b\u0005I\u0019\u0012a\u00038vgN\\g.Y2lKJT!\u0001F\u000b\u0002\tQ|Wo\u001b\u0006\u0002-\u0005\u0011\u0001\u000f\\\u0002\u0001'\r\u0001\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0001\nS\"A\b\n\u0005\tz!AD\"pk:$8OU3q_J$XM]\u0001\u0004K:4\bCA\u0013-\u001d\t1#\u0006\u0005\u0002(75\t\u0001F\u0003\u0002*/\u00051AH]8pizJ!aK\u000e\u0002\rA\u0013X\rZ3g\u0013\ticF\u0001\u0004TiJLgn\u001a\u0006\u0003Wm\taaY8oM&<\u0007CA\u00193\u001b\u0005i\u0011BA\u001a\u000e\u00051IeN\u001a7vq\u000e{gNZ5h\u0003\u001d\u0011\u0017mY6f]\u0012\u0004RAN\u001e>\u0007\u001ak\u0011a\u000e\u0006\u0003qe\naa\u00197jK:$(\"\u0001\u001e\u0002\tM$H\u000f]\u0005\u0003y]\u00121b\u0015;ua\n\u000b7m[3oIB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iG\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001\"@\u0005\u00191U\u000f^;sKB\u0011!\u0004R\u0005\u0003\u000bn\u0011qAT8uQ&tw\r\u0005\u0002H\u001d:\u0011\u0001\n\u0014\b\u0003\u0013.s!a\n&\n\u0003iJ!\u0001O\u001d\n\u00055;\u0014a\u00029bG.\fw-Z\u0005\u0003\u001fB\u0013\u0001BT8uQ&tw\r\u0016\u0006\u0003\u001b^\na\u0001P5oSRtDcA*W/R\u0011A+\u0016\t\u0003c\u0001AQ\u0001\u000e\u0003A\u0004UBQa\t\u0003A\u0002\u0011BQa\f\u0003A\u0002A\n\u0011\u0003Z1uKRKW.\u001a$pe6\fG\u000f^3s+\u0005Q\u0006CA.c\u001b\u0005a&BA/_\u0003\u00191wN]7bi*\u0011q\fY\u0001\u0005i&lWMC\u0001b\u0003\u0011Q\u0017M^1\n\u0005\rd&!\u0005#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\u0006\u0011B-\u0019;f)&lWMR8s[\u0006$H/\u001a:!\u0003IIgN\u001a7vq\n\u000b7/\u001a*fa>\u0014H/\u001a:\u0016\u0003\u001d\u0004\"!\r5\n\u0005%l!\u0001G%oM2,\bPQ1tK\u000e{WO\u001c;t%\u0016\u0004xN\u001d;fe\u0006\u0019\u0012N\u001c4mkb\u0014\u0015m]3SKB|'\u000f^3sA\u0005\u0001\u0002O]3qCJ,'+Y<D_VtGo\u001d\u000b\u0004[v|HC\u00018y!\rq\u0014i\u001c\t\u00055A$#/\u0003\u0002r7\tIa)\u001e8di&|g.\r\t\u00045M,\u0018B\u0001;\u001c\u0005\u0019y\u0005\u000f^5p]B\u0011!D^\u0005\u0003on\u0011A\u0001T8oO\")\u00110\u0003a\u0002u\u0006\u0011Qm\u0019\t\u0003}mL!\u0001` \u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"\u0002@\n\u0001\u0004!\u0013!\u00039s_\u000e,7o]%e\u0011\u001d\t\t!\u0003a\u0001\u0003\u0007\tQbY8v]R\u001c(+Z9vKN$\bc\u0001\u0011\u0002\u0006%\u0019\u0011qA\b\u0003\u001b\r{WO\u001c;t%\u0016\fX/Z:u\u0003I\u0001(/\u001a9be\u0016\u0014\u0016M\\4f\u0007>,h\u000e^:\u0015\u0011\u00055\u0011\u0011CA\n\u0003?!2A\\A\b\u0011\u0015I(\u0002q\u0001{\u0011\u0015q(\u00021\u0001%\u0011\u001d\t)B\u0003a\u0001\u0003/\t\u0001B\u001a:p[\u0012\u000bG/\u001a\t\u0005\u00033\tY\"D\u0001_\u0013\r\tiB\u0018\u0002\u000e\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\t\u000f\u0005\u0005\"\u00021\u0001\u0002\u0018\u00051Ao\u001c#bi\u0016\f1\"];fefLeN\u001a7vqRA\u0011qEA\u0016\u0003[\t\t\u0004F\u0002o\u0003SAQ!_\u0006A\u0004iDQA`\u0006A\u0002\u0011Bq!!\u0006\f\u0001\u0004\ty\u0003\u0005\u0003\u001bg\u0006]\u0001bBA\u0011\u0017\u0001\u0007\u0011q\u0003")
public class InfluxCountsReporter
implements CountsReporter {
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final InfluxBaseCountsReporter influxBaseReporter;

    private DateTimeFormatter dateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    private InfluxBaseCountsReporter influxBaseReporter() {
        return this.influxBaseReporter;
    }

    @Override
    public Future<Function1<String, Option<Object>>> prepareRawCounts(String processId, CountsRequest countsRequest, ExecutionContext ec) {
        Future<Function1<String, Option<Object>>> future;
        CountsRequest countsRequest2 = countsRequest;
        if (countsRequest2 instanceof RangeCount) {
            RangeCount rangeCount = (RangeCount)countsRequest2;
            LocalDateTime fromDate = rangeCount.fromDate();
            LocalDateTime toDate = rangeCount.toDate();
            future = this.prepareRangeCounts(processId, fromDate, toDate, ec);
        } else if (countsRequest2 instanceof ExecutionCount) {
            ExecutionCount executionCount = (ExecutionCount)countsRequest2;
            LocalDateTime pointInTime = executionCount.pointInTime();
            future = this.queryInflux(processId, (Option<LocalDateTime>)None$.MODULE$, pointInTime, ec);
        } else {
            throw new MatchError((Object)countsRequest2);
        }
        return future;
    }

    private Future<Function1<String, Option<Object>>> prepareRangeCounts(String processId, LocalDateTime fromDate, LocalDateTime toDate, ExecutionContext ec) {
        return this.influxBaseReporter().detectRestarts(processId, fromDate, toDate).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            List list = x0$1;
            Future future = Nil$.MODULE$.equals(list) ? this.queryInflux(processId, (Option<LocalDateTime>)new Some((Object)fromDate), toDate, ec) : Future$.MODULE$.failed((Throwable)new CannotFetchCountsError(new StringBuilder(75).append("Counts unavailable, as process was restarted/deployed on ").append(" following dates: ").append(((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.format(this.dateTimeFormatter()), List$.MODULE$.canBuildFrom())).mkString(", ")).toString()));
            return future;
        }, ec);
    }

    private Future<Function1<String, Option<Object>>> queryInflux(String processId, Option<LocalDateTime> fromDate, LocalDateTime toDate, ExecutionContext ec) {
        return this.influxBaseReporter().fetchBaseProcessCounts(processId, fromDate, toDate).map((Function1 & Serializable & scala.Serializable)pbc -> (Function1 & Serializable & scala.Serializable)nodeId -> pbc.getCountForNodeId((String)nodeId), ec);
    }

    public InfluxCountsReporter(String env, InfluxConfig config, SttpBackend<Future, Nothing$, ?> backend) {
        this.influxBaseReporter = new InfluxBaseCountsReporter(env, config, backend);
    }
}

